/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.sisobra;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.sisobra.DocumentosSisobraParaEnviarDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraDTO;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SisObraAlvaraRepositoryCustomImpl
implements SisObraAlvaraRepositoryCustom {
    private static final String SQL_FIND_DOCUMENTO_ALVARA = "br/com/elotech/tributos/repository/sisobra/find-documento-sisobra-alvara.sql";
    private static final String FILTRO_SELECIONADOS = "[FILTRO_SELECIONADOS]";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public SisObraAlvaraRepositoryCustomImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<SisObraAlvaraDTO> findDocumentoSisObraAlvara(DocumentosSisobraParaEnviarDTO dto, Pageable page) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DOCUMENTO_ALVARA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("dataInicial", (Object)dto.getFiltro().getDataInicial());
        params.addValue("dataFinal", (Object)dto.getFiltro().getDataFinal());
        sql = this.filtroTodosSelecionados(sql, dto);
        if (sql.contains(":ids")) {
            List idsSisobra = dto.getAlvaras().stream().map(SisObraAlvaraDTO::getIdSisObraAlvara).collect(Collectors.toList());
            params.addValue("ids", idsSisobra);
        }
        String sqlTotal = String.format("select count(*) as total from (%s) count_query", sql);
        Long total = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlTotal, (SqlParameterSource)params, (rs, rowNum) -> rs.getLong("total"));
        if (page.isPaged()) {
            sql = SqlUtils.withPagination((String)sql, (Pageable)page, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        }
        List documentos = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(SisObraAlvaraDTO.class));
        return new PageImpl(documentos, page, total.longValue());
    }

    public String filtroTodosSelecionados(String sql, DocumentosSisobraParaEnviarDTO dto) {
        if (Boolean.TRUE.equals(dto.getTodosSelecionados()) && !dto.getAlvaras().isEmpty()) {
            return sql.replace(FILTRO_SELECIONADOS, " AND soa.id NOT IN (:ids) ");
        }
        if (Boolean.FALSE.equals(dto.getTodosSelecionados()) && !dto.getAlvaras().isEmpty()) {
            return sql.replace(FILTRO_SELECIONADOS, " AND soa.id IN (:ids) ");
        }
        return sql.replace(FILTRO_SELECIONADOS, "");
    }
}

