/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.NrDisponivel;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.NrDividaCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NrDividaCustomRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    public static final String NOT_EXISTS_ATUALIZACAO = "where not exists (select 1 from tceatualizamonecredDA x where x.nrDivida = soma.nrDivida and x.nrAnoDivida = soma.nrAnoDivida and x.dtatualizacao = :dataLancamento)";
    public static final String NOT_EXISTS_DEDUCAO = "where not exists (select 1 from tcededucaocreditoDA x where x.nrDivida = soma.nrDivida and x.nrAnoDivida = soma.nrAnoDivida and x.dtatualizacao = :dataLancamento)";
    public static final String NOT_EXISTS_ARRECADACAO = "where not exists (select 1 from tceArrecadacaoTipoCredito x where x.nrDivida = soma.nrDivida and x.nrAnoDivida = soma.nrAnoDivida and ((x.nrAno < :nrAno) or (x.nrAno = :nrAno and x.nrMes = :nrMes)))";
    public static final String SQL_PATH = "sql/simam/manutencaoarquivo/atribuirNrDivida.sql";
    public static final String IGNORE_LINE = "--";

    public List<NrDisponivel> findExistentes(TipoRegistroSimAm tipoRegistroSimAm, Long idTipoCredito, LocalDate dataReferencia) {
        if (dataReferencia == null) {
            throw new EloValidationException("Data de lan\u00e7amento precisa ser informada");
        }
        return this.jdbcTemplate.query(this.sourceSqlFile(tipoRegistroSimAm), (SqlParameterSource)this.mountParameters(tipoRegistroSimAm, idTipoCredito, dataReferencia), (RowMapper)new ElotechBeanPropertyRowMapper(NrDisponivel.class));
    }

    private String sourceSqlFile(TipoRegistroSimAm tipoRegistroSimAm) {
        String sql = FileUtils.readResourceAsString((String)SQL_PATH);
        String filters = this.sourceFilters(tipoRegistroSimAm);
        return String.format(sql, filters);
    }

    private MapSqlParameterSource mountParameters(TipoRegistroSimAm tipoRegistroSimAm, Long idTipoCredito, LocalDate dataReferencia) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idTipoCredito", (Object)idTipoCredito, 2);
        parameters.addValue("dataLancamento", (Object)Date.valueOf(dataReferencia), 91);
        parameters.addValue("anoLancamento", (Object)dataReferencia.getYear(), 2);
        if (tipoRegistroSimAm.equals((Object)TipoRegistroSimAm.ARRECADACAO_TIPO_CREDITO)) {
            parameters.addValue("nrAno", (Object)dataReferencia.getYear(), 2);
            parameters.addValue("nrMes", (Object)dataReferencia.getMonthValue(), 2);
        }
        return parameters;
    }

    private String sourceFilters(TipoRegistroSimAm tipoRegistroSimAm) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[tipoRegistroSimAm.ordinal()]) {
            case 1: {
                return NOT_EXISTS_ATUALIZACAO;
            }
            case 2: {
                return NOT_EXISTS_DEDUCAO;
            }
            case 3: {
                return NOT_EXISTS_ARRECADACAO;
            }
        }
        return IGNORE_LINE;
    }

    @Generated
    public NrDividaCustomRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

