/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.repository.simam.MovimentacaoMensalCustomRepository;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class MovimentacaoMensalCustomRepositoryImpl
implements MovimentacaoMensalCustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public MovimentacaoMensalCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Transactional
    public void clearMovimentacao(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        Object sql = this.getSqlFromFile();
        MapSqlParameterSource params = this.getSqlParams(entidade, dataInicial, dataFinal);
        if (Month.JANUARY.equals(dataInicial.getMonth())) {
            sql = (String)sql + this.getSqlRemoverImplantacaoSaldo();
            params.addValue("exercicio", (Object)dataInicial.getYear());
        }
        this.namedParameterJdbcTemplate.getJdbcTemplate();
        this.namedParameterJdbcTemplate.execute((String)sql, (SqlParameterSource)params, PreparedStatement::executeLargeUpdate);
    }

    private String getSqlRemoverImplantacaoSaldo() {
        return FileUtils.readResourceAsString((String)"sql/simam/movimentacaoMensalImplantacaoSaldoBatchClear.sql");
    }

    private String getSqlFromFile() {
        return FileUtils.readResourceAsString((String)"sql/simam/movimentacaoMensalBatchClear.sql");
    }

    private MapSqlParameterSource getSqlParams(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        Map params = this.createSqlParams(entidade, dataInicial, dataFinal);
        return new MapSqlParameterSource().addValues(params);
    }

    private Map<String, ?> createSqlParams(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        LocalDate dataFinalAux = this.getDataFinalAux(dataInicial, dataFinal);
        List mesesParaDeletar = this.getMesesParaDeletar(dataInicial, dataFinalAux);
        return Map.of("entidade", entidade, "dataInicial", Date.valueOf(dataInicial), "dataFinal", Date.valueOf(dataFinalAux), "meses", mesesParaDeletar, "ano", dataInicial.getYear());
    }

    private LocalDate getDataFinalAux(LocalDate dataInicial, LocalDate dataFinal) {
        return dataInicial.getMonth().equals(Month.JANUARY) && dataFinal.getMonth().equals(Month.JANUARY) ? LocalDate.of(dataInicial.getYear(), Month.DECEMBER, 31) : dataFinal;
    }

    private List<Integer> getMesesParaDeletar(LocalDate dataInicial, LocalDate dataFinal) {
        if (!dataInicial.getMonth().equals(Month.JANUARY)) {
            return Collections.singletonList(dataInicial.getMonthValue());
        }
        ArrayList<Integer> mesesParaDeletar = new ArrayList<Integer>();
        for (int mes = dataInicial.getMonthValue(); mes <= dataFinal.getMonthValue(); ++mes) {
            mesesParaDeletar.add(mes);
        }
        return mesesParaDeletar;
    }
}

