/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.simam.EstornoLancamentoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.EstornoLancamentoCreditoDTO;
import br.com.elotech.tributos.repository.simam.EstornoLancamentoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstornoLancamentoCreditoCustomRepositoryImpl
implements EstornoLancamentoCreditoCustomRepository {
    private static final String PESSOA = "idPessoa";
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String SQLUPDATEVALORFINAL = FileUtils.readResourceAsString((String)"sql/simam/estornoLancamentoCreditoAttValorFinal.sql");
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstornoLancamentoCreditoDTO> findEstornos(Entidade entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)entidade.getIdentificacaoTce());
        parameters.addValue(ENTIDADE, (Object)entidade.getId());
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/estornoLancamentoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoLancamentoCreditoDTO.class));
    }

    public List<EstornoLancamentoCreditoCargaExistenteDTO> getCargaExistenteEstornoLancamentoCredito(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/estornoLancamentoCreditoCargaExistente.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoLancamentoCreditoCargaExistenteDTO.class));
    }

    @Generated
    public EstornoLancamentoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

