/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.simam.EstornoAtualizacaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoDACustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstornoAtualizacaoMonetariaCreditoDACustomRepositoryImpl
implements EstornoAtualizacaoMonetariaCreditoDACustomRepository {
    private static final String PESSOA = "idPessoa";
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstornoAtualizacaoDividaAtivaDTO> findEstornos(Entidade entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)entidade.getIdentificacaoTce());
        parameters.addValue(ENTIDADE, (Object)entidade.getId());
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/estornoAtualizacaoDALancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoAtualizacaoDividaAtivaDTO.class));
    }

    public List<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> findEstornosMa(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/manutencaoarquivo/estornoAtualizacaoMonetariaCreditoDividaAtivaMa.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO.class));
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoDACustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

