/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobiliario;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepositoryCustom;
import br.com.elotech.tributos.repository.projections.CadastroMobiliarioAlvaraVencidoProjection;
import br.com.elotech.tributos.repository.projections.CadastroMobiliarioSolicitacaoAlvaraProjection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CadastroMobiliarioRepository
extends CrudRepository<CadastroMobiliario, Long>,
CadastroMobiliarioRepositoryCustom {
    public List<CadastroMobiliario> findByPessoaCnpjCpf(String var1);

    public CadastroMobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro var1, Long var2);

    public List<CadastroMobiliario> findByPessoaId(Long var1);

    public List<CadastroMobiliario> findByPessoaNome(String var1);

    public List<CadastroMobiliario> findByNumeroAlvaraAndExercicioAlvara(Long var1, Long var2);

    public List<CadastroMobiliario> findByDataAlteracaoBetween(LocalDate var1, LocalDate var2);

    public List<CadastroMobiliario> findByDataInclusaoBetween(LocalDate var1, LocalDate var2);

    @Query(value="SELECT cm from CadastroMobiliario cm WHERE (cm.horaInclusao BETWEEN :dataHoraInicial AND :dataHoraFinal OR cm.horaAlteracao BETWEEN :dataHoraInicial AND :dataHoraFinal)")
    public List<CadastroMobiliario> findCnpjsPorPeriodo(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT cm.id as cadastroMobiliarioId, cms.id as situacaoAtualId, cms.sequencia as situacaoSequencia FROM CadastroMobiliario cm LEFT JOIN cm.cadastroMobiliarioSituacoes cms WHERE cms.atual = true AND cm.dataValidadeAlvara < :dataReferencia AND cm.dataValidadeAlvara IS NOT NULL AND cms.situacaoMobiliario.tipoSituacaoMobiliario.id = 0 AND cms.situacaoMobiliario.id != :situacaoMobiliarioId")
    public List<CadastroMobiliarioAlvaraVencidoProjection> findCadastroMobiliarioComAlvaraVencido(@Param(value="situacaoMobiliarioId") Long var1, @Param(value="dataReferencia") LocalDate var2);

    @Query(value="select exercicio, numerosolicitacao, protocoloredesim from tribsolicitacaoalvara where tipocadastromobiliario = 2 and cadastrogeralmobiliario = :cadastrogeralmobiliario and efetivado = 'S' order by solicitacaoalvara desc", nativeQuery=true)
    public List<CadastroMobiliarioSolicitacaoAlvaraProjection> findSolicitacoesAlvara(@Param(value="cadastrogeralmobiliario") Long var1);
}

