/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialCustomRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface IntegracaoPatrimonialRepository
extends CrudRepository<IntegracaoPatrimonial, Long>,
IntegracaoPatrimonialCustomRepository {
    public IntegracaoPatrimonial findByEntidadeAndDataMovimento(Long var1, LocalDate var2);

    @Query(value="select new br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO(i.id, ii.tipoMovimento, sum(ii.valor)) from IntegracaoPatrimonial i inner join i.itens ii where i.id = :id group by ii.tipoMovimento, i.id")
    public List<IntegracaoPatrimonialPorTipoMovimentoDTO> findTotaisPorTipoMovimentoAndId(@Param(value="id") Long var1);

    @Modifying(clearAutomatically=true, flushAutomatically=true)
    @Query(value="UPDATE itemintegracaopatrimonial SET entidadebaixa = (    SELECT CASE         WHEN tc.entidaderegistro IS NULL THEN 1         ELSE tc.entidaderegistro     END     FROM integracaopatrimonial i         INNER JOIN tribdebitoparcelareceita tb             ON tb.iddebitoparcelareceita = itemintegracaopatrimonial.iddebitoparcelareceita         LEFT OUTER JOIN tribguiarecolhimentoformapag guiaforma             ON guiaforma.guiarecolhimento = tb.guiarecolhimento             AND guiaforma.entidade = tb.entidade             AND guiaforma.exercicio = EXTRACT(YEAR FROM i.datamovimento)             AND guiaforma.formapagamento = 2         INNER JOIN tribmodelobloqueto modt             ON modt.modelobloqueto = guiaforma.modelobloqueto         INNER JOIN tribconvenio tc             ON tc.convenio = modt.convenio             AND tc.entidade = i.entidade     WHERE itemintegracaopatrimonial.idintegracaopatrimonial = i.id         AND i.id = :idIntegracaoPatrimonial ) WHERE idintegracaopatrimonial IN (    SELECT it.idintegracaopatrimonial     FROM integracaopatrimonial i         INNER JOIN itemintegracaopatrimonial it             ON it.idintegracaopatrimonial = i.id     WHERE i.id = :idIntegracaoPatrimonial )", nativeQuery=true)
    public void updateItensPatrimonialPorEntidade(@Param(value="idIntegracaoPatrimonial") Long var1);
}

