/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoConsultaDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorDiarioArrecadacaoDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DiarioArrecadacaoRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiarioArrecadacaoRepository.class);
    private static final String QUERY_DIARIO = "br/com/elotech/tributos/repository/integracaocontabil/find-diario-arrecadacao.sql";
    private static final String ENTIDADE = "entidade";
    private static final String SELECT_CLAUSE = "lotecontabil.datalote as dataArrecadacao,\n       lotecontabil.tipolote as tipoMovimento,\n       lotecontabil.id as idLote, \n       case when pessoa.tipopessoa = 'J' then 'JURIDICA' \n            else 'FISICA' \n       end as tipoPessoa \n,       pessoa.cnpj_cpf as cpfCnpj,\n       pessoa.nome,\n       debito.tipocadastro,\n       debito.cadastrogeral,\n       debito.iddebito,\n       receitatipo.tiporeceita as idTipoTributo,\n       receitatipo.descricao as descricaoTipoTributo,\n       receita.receita as codigoTributo,\n       operacaolote.codigotce as codigoTipoOperacaoDeducao,\n       operacaolote.descricao as descricaoTipoOperacaoDeducao,\n       itemcontabil.id as idLoteItemIntegracaoContabil,\n       itemcontabil.idtipooperacaodeducao as idTipoOperacaoDeducao,\n       itemcontabil.situacaolegal as situacaoLegal,\n       'OUTRAS_RECEITAS' as tipoOrigemReceita,\n       case when itemcontabil.classificacaotributo = 'P' then 'PRINCIPAL' \n            when itemcontabil.classificacaotributo = 'J' then 'JUROS' \n            when itemcontabil.classificacaotributo = 'M' then 'MULTA' \n            when itemcontabil.classificacaotributo = 'C' then 'CORRECAO' \n            when itemcontabil.classificacaotributo = 'F' then 'JUROS_FINANCIAMENTO' \n            else null \n       end as classificacaotributo \n,       itemcontabil.valortributo,\n       itemcontabil.valordeducao";
    private static final String ORDERBY_CLAUSE = "order by lotecontabil.datalote,\n       pessoa.nome,\n       debito.cadastrogeral,\n       receitatipo.tiporeceita,\n       debito.exercicio,\n       debito.guiarecolhimento,\n       debito.subdivida";
    private static final String SELECT_TOTAL_CLAUSE = "sum(coalesce(itemcontabil.valortributo, 0)) as valorTributo,\n       sum(coalesce(itemcontabil.valordeducao, 0)) as valorDeducao";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DiarioArrecadacaoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<DiarioArrecadacaoConsultaDTO> findAllDiariosArrecadacao(FiltroDiarioArrecadacaoDTO filtro, Long entidade) {
        MapSqlParameterSource parameters = this.getMapSqlParameterSource(filtro, entidade);
        String sql = String.format(FileUtils.readResourceAsString((String)QUERY_DIARIO), SELECT_CLAUSE, filtro.buildWhereClause(), ORDERBY_CLAUSE);
        log.debug("Query do di\u00e3rio de arrecada\u00e7\u00e3o sem pagina\u00e7\u00e3o: {} - Parametros: {}", (Object)sql, (Object)parameters);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DiarioArrecadacaoConsultaDTO.class));
    }

    private MapSqlParameterSource getMapSqlParameterSource(FiltroDiarioArrecadacaoDTO filtro, Long entidade) {
        MapSqlParameterSource parameters = filtro.buildMapSqlParameter();
        parameters.addValue(ENTIDADE, (Object)entidade);
        return parameters;
    }

    public Page<DiarioArrecadacaoConsultaDTO> findDiariosArrecadacao(FiltroDiarioArrecadacaoDTO filtro, Long entidade, Pageable pageable) {
        MapSqlParameterSource parameters = this.getMapSqlParameterSource(filtro, entidade);
        String sql = String.format(FileUtils.readResourceAsString((String)QUERY_DIARIO), SELECT_CLAUSE, filtro.buildWhereClause(), ORDERBY_CLAUSE);
        String sqlCountTotal = String.format("select count(*) as total from (%s) count_query", sql);
        Long total = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlCountTotal, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlWithPagination = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        log.debug("Query do di\u00e3rio de arrecada\u00e7\u00e3o com pagina\u00e7\u00e3o: {} - Parametros: {}", (Object)sql, (Object)parameters);
        List resultQuery = this.namedParameterJdbcTemplate.query(sqlWithPagination, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DiarioArrecadacaoConsultaDTO.class));
        return new PageImpl(resultQuery, pageable, total.longValue());
    }

    public TotalizadorDiarioArrecadacaoDTO getTotalizador(FiltroDiarioArrecadacaoDTO filtro, Long entidade) {
        MapSqlParameterSource parameters = filtro.buildMapSqlParameter();
        parameters.addValue(ENTIDADE, (Object)entidade);
        String sql = String.format(FileUtils.readResourceAsString((String)QUERY_DIARIO), SELECT_TOTAL_CLAUSE, filtro.buildWhereClause(), "");
        log.debug("Query do totalizador do di\u00e3rio de arrecada\u00e7\u00e3o: {} - Parametros: {}", (Object)sql, (Object)parameters);
        return (TotalizadorDiarioArrecadacaoDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TotalizadorDiarioArrecadacaoDTO.class));
    }
}

