/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.deducaoanaliticacontribuinte.DeducaoAnaliticaContribuinteConsultaDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDeducaoAnaliticaContribuinteDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeducaoAnaliticaContribuinteRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeducaoAnaliticaContribuinteRepository.class);
    private static final String QUERY_DEDUCAO_ANALITICA_CONTRIBUINTE = "br/com/elotech/tributos/repository/integracaocontabil/deducao-analitica-contribuinte.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DeducaoAnaliticaContribuinteRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<DeducaoAnaliticaContribuinteConsultaDTO> findAllDeducoesAnaliticasContribuinte(FiltroDeducaoAnaliticaContribuinteDTO filtroDeducaoAnaliticaContribuinteDTO) {
        MapSqlParameterSource parameters = filtroDeducaoAnaliticaContribuinteDTO.buildMapSqlParameter();
        LOGGER.info("Efetuando a consulta das dedu\u00e7\u00f5es anal\u00edticas dos contribuintes com os par\u00e2metros: [{}]", (Object)parameters);
        String sqlDeducaoAnaliticaContribuinte = String.format(FileUtils.readResourceAsString((String)QUERY_DEDUCAO_ANALITICA_CONTRIBUINTE), filtroDeducaoAnaliticaContribuinteDTO.buildWhereClauseDeducao(), filtroDeducaoAnaliticaContribuinteDTO.buildWhereClauseInsencoes(), filtroDeducaoAnaliticaContribuinteDTO.buildWhereClauseDescontos());
        return this.namedParameterJdbcTemplate.query(sqlDeducaoAnaliticaContribuinte, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoAnaliticaContribuinteConsultaDTO.class));
    }
}

