/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ArrecadacaoPorDadosCadastraisFiltros;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisRowDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisTotaisDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoPorDadosCadastraisRepository {
    private static final String CONSULTA_ARRECADACAO_DADOS_CADASTRAIS_BASE = "br/com/elotech/tributos/repository/integracaocontabil/consulta-arrecadacao-por-dados-cadastrais-base.sql";
    private final String WHERE_FILTER = "[WHERE_FILTER]";
    private final JdbcTemplate jdbcTemplate;

    public Page<ArrecadacaoPorDadosCadastraisDTO> findArrecadacaoPorDadosCadastrais(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) {
        String sqlBase = FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_DADOS_CADASTRAIS_BASE);
        String sql = String.format("select  tdpr.tipocadastro AS tipoCadastro,  tdpr.cadastrogeral AS cadastroGeral,  tcg.idkey as idCadastroGeral,  pessoa.nome AS contribuinte %s  group by 1, 2, 3, 4 ", sqlBase);
        String sqlWithFilters = this.applyFilters(sql, filtros);
        String sqlCounter = String.format("select count(*) as total from (%s) count_query", sqlWithFilters);
        Long totalResults = (Long)this.jdbcTemplate.queryForObject(sqlCounter, (rs, rowNum) -> rs.getLong("total"));
        String sqlOrderBy = String.format("%s order by tdpr.tipocadastro, tdpr.cadastrogeral", sqlWithFilters);
        String sqlWithPagination = SqlUtils.withPagination((String)sqlOrderBy, (Pageable)pageable, (DataSource)this.jdbcTemplate.getDataSource());
        List registros = this.jdbcTemplate.query(sqlWithPagination, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorDadosCadastraisDTO.class));
        return new PageImpl(registros, pageable, totalResults.longValue());
    }

    public ArrecadacaoPorDadosCadastraisTotaisDTO findTotaisArrecadacaoPorDadosCadastrais(ArrecadacaoPorDadosCadastraisFiltros filtros) {
        String sqlBase = FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_DADOS_CADASTRAIS_BASE);
        String sql = String.format("select  SUM(tdpr.valororiginal) AS valorOriginal,  SUM(tdpr.valor) AS valorLiquido,  SUM(tdpr.valorjuros) AS valorJuros,  SUM(tdpr.valormulta) AS valorMulta,  SUM(tdpr.valorcorrecao) AS valorCorrecao,  SUM(tdpr.valordesconto) AS valorDesconto %s ", sqlBase);
        String sqlWithParameters = this.applyFilters(sql, filtros);
        return (ArrecadacaoPorDadosCadastraisTotaisDTO)this.jdbcTemplate.queryForObject(sqlWithParameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorDadosCadastraisTotaisDTO.class));
    }

    public List<ArrecadacaoPorDadosCadastraisRowDTO> findArrecadacaoPorDadosCadastraisArquivo(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) {
        String idCadastros = this.findArrecadacaoPorDadosCadastrais(filtros, pageable).stream().map(ArrecadacaoPorDadosCadastraisDTO::getIdCadastroGeral).map(String::valueOf).collect(Collectors.joining(","));
        String sqlBase = FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_DADOS_CADASTRAIS_BASE);
        String sql = String.format("select     tdpr.tipocadastro AS tipoCadastro,     tdpr.cadastrogeral AS cadastroGeral,     tcg.idkey as idCadastroGeral,     pessoa.nome AS contribuinte,     tr.descricao AS tributo,     SUM(tdpr.valororiginal) AS valorOriginal,     SUM(tdpr.valor) AS valorLiquido,     SUM(tdpr.valorjuros) AS valorJuros,     SUM(tdpr.valormulta) AS valorMulta,     SUM(tdpr.valorcorrecao) AS valorCorrecao,     SUM(tdpr.valordesconto) AS valorDesconto %s   and tcg.idkey in (%s)  group by 1,2,3,4,5  order by 1,2,4,5 ", this.applyFilters(sqlBase, filtros), idCadastros);
        return this.jdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorDadosCadastraisRowDTO.class));
    }

    private String applyFilters(String sql, ArrecadacaoPorDadosCadastraisFiltros filtros) {
        String whereClauses = filtros.getWhereClausesWithValues();
        if (!whereClauses.isEmpty()) {
            return sql.replace("[WHERE_FILTER]", String.format(" WHERE %s ", whereClauses));
        }
        return sql.replace("[WHERE_FILTER]", " WHERE 1=1 ");
    }

    public List<ArrecadacaoPorTributoValoresDTO> findTributosByCadastro(Long tipocadastro, Long cadastrogeral, ArrecadacaoPorDadosCadastraisFiltros filtros) {
        String sqlBase = FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_DADOS_CADASTRAIS_BASE);
        String sql = String.format("select     tr.descricao AS tributo,     SUM(tdpr.valororiginal) AS valorPrincipal,     SUM(tdpr.valor) AS valorLiquido,     SUM(tdpr.valorjuros) AS valorJuros,     SUM(tdpr.valormulta) AS valorMulta,     SUM(tdpr.valorcorrecao) AS valorCorrecao,     SUM(tdpr.valordesconto) AS valorDesconto %s   and tcg.tipocadastro = %d  and tcg.cadastrogeral = %d  group by 1  order by 1 ", this.applyFilters(sqlBase, filtros), tipocadastro, cadastrogeral);
        return this.jdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorTributoValoresDTO.class));
    }

    @Generated
    public ArrecadacaoPorDadosCadastraisRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

