/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCancelamentoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCreditoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaTributoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoGeracaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelasConsultaDTO;
import br.com.elotech.tributos.dto.DebitoTributoConsultaDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.documento.cda.DebitoGeracaoCdaDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoDebitoOrigemDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoOrigemDTO;
import br.com.elotech.tributos.repository.DebitoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoRepositoryImpl
implements DebitoCustomRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebitoRepositoryImpl.class);
    private static final String ID = "id";
    private static final String ENTIDADE = "entidade";
    private static final String FILTROS = "$[FILTROS]";
    private static final String EXERCICIO = "exercicio";
    private static final String TIPOCADASTRO = "tipoCadastro";
    private static final String CADASTROGERAL = "cadastroGeral";
    private static final String DIVIDA = "divida";
    private static final String SUBDIVIDA = "subdivida";
    private static final String PARCELA = "parcela";
    private static final String SQL_EXISTS_DEBITO_ABERTO = "br/com/elotech/tributos/repository/mobile/existsDebitoEmAberto.sql";
    private static final String SQL_FIND_DEBITO = "br/com/elotech/tributos/repository/find-debito.sql";
    private static final String SQL_FIND_DEBITOS_PARCELAS = "br/com/elotech/tributos/repository/find-debito-parcelas.sql";
    private static final String SQL_FIND_PARCELA_DEBITOS = "br/com/elotech/tributos/repository/find-parcela-por-debitos.sql";
    private static final String SQL_FIND_DEBITOS_TRIBUTOS = "br/com/elotech/tributos/repository/find-debito-tributo.sql";
    private static final String SQL_FIND_DEBITO_CANCELAMENTO_PARCELA = "br/com/elotech/tributos/repository/find-debito-cancelamento-parcela.sql";
    private static final String SQL_FIND_CREDITOS = "br/com/elotech/tributos/repository/find-debito-creditos.sql";
    private static final String SQL_FIND_TRIBUTOS = "br/com/elotech/tributos/repository/find-debito-tributos-parcelas.sql";
    private static final String SQL_FIND_DEBITOS_GERACAO_CDA = "br/com/elotech/tributos/repository/find-debito-geracao-cda.sql";
    private static final String SQL_FIND_DEBITOS_ID_RELACIONADO_PAGAMENTO = "br/com/elotech/tributos/repository/find-debitos-id-relacionado-pagamento.sql";
    private static final String SQL_FIND_DEBITOS_CONSTITUIDOS = "br/com/elotech/tributos/repository/find-debito-constituido.sql";
    private static final String SQL_FIND_DEBITOS_DA_AVULSA = "br/com/elotech/tributos/repository/find-debito-divida-ativa-avulsa.sql";
    private static final String SQL_FIND_DEBITOS_GERACAO_DA_AVULSA = "br/com/elotech/tributos/repository/find-debito-geracao-cda-avulsa.sql";
    private static final String SQL_FIND_RECEITAS_VALORES = "br/com/elotech/tributos/repository/find-receita-valores-debito.sql";
    private static final String SQL_FIND_RECEITAS_CONSULTA_DEBITOS = "br/com/elotech/tributos/repository/find-receitas-consulta-debito.sql";
    private static final String SQL_FIND_PARCELAMENTO_DEBITO_ORIGEM = "br/com/elotech/tributos/repository/find-parcelamento-debito-origem.sql";
    private static final String SQL_FIND_ESTORNO_PARCELAMENTO_DEBITO = "br/com/elotech/tributos/repository/find-estorno-parcelamento-debito.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public DebitoConsultaDTO findDebitoConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return (DebitoConsultaDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaDTO.class));
    }

    public DebitoDetalheParcelasDTO findDebitosParcelasByIdAndParcela(Long id, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_PARCELA_DEBITOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        params.addValue(PARCELA, (Object)parcela);
        return (DebitoDetalheParcelasDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoDetalheParcelasDTO.class));
    }

    public List<DebitoParcelasConsultaDTO> findDebitosParcelasConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_PARCELAS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelasConsultaDTO.class));
    }

    public List<DebitoTributoConsultaDTO> findDebitosTributosConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_TRIBUTOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoTributoConsultaDTO.class));
    }

    public List<DebitoConsultaCreditoPorParcelaDTO> findCreditosPorParcelas(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CREDITOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)debito.getEntidade());
        params.addValue(TIPOCADASTRO, (Object)debito.getTipoCadastro());
        params.addValue(CADASTROGERAL, (Object)debito.getCadastroGeralId());
        params.addValue(DIVIDA, (Object)debito.getGuiaRecolhimento());
        params.addValue(SUBDIVIDA, (Object)debito.getSubDivida());
        params.addValue(PARCELA, (Object)parcela);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaCreditoPorParcelaDTO.class));
    }

    public List<DebitoConsultaTributoPorParcelaDTO> findTributosPorParcelas(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_TRIBUTOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(EXERCICIO, (Object)debito.getExercicio());
        params.addValue(ENTIDADE, (Object)debito.getEntidade());
        params.addValue(CADASTROGERAL, (Object)debito.getCadastroGeralId());
        params.addValue(TIPOCADASTRO, (Object)debito.getTipoCadastro());
        params.addValue(PARCELA, (Object)parcela);
        params.addValue(DIVIDA, (Object)debito.getGuiaRecolhimento());
        params.addValue(SUBDIVIDA, (Object)debito.getSubDivida());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaTributoPorParcelaDTO.class));
    }

    public Boolean possuiDebitosVencidos(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXISTS_DEBITO_ABERTO);
        MapSqlParameterSource params = new MapSqlParameterSource("cnpjCpf", (Object)cpfCnpj);
        params.addValue("dataBase", (Object)Date.valueOf(LocalDate.now()));
        try {
            return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (rs, rowNum) -> rs.getBoolean("existe"));
        }
        catch (EmptyResultDataAccessException ex) {
            return false;
        }
    }

    public List<Long> findPagos(@Param(value="ids") List<Long> ids) {
        String sql = "select td.iddebito      from tribdebito td     where td.iddebito in (:ids)       and not exists (select 1                         from tribdebitoparcela tdp                        inner join tribsituacaoparcela tsp      on tdp.situacaodebito = tsp.situacaoparcela                        inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                        where td.entidade = tdp.entidade                          and td.exercicio = tdp.exercicio                          and td.tipocadastro = tdp.tipocadastro                          and td.cadastrogeral = tdp.cadastrogeral                          and td.guiarecolhimento = tdp.guiarecolhimento                          and td.subdivida = tdp.subdivida                          and ttsp.tiposituacaoparcela <> 2)       and exists (select 1                         from tribdebitoparcela tdp                        inner join tribsituacaoparcela tsp      on tdp.situacaodebito = tsp.situacaoparcela                        inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                        where td.entidade = tdp.entidade                          and td.exercicio = tdp.exercicio                          and td.tipocadastro = tdp.tipocadastro                          and td.cadastrogeral = tdp.cadastrogeral                          and td.guiarecolhimento = tdp.guiarecolhimento                          and td.subdivida = tdp.subdivida                          and ttsp.tiposituacaoparcela = 2) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", ids);
        return this.namedParameterJdbcTemplate.queryForList(sql, (SqlParameterSource)parameters, Long.class);
    }

    public List<DebitoDTO> findDebitoComParcelaEmAberto(@Param(value="idParcelamento") Long idParcelamento) {
        String sql = "select TribDebito.Entidade,                            TribDebito.Exercicio,                            TribDebito.TipoCadastro,                            TribDebito.CadastroGeral,                            TribDebito.GuiaRecolhimento,                            TribDebito.SubDivida,                            MAX(CASE                                WHEN dp.situacaolegal NOT IN (0, 1) THEN 1                                ELSE 0                             END) AS ExisteDebitoJudicial,                            Count(dp.parcela) as NumeroParcelas                       from Tribparcelamentodebitoorigem Tribparcelamentodebitoorigem                       left outer join TribDebito TribDebito on TribDebito.Iddebito = Tribparcelamentodebitoorigem.Iddebitonovo                       left outer join TribDebitoParcela dp on TribDebito.Entidade = dp.Entidade                                                           and TribDebito.Exercicio = dp.Exercicio                                                           and TribDebito.Tipocadastro = dp.Tipocadastro                                                           and TribDebito.Cadastrogeral = dp.Cadastrogeral                                                           and TribDebito.Guiarecolhimento = dp.Guiarecolhimento                                                           and TribDebito.Subdivida = dp.Subdivida                       left outer join tribSituacaoParcela tsp on dp.Situacaodebito = tsp.SituacaoParcela                       left outer join tribTipoSituacaoParcela ttsp on tsp.Tiposituacaoparcela = ttsp.Tiposituacaoparcela                      Where Tribparcelamentodebitoorigem.Idparcelamento = :idParcelamento                        and ttsp.Tipo = 'A'                      Group by TribDebito.Entidade,                               TribDebito.Exercicio,                               TribDebito.TipoCadastro,                               TribDebito.CadastroGeral,                               TribDebito.GuiaRecolhimento,                              TribDebito.SubDivida                      Order by TribDebito.Entidade,                               TribDebito.Exercicio,                               TribDebito.TipoCadastro,                               TribDebito.CadastroGeral,                               TribDebito.GuiaRecolhimento,                               TribDebito.SubDivida ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idParcelamento", (Object)idParcelamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (rs, rowNum) -> {
            DebitoDTO debitoDTO = new DebitoDTO();
            debitoDTO.setEntidade(Integer.valueOf(rs.getInt(ENTIDADE)));
            debitoDTO.setExercicio(Integer.valueOf(rs.getInt(EXERCICIO)));
            debitoDTO.setTipoCadastro(Integer.valueOf(rs.getInt("tipocadastro")));
            debitoDTO.setCadastroGeral(Integer.valueOf(rs.getInt("cadastrogeral")));
            debitoDTO.setGuiaRecolhimento(Integer.valueOf(rs.getInt("guiarecolhimento")));
            debitoDTO.setSubDivida(Integer.valueOf(rs.getInt(SUBDIVIDA)));
            debitoDTO.setNumeroParcelas(Integer.valueOf(rs.getInt("numeroparcelas")));
            debitoDTO.setExisteDebitoJudicial(Boolean.valueOf(rs.getBoolean("existedebitojudicial")));
            return debitoDTO;
        });
    }

    public List<DebitoConsultaCancelamentoPorParcelaDTO> findCancelamentosPorParcela(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITO_CANCELAMENTO_PARCELA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("Entidade", (Object)debito.getEntidade());
        params.addValue("Exercicio", (Object)debito.getExercicio());
        params.addValue("TipoCadastro", (Object)debito.getTipoCadastro());
        params.addValue("CadastroGeral", (Object)debito.getCadastroGeralId());
        params.addValue("GuiaRecolhimento", (Object)debito.getGuiaRecolhimento());
        params.addValue("SubDivida", (Object)debito.getSubDivida());
        params.addValue("Parcela", (Object)parcela);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaCancelamentoPorParcelaDTO.class));
    }

    public List<DebitoGeracaoCdaDTO> findDebitosGeracaoCDA(String filtro, Long entidade) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_GERACAO_CDA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)entidade);
        String finalSql = sql.replace(FILTROS, filtro);
        return this.namedParameterJdbcTemplate.query(finalSql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoGeracaoCdaDTO.class));
    }

    public List<DebitoIdDTO> findDebitosIdRelacionadosPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_ID_RELACIONADO_PAGAMENTO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue("exercicioPagamento", (Object)exercicioPagamento);
        params.addValue("pagamento", (Object)pagamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }

    public Long totalDebitosConstituidos(FiltroConsultaDebitoDTO filtro) {
        String count = "select count(TOTAL) as TOTAL from ( %s ) as x";
        String select = "SELECT TD.IDDEBITO AS TOTAL ";
        String fromTemplate = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS);
        String query = String.format(fromTemplate, select, filtro.generateJoins(), filtro.generateWhereWithCte(), filtro.buildGroupBy());
        query = String.format(count, query);
        if (filtro.utilizaCte()) {
            query = filtro.buildCte(fromTemplate).concat(query);
        }
        log.debug("totalDebitosConstituidos - SQL utilizado nos totais de d\u00e9bitos para consulta de d\u00e9bitos: {}", (Object)query);
        List total = this.namedParameterJdbcTemplate.query(query, (rs, rowNum) -> rs.getLong("TOTAL"));
        return total.stream().findFirst().orElse(0L);
    }

    public List<DebitoConstituidoItemDTO> findAllDebitoConstituidoById(FiltroConsultaDebitoDTO filtro, Long idDebito) {
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS), this.getSelectFields(), filtro.generateJoins(Boolean.TRUE.booleanValue()), filtro.generateWhere(idDebito), this.getOrderByFields());
        log.trace("findAllDebitoConstituidoById - SQL utilizado para consulta de d\u00e9bitos: {}", (Object)sql);
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConstituidoItemDTO.class));
    }

    public List<DebitoDividaAtivaAvulsaDTO> findDebitosDividaAtivaAvulsa(FiltroConsultaDebitoDividaAtivaAvulsaDTO filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_DA_AVULSA);
        sql = sql.replace(FILTROS, filtro.generateWhere());
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoDividaAtivaAvulsaDTO.class));
    }

    public List<DebitoGeracaoDividaAtivaAvulsaDTO> findDebitogeracaoCDAAvulsa(DebitoDividaAtivaAvulsaDTO debito, Long entidade) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_GERACAO_DA_AVULSA);
        sql = sql.replace(FILTROS, debito.generateParams());
        MapSqlParameterSource params = this.getParameterDebito(debito);
        params.addValue(ENTIDADE, (Object)entidade);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoGeracaoDividaAtivaAvulsaDTO.class));
    }

    public List<ComunicadoConsultaReceitas> findIdDebitoParcelaAndValoresTributoByIdDebito(Long tipoCadastro, Long cadastroGeral, Long livro, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_RECEITAS_VALORES);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(TIPOCADASTRO, (Object)tipoCadastro);
        params.addValue(CADASTROGERAL, (Object)cadastroGeral);
        params.addValue("livro", (Object)livro);
        params.addValue(EXERCICIO, (Object)exercicio);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoConsultaReceitas.class));
    }

    public List<ComunicadoConsultaReceitas> findReceitasIdConsultaDebito(Long idConsultaDebito, Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_RECEITAS_CONSULTA_DEBITOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("idConsultaDebito", (Object)idConsultaDebito);
        params.addValue(TIPOCADASTRO, (Object)tipoCadastro);
        params.addValue(CADASTROGERAL, (Object)cadastroGeral);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoConsultaReceitas.class));
    }

    private MapSqlParameterSource getParameterDebito(DebitoDividaAtivaAvulsaDTO debito) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(TIPOCADASTRO, (Object)debito.getTipoCadastro());
        params.addValue(CADASTROGERAL, (Object)debito.getCadastroGeral());
        if (Objects.nonNull(debito.getGuiaRecolhimento())) {
            params.addValue("guiaRecolhimento", (Object)debito.getGuiaRecolhimento());
        }
        if (Objects.nonNull(debito.getParcela())) {
            params.addValue(PARCELA, (Object)debito.getParcela());
        }
        if (Objects.nonNull(debito.getSubDivida())) {
            params.addValue("subDivida", (Object)debito.getSubDivida());
        }
        if (Objects.nonNull(debito.getIdDebito())) {
            params.addValue("idDebito", (Object)debito.getIdDebito());
        }
        if (Objects.nonNull(debito.getExercicio())) {
            params.addValue(EXERCICIO, (Object)debito.getExercicio());
        }
        return params;
    }

    private String getSelectFields() {
        return "SELECT DISTINCT TD.IDDEBITO, TD.ENTIDADE, TD.EXERCICIO, TD.TIPOCADASTRO, TD.CADASTROGERAL, TCG.PESSOA, P.NOME AS NOMEPESSOA, TD.GUIARECOLHIMENTO AS DIVIDA, TD.SUBDIVIDA, TDP.PARCELA, TDPR.IDDEBITOPARCELARECEITA AS IDDEBITOTRIBUTO, TDPR.RECEITA AS TRIBUTO, RECEITA.TIPORECEITA AS TIPOTRIBUTO, RECEITATIPO.DESCRICAO AS TIPOTRIBUTODESCRICAO, TD.DATAPRIMEIRAPARCELA, TD.DATALANCAMENTO, TD.DATACORRECAOIGPM, TDP.DATAVENCIMENTO, TDP.SITUACAOLEGAL, TDPR.VALORORIGINAL, TDPR.VALOR, 0 AS VALORJUROS, 0 AS VALORMULTA, 0 AS VALORCORRECAO, TD.FORMACORRECAO, CASE WHEN TD.PARCELADO = 'S' THEN 1 ELSE 0 END AS PARCELADO, CASE WHEN TD.REPARCELADO = 'S' THEN 1 ELSE 0 END AS REPARCELADO, TTSP.TIPOSITUACAOPARCELA, TSP.DESCRICAO AS SITUACAODEBITODESCRICAO, TSP.SIGLA AS SITUACAODEBITOSIGLA ";
    }

    private String getOrderByFields() {
        return "ORDER BY TD.ENTIDADE, TD.EXERCICIO, TD.TIPOCADASTRO, TD.CADASTROGERAL, TD.GUIARECOLHIMENTO, TD.SUBDIVIDA, TDP.PARCELA, TDPR.RECEITA";
    }

    public List<ParcelamentoDebitoOrigemDTO> findParcelamentoDebitoOrigem(Long idDebito, List<Long> parcelamentos) {
        String sqlFinal;
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_PARCELAMENTO_DEBITO_ORIGEM);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idDebito", (Object)idDebito);
        if (!parcelamentos.isEmpty()) {
            String inSql = parcelamentos.stream().map(String::valueOf).collect(Collectors.joining(","));
            sqlFinal = sql.replace(FILTROS, String.format("AND p.idParcelamento NOT IN (%s)", inSql));
        } else {
            sqlFinal = sql.replace(FILTROS, "");
        }
        return this.namedParameterJdbcTemplate.query(sqlFinal, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoOrigemDTO.class));
    }

    public List<EstornoParcelamentoDebitoOrigemDTO> findEstornoParcelamentoDebitoOrigem(Long idDebito, List<Long> estornosParcelamentos) {
        String sqlFinal;
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_ESTORNO_PARCELAMENTO_DEBITO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idDebito", (Object)idDebito);
        if (!estornosParcelamentos.isEmpty()) {
            String inSql = estornosParcelamentos.stream().map(String::valueOf).collect(Collectors.joining(","));
            sqlFinal = sql.replace(FILTROS, String.format("AND p.idEstornoParcelamento NOT IN (%s)", inSql));
        } else {
            sqlFinal = sql.replace(FILTROS, "");
        }
        return this.namedParameterJdbcTemplate.query(sqlFinal, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoParcelamentoDebitoOrigemDTO.class));
    }
}

