/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.tributos.calculo.dto.CalculoComparativoValoresDTO;
import br.com.elotech.tributos.util.CalculoComparativoValoresRowMapper;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class CalculoRepositoryImpl {
    private static final String LIMIT_AND_OFF = " LIMIT :limit OFFSET :offset";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CalculoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<CalculoComparativoValoresDTO> findComparativoByIdAndExercicioComparacao(Long idCalculo, Long exercicio, String filtro, Pageable pageable, Long entidade) {
        String baseSql = CalculoRepositoryImpl.buildSql((String)filtro);
        String paginatedSql = CalculoRepositoryImpl.buildSql((String)filtro) + " LIMIT :limit OFFSET :offset";
        MapSqlParameterSource parameters = new MapSqlParameterSource().addValue("id", (Object)idCalculo).addValue("exercicio", (Object)exercicio).addValue("entidade", (Object)entidade).addValue("limit", (Object)pageable.getPageSize()).addValue("offset", (Object)pageable.getOffset());
        List calculo = this.namedParameterJdbcTemplate.query(paginatedSql, (SqlParameterSource)parameters, (RowMapper)new CalculoComparativoValoresRowMapper(this.namedParameterJdbcTemplate));
        String countSql = "SELECT COUNT(*) FROM (" + baseSql + ") AS total";
        Integer total = (Integer)this.namedParameterJdbcTemplate.queryForObject(countSql, (SqlParameterSource)parameters, Integer.class);
        int totalCount = total != null ? total : 0;
        return new PageImpl(calculo, pageable, (long)totalCount);
    }

    private static String translateSearch(String filtro) {
        if (filtro == null || ((String)filtro).isEmpty()) {
            return "";
        }
        filtro = " where " + (String)filtro;
        return ((String)filtro).replace("==", "=").replace("!=", "<>").replace("=CIN=", "IN").replace("=COUT=", "NOT IN");
    }

    private static String buildSql(String filtro) {
        String sqlFields = " distinct tab.entidadeAtual, tab.exercicioAtual, tab.tipoCadastroAtual, tab.cadastroGeralAtual , tab.guiaRecolhimentoAtual, tab.descricaoGuiaAtual, tab.entidadeComparacao, tab.exercicioComparacao, tab.tipoCadastroComparacao, tab.cadastroGeralComparacao, tab.guiaRecolhimentoComparacao, tab.descricaoGuiaComparacao, tab.subdividaComparacao, tab.valorAtual, tab.valorAnterior, tab.diferencaPerc, tab.diferencaValor, tab.cnpjCpf, tab.nome";
        String sql = "Select" + sqlFields + " from ( " + CalculoRepositoryImpl.getSql() + " ) tab " + CalculoRepositoryImpl.translateSearch((String)filtro);
        return sql;
    }

    private static String getSqlDebitos() {
        String fields = "  select    coalesce(tdr_calc.entidade, 0) as entidadeAtual,    coalesce(tdr_calc.exercicio, 0) as exercicioAtual,    coalesce(tdr_calc.tipocadastro, 0) as tipoCadastroAtual,    coalesce(tdr_calc.cadastrogeral, 0) as cadastroGeralAtual,    coalesce(tdr_calc.guiarecolhimento, 0) as guiaRecolhimentoAtual,    tgr_calc.descricao as descricaoGuiaAtual,    coalesce(tdr_comp.entidade, 0) as entidadeComparacao,    coalesce(tdr_comp.exercicio, 0) as exercicioComparacao,    coalesce(tdr_comp.tipocadastro, 0) as tipoCadastroComparacao,    coalesce(tdr_comp.cadastrogeral, 0) as cadastroGeralComparacao,    coalesce(tdr_comp.guiarecolhimento, 0) as guiaRecolhimentoComparacao,    tgr_comp.descricao as descricaoGuiaComparacao,    coalesce(tdr_comp.subdivida, 0) as subdividaComparacao,    coalesce(sum(tdr_calc.valorreceita), 0) as valorAtual,    coalesce(sum(tdr_comp.valorreceita), 0) as valorAnterior,    coalesce(round((sum(tdr_calc.valorreceita)/ sum(tdr_comp.valorreceita) - 1) * 100, 2), 0) as diferencaPerc,    coalesce(round(sum(tdr_calc.valorreceita) - sum(tdr_comp.valorreceita), 2), 0) as diferencaValor,    p.cnpj_cpf as cnpjCpf,    p.nome";
        String joins = "  from    calculo calc  join calculocadastro calccad on    calccad.calculo = calc.id  join tribdebito td on    td.iddebito = calccad.iddebito  join tribcadastrogeral tcg on    tcg.tipocadastro = td.tipocadastro    and tcg.cadastrogeral = td.cadastrogeral  join pessoa p on    p.pessoa = tcg.pessoa  join tribdebitoreceita tdr_calc on    tdr_calc.entidade = td.entidade    and tdr_calc.exercicio = td.exercicio    and tdr_calc.tipocadastro = td.tipocadastro    and tdr_calc.cadastrogeral = td.cadastrogeral    and tdr_calc.guiarecolhimento = td.guiarecolhimento    and tdr_calc.subdivida = td.subdivida  join tribguiarecolhimento tgr_calc on    tgr_calc.entidade = tdr_calc.entidade    and tgr_calc.exercicio = tdr_calc.exercicio    and tgr_calc.guiarecolhimento = tdr_calc.guiarecolhimento  join tribdebitoreceita tdr_comp on    tdr_comp.entidade = tdr_calc.entidade    and tdr_comp.exercicio = :exercicio    and tdr_comp.tipocadastro = tdr_calc.tipocadastro    and tdr_comp.cadastrogeral = tdr_calc.cadastrogeral    and tdr_comp.guiarecolhimento = tdr_calc.guiarecolhimento    and tdr_comp.subdivida = (      select        max(tdr_comp2.subdivida)      from        tribdebitoreceita tdr_comp2      join tribdebito td2 on        td2.entidade = tdr_comp2.entidade        and td2.exercicio = tdr_comp2.exercicio        and td2.tipocadastro = tdr_comp2.tipocadastro        and td2.cadastrogeral = tdr_comp2.cadastrogeral        and td2.guiarecolhimento = tdr_comp2.guiarecolhimento        and td2.subdivida = tdr_comp2.subdivida      where        tdr_comp2.entidade = tdr_comp.entidade        and tdr_comp2.exercicio = tdr_comp.exercicio        and tdr_comp2.tipocadastro = tdr_comp.tipocadastro        and tdr_comp2.cadastrogeral = tdr_comp.cadastrogeral        and tdr_comp2.guiarecolhimento = tdr_comp.guiarecolhimento        and (td2.programa = 'Calculo' or td2.programa = 'TFrm_CalculoIPTU'))    and tdr_comp.receita = tdr_calc.receita  join tribguiarecolhimento tgr_comp on    tgr_comp.entidade = tdr_comp.entidade    and tgr_comp.exercicio = tdr_comp.exercicio    and tgr_comp.guiarecolhimento = tdr_comp.guiarecolhimento";
        String where = "  where    calc.id = :id  group by    tdr_calc.entidade,    tdr_calc.exercicio,    tdr_calc.tipocadastro,    tdr_calc.cadastrogeral,    tdr_calc.guiarecolhimento,    tgr_calc.descricao,    tdr_comp.entidade,    tdr_comp.exercicio,    tdr_comp.tipocadastro,    tdr_comp.cadastrogeral,    tdr_comp.guiarecolhimento,    tgr_comp.descricao,    tdr_comp.subdivida,    p.cnpj_cpf,    p.nome";
        return fields + joins + where;
    }

    private static String getSqlSimulacao() {
        String fields = "  select    1 as entidadeAtual,    calc.exercicio as exercicioAtual,    tcg.tipocadastro as tipoCadastroAtual,    tcg.cadastrogeral as cadastroGeralAtual,    tgr.guiarecolhimento as guiaRecolhimentoAtual,    tgr.descricao as descricaoGuiaAtual,    coalesce(tdr_comp.entidade, 0) as entidadeComparacao,    coalesce(tdr_comp.exercicio, 0) as exercicioComparacao,    coalesce(tdr_comp.tipocadastro, 0) as tipoCadastroComparacao,    coalesce(tdr_comp.cadastrogeral, 0) as cadastroGeralComparacao,    coalesce(tdr_comp.guiarecolhimento, 0) as guiaRecolhimentoComparacao,    tgr.descricao as descricaoGuiaComparacao,    coalesce(tdr_comp.subdivida, 0) as subdividaComparacao,    coalesce(sum(calcresult.valor), 0) as valorAtual,    coalesce(sum(tdr_comp.valorreceita), 0) as valorAnterior,    coalesce(round((sum(calcresult.valor)/ sum(tdr_comp.valorreceita) - 1) * 100, 2), 0) as diferencaPerc,    coalesce(round(sum(calcresult.valor) - sum(tdr_comp.valorreceita), 2), 0) as diferencaValor,    p.cnpj_cpf as cnpjCpf,    p.nome";
        String joins = "  from    calculo calc  join calculocadastro calccad on    calccad.calculo = calc.id  join calculotributo calctrib on    calctrib.iddivida = calccad.iddivida    and calctrib.exercicio = calc.exercicio  join calculoresultado calcresult on    calcresult.calculocadastro = calccad.id    and calcresult.calculotributo = calctrib.id  join tribcadastrogeral tcg on    tcg.idkey = calccad.cadastro  join pessoa p on    p.pessoa = tcg.pessoa  join tribguiarecolhimento tgr on    tgr.idkey = calccad.iddivida  join tribreceita tr on tr.id = calctrib.idtributo  join tribdebitoreceita tdr_comp on    tdr_comp.entidade = :entidade    and tdr_comp.exercicio = :exercicio    and tdr_comp.tipocadastro = tcg.tipocadastro    and tdr_comp.cadastrogeral = tcg.cadastrogeral    and tdr_comp.guiarecolhimento = tgr.guiarecolhimento    and tdr_comp.subdivida = (      select        max(tdr_comp2.subdivida)      from        tribdebitoreceita tdr_comp2      join tribdebito td2 on        td2.entidade = tdr_comp2.entidade        and td2.exercicio = tdr_comp2.exercicio        and td2.tipocadastro = tdr_comp2.tipocadastro        and td2.cadastrogeral = tdr_comp2.cadastrogeral        and td2.guiarecolhimento = tdr_comp2.guiarecolhimento        and td2.subdivida = tdr_comp2.subdivida      where        tdr_comp2.entidade = tdr_comp.entidade        and tdr_comp2.exercicio = tdr_comp.exercicio        and tdr_comp2.tipocadastro = tdr_comp.tipocadastro        and tdr_comp2.cadastrogeral = tdr_comp.cadastrogeral        and tdr_comp2.guiarecolhimento = tdr_comp.guiarecolhimento        and (td2.programa = 'Calculo' or td2.programa = 'TFrm_CalculoIPTU'))        and tdr_comp.receita = tr.receita";
        String where = "  where    calc.id = :id  group by    1, calc.exercicio, tcg.tipoCadastro, tcg.cadastroGeral, tgr.guiarecolhimento, tgr.descricao,    tdr_comp.entidade, tdr_comp.exercicio, tdr_comp.tipocadastro,    tdr_comp.cadastrogeral, tdr_comp.guiarecolhimento, tgr.descricao,    tdr_comp.subdivida, p.cnpj_cpf, p.nome";
        return fields + joins + where;
    }

    private static String getSql() {
        return CalculoRepositoryImpl.getSqlDebitos() + " union all " + CalculoRepositoryImpl.getSqlSimulacao();
    }
}

