/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.contribuicaomelhoria;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroDTO;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroRequest;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class MelhoriaCadastroRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String FIND = "br/com/elotech/tributos/repository/contribuicaomelhoria/findCadastros.sql";
    private static final String COUNT = "br/com/elotech/tributos/repository/contribuicaomelhoria/countCadastros.sql";
    private static final String INSERT = "br/com/elotech/tributos/repository/contribuicaomelhoria/insertCadastros.sql";

    public Page<MelhoriaCadastroDTO> findCadastros(MelhoriaCadastroRequest request, Pageable pageable) {
        String filtros = request.getFiltros();
        String sql = String.format(FileUtils.readResourceAsString((String)FIND), filtros);
        Long total = Optional.ofNullable(this.getTotal(filtros)).orElse(0L);
        String sqlComPaginacao = this.getSqlComPaginacao(sql, pageable);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (RowMapper)new ElotechBeanPropertyRowMapper(MelhoriaCadastroDTO.class));
        return new PageImpl(pagedRows, pageable, total.longValue());
    }

    public void saveCadastros(MelhoriaCadastroRequest request) {
        String filtros = request.getFiltros();
        String sql = String.format(FileUtils.readResourceAsString((String)INSERT), filtros);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)request.getEntidade());
        parameters.addValue("exercicio", (Object)request.getExercicio());
        parameters.addValue("numeroEdital", (Object)request.getNumeroEdital());
        parameters.addValue("valor", (Object)request.getValor());
        this.jdbcTemplate.update(sql, (SqlParameterSource)parameters);
    }

    private Long getTotal(String filtros) {
        String sql = String.format(FileUtils.readResourceAsString((String)COUNT), filtros);
        return (Long)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(), (rs, rowNum) -> rs.getLong("total"));
    }

    private String getSqlComPaginacao(String sql, Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    @Generated
    public MelhoriaCadastroRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

