/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.comunicado;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeNotificacoesDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeNotificacoesFilterDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeRelatorioDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeTotaisDTO;
import br.com.elotech.tributos.repository.comunicado.ComunicadoCadastroNotificacaoEmailCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ComunicadoCadastroNotificacaoEmailCustomRepositoryImpl
implements ComunicadoCadastroNotificacaoEmailCustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private static final String SQL_RELATORIO = "sql/efetividadeNotificacoesComunicadoCadastro.sql";

    public ComunicadoEfetividadeRelatorioDTO efetividadeNotificacoesComunicadoCadastro(ComunicadoEfetividadeNotificacoesFilterDTO filterDTO, Pageable pageable) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("dataInicial", (Object)filterDTO.dataInicial());
        parameterSource.addValue("dataFinal", (Object)filterDTO.dataFinal());
        String query = FileUtils.readResourceAsString((String)SQL_RELATORIO);
        query = query.replace("$[FILTROS]", filterDTO.buildFilter());
        String queryTotais = String.format("select count(*) as totalRegistros, sum(valorNotificacao) totalValorNotificacao, sum(valorPagoAposNotificacao) totalValorPagoAposNotificacao from (%s) queryCount", query);
        ComunicadoEfetividadeTotaisDTO totais = (ComunicadoEfetividadeTotaisDTO)this.namedParameterJdbcTemplate.queryForObject(queryTotais, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoEfetividadeTotaisDTO.class));
        String pagedQuery = pageable.isPaged() ? SqlUtils.withPagination((String)query, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource()) : query;
        List pagedContent = this.namedParameterJdbcTemplate.query(pagedQuery, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoEfetividadeNotificacoesDTO.class));
        PageImpl comunicadoEfetividadeNotificacoesDTOS = new PageImpl(pagedContent, pageable, totais.getTotalRegistros().longValue());
        return new ComunicadoEfetividadeRelatorioDTO((Page)comunicadoEfetividadeNotificacoesDTOS, totais.getTotalValorNotificacao(), totais.getTotalValorPagoAposNotificacao(), totais.getTotalRegistros());
    }

    @Generated
    public ComunicadoCadastroNotificacaoEmailCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

