/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.camposdinamicos;

import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaElogeoDTO;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaElogeoDTORowMapper;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomRespostaRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private static final String UNION_ALL_COUNT = "union all select count(*) as total ";
    private static final String UNION_ALL = "union all select r.* ";
    private static final String SQL_CONTAGEM = "select  sum(total)  as total from (select count(*) as total  from respostaavulso r union all select count(*) as total from respostamobiliario r  union all select count(*) as total from respostalogradouro r  union all select count(*) as total from respostarural r  union all select count(*) as total from respostasegmento r union all select count(*) as total from respostaterreno r ) resposta";
    private static final String SQL_DEFAULT = "select resposta.*,  campo.id as campoid, campo.descricao as campodescricao, campo.tipo as campotipo, campo.codigo as campocodigo, alternativa.id as alternativaid, alternativa.codigo as alternativacodigo, alternativa.descricao as alternativadesc, grupo.id as grupoid, grupo.descricao as grupodesc from (select r.* from respostaavulso r union all select r.* from respostamobiliario r union all select r.* from respostalogradouro r union all select r.* from respostarural r union all select r.* from respostasegmento r union all select r.* from respostaterreno r ) resposta join campo campo on campo.id = resposta.idcampo join grupocampo grupo on grupo.id = campo.idgrupo left join alternativa alternativa on alternativa.id = resposta.idalternativa ";

    public Page<RespostaElogeoDTO> findAllRespostas(Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        Long numeroTotal = (Long)this.namedParameterJdbcTemplate.queryForObject(SQL_CONTAGEM, (SqlParameterSource)new MapSqlParameterSource(), (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)SQL_DEFAULT.concat(finalSort), (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRows = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (RowMapper)new RespostaElogeoDTORowMapper());
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    public Optional<RespostaElogeoDTO> findRespostaByIdAndFuncionalidade(Long id, FuncionalidadeCampo funcionalidadeCampo) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idResposta", (Object)id, 2);
        parameters.addValue("funcionalidadeCampo", (Object)funcionalidadeCampo.getValue(), 12);
        String sql = SQL_DEFAULT.concat("where resposta.id = :idResposta and grupo.funcionalidade = :funcionalidadeCampo ");
        try {
            return Optional.ofNullable((RespostaElogeoDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new RespostaElogeoDTORowMapper()));
        }
        catch (EmptyResultDataAccessException ex) {
            return Optional.empty();
        }
    }

    public List<RespostaElogeoDTO> findRespostaByIdCampo(Long idcampo) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idcampo", (Object)idcampo, 2);
        String sql = SQL_DEFAULT.concat("where campo.id = :idcampo");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RespostaElogeoDTORowMapper());
    }

    @Generated
    public CustomRespostaRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

