/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ValidacaoComunicadoRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private static final String DATA_REFERENCIA = "dataReferencia";
    private static final String SQL_CADASTROS_COMUNICADO = "br/com/elotech/tributos/repository/comunicado/existsComDataValidadeVencidaPorCadastro.sql";
    private static final String SQL_FIND_CADASTROS_COMUNICADO_DEBITO = "br/com/elotech/tributos/repository/comunicado/existsDebitoParaGeracaoComunicadoByConsultaCadastro.sql";
    private static final String SQL_FIND_CADASTROS_COMUNICADO_LIVRO_DA = "br/com/elotech/tributos/repository/comunicado/existsDebitoGeracaoComunicadoLivroDA.sql";
    private static final String SQL_FIND_CADASTROS_COMUNICADO_GERACAO_CDA = "br/com/elotech/tributos/repository/comunicado/existsDebitoGeracaoComunicadoCDA.sql";
    private static final String SQL_FIND_CADASTROS_COMUNICADO_SIMULACAO_CALCULO = "br/com/elotech/tributos/repository/comunicado/existsComDataValidadeVencidaSimulacaoCalculo.sql";

    public Boolean existsComDataValidadeVencidaDebito(Long idConsultaDebito) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CADASTROS_COMUNICADO_DEBITO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("idConsultaDebito", (Object)idConsultaDebito);
        params.addValue(DATA_REFERENCIA, (Object)LocalDate.now());
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Boolean.class);
    }

    public Boolean existsComDataValidadeVencidaLivroDA(Long entidade, Long exercicio, Long livro) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CADASTROS_COMUNICADO_LIVRO_DA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        params.addValue("livro", (Object)livro);
        params.addValue(DATA_REFERENCIA, (Object)LocalDate.now());
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Boolean.class);
    }

    public Boolean existsComDataValidadeVencidaGeracaoCda(Long idLoteSimulacao) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CADASTROS_COMUNICADO_GERACAO_CDA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("idLoteSimulacao", (Object)idLoteSimulacao);
        params.addValue(DATA_REFERENCIA, (Object)LocalDate.now());
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Boolean.class);
    }

    public Boolean existsComDataValidadeVencidaSimulacaoCalculo(Long idCalculo) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CADASTROS_COMUNICADO_SIMULACAO_CALCULO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("idCalculo", (Object)idCalculo);
        params.addValue(DATA_REFERENCIA, (Object)LocalDate.now());
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Boolean.class);
    }

    public Boolean existsComDataValidadeVencidasPorCadastro(String filters) {
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_CADASTROS_COMUNICADO), filters);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(DATA_REFERENCIA, (Object)LocalDate.now());
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Boolean.class);
    }

    @Generated
    public ValidacaoComunicadoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

