/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.tarefaassincrona.SituacaoTarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaExecucaoDTO;
import br.com.elotech.tributos.repository.TarefaAssincronaCustomRepository;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.RsqlOperatorUtils;
import br.com.elotech.tributos.util.SqlUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TarefaAssincronaCustomRepositoryImpl
implements TarefaAssincronaCustomRepository {
    private static final String FIND_PARAMETROS_BY_TAREFA = "SELECT tipo, valor FROM tarefaassincronaparametro  WHERE tarefaassincrona = :tarefa";
    private static final String FIND_EXECUCOES_BY_TAREFA = "br/com/elotech/tributos/repository/find-tarefa-assincrona-execucoes-by-tarefa.sql";
    private static final String SEARCH_TAREFA_ASSINCRONA_EXECUCAO_MAIS_RECENTE = "br/com/elotech/tributos/repository/search-tarefa-assincrona-execucao-mais-recente.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public TarefaAssincronaCustomRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<TarefaAssincronaDTO> searchTarefas(String search, Pageable pageable) {
        String parameter;
        int index;
        String sql = FileUtils.readResourceAsString((String)SEARCH_TAREFA_ASSINCRONA_EXECUCAO_MAIS_RECENTE);
        List filterId = RsqlUtils.getFieldValues((String)search, (String)"id");
        List filterTipo = RsqlUtils.getFieldValues((String)search, (String)"tipo");
        List filterSituacao = RsqlUtils.getFieldValues((String)search, (String)"situacao");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<String> whereClauses = new ArrayList<String>();
        for (index = 0; index < filterId.size(); ++index) {
            parameter = String.format("id%s", index);
            Long id = Long.valueOf(((AttributeGetterResult)filterId.get(index)).getValue());
            whereClauses.add(String.format(" tarefa.id %s :%s ", ((AttributeGetterResult)filterId.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)id);
        }
        for (index = 0; index < filterSituacao.size(); ++index) {
            parameter = String.format("situacao%s", index);
            SituacaoTarefaAssincrona situacao = SituacaoTarefaAssincrona.valueOf((String)((AttributeGetterResult)filterSituacao.get(index)).getValue());
            whereClauses.add(String.format(" execucao.situacao %s :%s ", ((AttributeGetterResult)filterSituacao.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)situacao.name());
        }
        for (index = 0; index < filterTipo.size(); ++index) {
            parameter = String.format("tipo%s", index);
            TipoTarefaAssincrona tipo = TipoTarefaAssincrona.valueOf((String)((AttributeGetterResult)filterTipo.get(index)).getValue());
            whereClauses.add(String.format(" tarefa.tipo %s :%s ", ((AttributeGetterResult)filterTipo.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)tipo.name());
        }
        String sqlWithParameters = whereClauses.isEmpty() ? sql : String.format("%s AND %s", sql, String.join((CharSequence)" and ", whereClauses));
        String sqlWithOperators = RsqlOperatorUtils.replaceOperatorsRsqlToSql((String)sqlWithParameters);
        String sqlCounter = String.format("select count(*) as total from (%s) count_query", sqlWithOperators);
        Long totalResults = (Long)this.jdbcTemplate.queryForObject(sqlCounter, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlOrderBy = String.format("%s order by tarefa.id desc", sqlWithOperators);
        String sqlWithPagination = SqlUtils.withPagination((String)sqlOrderBy, (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List tarefas = this.jdbcTemplate.query(sqlWithPagination, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TarefaAssincronaDTO.class));
        tarefas.forEach(tarefa -> {
            String parametros = this.getTarefaParametros(tarefa.getId());
            tarefa.setParametros(parametros);
        });
        return new PageImpl(tarefas, pageable, totalResults.longValue());
    }

    public List<TarefaAssincronaExecucaoDTO> findHistoricoExecucoesByTarefa(Long tarefa) {
        String sql = FileUtils.readResourceAsString((String)FIND_EXECUCOES_BY_TAREFA);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tarefa", (Object)tarefa);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TarefaAssincronaExecucaoDTO.class));
    }

    private String getTarefaParametros(Long tarefa) {
        ArrayList parametros = new ArrayList();
        HashMap<String, Long> sqlParameters = new HashMap<String, Long>();
        sqlParameters.put("tarefa", tarefa);
        RowCallbackHandler handler = row -> {
            int ordemColunaTipoParametro = 1;
            int ordemColunaValor = 2;
            TipoParametro tipoParametro = TipoParametro.fromValue((String)row.getString(ordemColunaTipoParametro));
            if (TipoParametro.DATA.equals((Object)tipoParametro)) {
                String data = DateUtils.localDateToStringFormatoBrasileiro((LocalDate)DateUtils.stringToLocalDate((String)row.getString(ordemColunaValor)));
                parametros.add(data);
                return;
            }
            parametros.add(row.getString(ordemColunaValor));
        };
        this.jdbcTemplate.query(FIND_PARAMETROS_BY_TAREFA, sqlParameters, handler);
        return String.join((CharSequence)", ", parametros);
    }
}

