/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.RastreamentoProprietarioDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroMobiliarioDTO;
import br.com.elotech.tributos.service.ExercicioService;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RastreamentoMaringaRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RastreamentoMaringaRepository.class);
    private static final String SQL_RASTREAMENTO = "br/com/elotech/tributos/repository/rastreamento-proprietarios-maringa.sql";
    private static final String SQL_RASTREAMENTO_DEBITOS = "br/com/elotech/tributos/repository/rastreamento-debitos-maringa.sql";
    private static final String SQL_RASTREAMENTO_CADASTROS_SOCIOS = "br/com/elotech/tributos/repository/rastreamento-busca-cadastros-socios.sql";
    private static final String SQL_RASTREAMENTO_BUSCA_SOCIOS = "br/com/elotech/tributos/repository/rastreamento-busca-socios.sql";
    private static final String SQL_SITUACAO_CADASTRO_IMOBILIARIO = "br/com/elotech/tributos/repository/situacao-cadastro-imobiliario.sql";
    private static final String SQL_SITUACAO_CADASTRO_MOBILIARIO = "br/com/elotech/tributos/repository/situacao-cadastro-mobiliario.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ExercicioService exercicioService;

    public List<RastreamentoProprietarioDTO> loadRastreamento(RastreamentoConsultaDTO params) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO).replaceAll(":filtroRastreamento", params.buildFilter()).replaceAll(":naoUtilizaCorresponsavel", params.buildFiltroNaoUtilizaCorresponsavel());
        List tiposCadastros = params.getTiposCadastrosConsiderados();
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tiposCadastroExcetoImobiliario", tiposCadastros.stream().filter(tipo -> !TipoCadastro.IMOBILIARIO.getValue().equals(tipo)).toList());
        parameters.addValue("tiposCadastro", (Object)tiposCadastros);
        log.debug("loadRastreamento - SQL utilizado na busca do rastreamento: {}", (Object)sql);
        log.debug("loadRastreamento - Par\u00e2metros utilizados na busca do rastreamento: {}", (Object)parameters.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }

    public List<RastreamentoDebitoDTO> loadDebitosRastreamento(Set<Long> ids) {
        int yearNow = this.exercicioService.getExercicio().intValue();
        LocalDate dataVencimentoCotaUnicaIni = LocalDate.of(yearNow, Month.JANUARY, 1);
        LocalDate dataVencimentoCotaUnicaFim = LocalDate.of(yearNow, Month.DECEMBER, 1);
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_DEBITOS);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", ids);
        parameters.addValue("dataVencimentoCotaUnicaIni", (Object)dataVencimentoCotaUnicaIni);
        parameters.addValue("dataVencimentoCotaUnicaFim", (Object)dataVencimentoCotaUnicaFim);
        log.debug("loadDebitosRastreamento - SQL utilizado na busca dos d\u00e9bitos do rastreamento: {}", (Object)sql);
        log.debug("loadDebitosRastreamento - Par\u00e2metros utilizados na busca dos d\u00e9bitos do rastreamento: {}", (Object)parameters.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoDebitoDTO.class));
    }

    public Set<RastreamentoCadastroDTO> loadRastreamentoCadastrosSocios(RastreamentoConsultaDTO params) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_CADASTROS_SOCIOS).replaceAll(":filtroRastreamento", params.buildFilter());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tiposCadastro", (Object)params.getTiposCadastrosConsiderados());
        log.debug("loadRastreamentoCadastrosSocios - SQL utilizado na busca dos cadastros socios do rastreamento: {}", (Object)sql);
        log.debug("loadRastreamentoCadastrosSocios - Par\u00e2metros utilizados na busca dos cadastros socios do rastreamento: {}", (Object)parameters.getValues());
        return RastreamentoCadastroDTO.agruparPorCadastro((List)this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class)));
    }

    public List<RastreamentoProprietarioDTO> buscaProprietariosSocios(Long idCadastro) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_BUSCA_SOCIOS);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idCadastro", (Object)idCadastro);
        log.debug("buscaProprietariosSocios - SQL utilizado na busca dos propriet\u00e1rios socios do rastreamento: {}", (Object)sql);
        log.debug("buscaProprietariosSocios - Par\u00e2metros utilizados na busca dos propriet\u00e1rios socios do rastreamento: {}", (Object)parameters.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }

    public List<SituacaoCadastroImobiliarioDTO> loadSituacaoCadastroImobiliario(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_SITUACAO_CADASTRO_IMOBILIARIO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        log.debug("loadSituacaoCadastroImobiliario - SQL utilizado na busca das situa\u00e7\u00f5es do imobili\u00e1rio: {}", (Object)sql);
        log.debug("loadSituacaoCadastroImobiliario - Par\u00e2metros utilizados na busca das situa\u00e7\u00f5es do imobili\u00e1rio: {}", (Object)parameters.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(SituacaoCadastroImobiliarioDTO.class));
    }

    public List<SituacaoCadastroMobiliarioDTO> loadSituacaoCadastroMobiliario(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_SITUACAO_CADASTRO_MOBILIARIO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        log.debug("loadSituacaoCadastroMobiliario - SQL utilizado na busca das situa\u00e7\u00f5es do mobili\u00e1rio: {}", (Object)sql);
        log.debug("loadSituacaoCadastroMobiliario - Par\u00e2metros utilizados na busca das situa\u00e7\u00f5es do mobili\u00e1rio: {}", (Object)parameters.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(SituacaoCadastroMobiliarioDTO.class));
    }

    @Generated
    public RastreamentoMaringaRepository(NamedParameterJdbcTemplate jdbcTemplate, ExercicioService exercicioService) {
        this.jdbcTemplate = jdbcTemplate;
        this.exercicioService = exercicioService;
    }
}

