/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.repository.projections.CartorioProtestoRemessaProjection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProtestoRemessaItemRepository
extends CrudRepository<ProtestoRemessaItem, Long> {
    public List<ProtestoRemessaItem> findByProtestoRemessa(ProtestoRemessa var1);

    public Optional<ProtestoRemessaItem> findFirstByProtestoOrderByIdDesc(Protesto var1);

    @Query(value="select max(sequencia) from ProtestoRemessaItem where entidade = :entidade and exercicio = :exercicio and remessa = :remessa")
    public Long findLastSequence(Long var1, Long var2, Long var3);

    public List<ProtestoRemessaItem> findByProtesto(Protesto var1);

    @Query(value="SELECT pri.protesto.id AS protestoId, CASE WHEN pri.cartorio.descricao = '0' OR pri.cartorio.descricao IS NULL THEN 'N\u00e3o cadastrado' ELSE pri.cartorio.descricao END AS cartorioDescricao FROM ProtestoRemessaItem pri WHERE pri.protesto IN :protestos GROUP BY pri.protesto.id, pri.cartorio.descricao")
    public List<CartorioProtestoRemessaProjection> findListCartorioByProtestoIn(@Param(value="protestos") List<Protesto> var1);
}

