/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO;
import br.com.elotech.tributos.projection.PagamentoLoteMesmaSequenciaProjection;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PagamentoLoteRepository
extends CrudRepository<PagamentoLote, PagamentoLoteId> {
    public boolean existsByArquivoHash(String var1);

    @Query(value="select p from PagamentoLote p  where p.id.entidade = :entidade and       p.id.exercicio = :exercicio and       p.dataMovimento in (:dias)")
    public List<PagamentoLote> findByDataMovimentacao(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="dias") List<LocalDate> var3);

    @Query(value="select pagamentoLote from PagamentoLote pagamentoLote where not exists ( select 1                    from LoteIntegracaoContabil loteIntegracaoContabil                    where loteIntegracaoContabil.pagamentoLote = pagamentoLote                        and loteIntegracaoContabil.situacaoIntegracaoContabil <> :situacao) and pagamentoLote.dataMovimento = :data and pagamentoLote.contaBancaria.integraArrecadacao = true and (exists ( select 1 from Pagamento pagamento where                pagamento.lote = pagamentoLote                and pagamento.valorPago > 0 )       or exists (select 1 from CreditoContribuinte  credito where               credito.lote = pagamentoLote                and credito.valorLancado > 0  )    ) ")
    public List<PagamentoLote> findAllNotIntegradoByDataMovimentoAndSituacao(@Param(value="data") LocalDate var1, @Param(value="situacao") SituacaoIntegracaoContabil var2);

    @Query(value="select new br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO(pagamentoLote) from PagamentoLote pagamentoLote  where pagamentoLote.id.entidade = :entidade and       pagamentoLote.dataMovimento in (:dias)")
    public List<PagamentoLoteIntegracaoDTO> findPagamentoLoteToPagamentoLoteIntegracaoDTO(@Param(value="entidade") Long var1, @Param(value="dias") List<LocalDate> var2);

    @Query(value="select p.exerciciolote, p.lote, p.sequenciaarquivo,        string_agg(p.pagamento||'/'||p.exerciciopagamento,',' ORDER by p.exerciciopagamento,p.pagamento) pagamentos from tribpagamento p join tribpagamentolote pl  on p.entidade = pl.entidade and p.exerciciolote = pl.exercicio and p.lote = pl.lote where p.entidade = :entidade and p.exerciciolote = :exercicioLote and p.lote = :lote and not exists (select 1 from tribvinculocreditopagamento tvcp               where tvcp.entidade = p.entidade               and tvcp.exerciciopagamento = p.exerciciopagamento               and tvcp.pagamento = p.pagamento) group by p.exerciciolote, p.lote, p.sequenciaarquivo having count(*) > 1", nativeQuery=true)
    public List<PagamentoLoteMesmaSequenciaProjection> findPagamentosNaMesmaSequenciaDoLote(@Param(value="entidade") Long var1, @Param(value="exercicioLote") Long var2, @Param(value="lote") Long var3);

    @Query(value="select pl from PagamentoLote pl where pl.convenio = :convenio and pl.dataMovimento = :dataReferencia and pl.situacao = br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote.ABERTO")
    public Optional<PagamentoLote> findAbertoByConvenioAndData(@Param(value="convenio") Convenio var1, @Param(value="dataReferencia") LocalDate var2);
}

