/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DocumentoRepository
extends CrudRepository<Documento, Long>,
JpaSpecificationExecutor<Documento> {
    public Documento findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(Long var1, Long var2, Long var3, Long var4);

    public Documento findByCodigoValidacao(String var1);

    @Query(value="select doc from Documento doc where doc.cadastroGeral = :cadastroGeral and doc.documentoTipo.impressaoWeb is true and doc.dataValidade >= :dataHoje order by doc.dataEmissao desc")
    public List<DocumentoProjection> findByCadastroGeral(@Param(value="cadastroGeral") CadastroGeral var1, @Param(value="dataHoje") LocalDate var2);

    @Query(value="select case when count(doc.id) > 0 then 'true' else 'false' end from Documento doc where doc.documentoTipo = 26 and doc.documento = :numero and doc.exercicio = :exercicio")
    public Boolean existsDocumentoCDAByNumeroAndExercicio(@Param(value="numero") Long var1, @Param(value="exercicio") Long var2);

    @Query(value="select doc.id from Documento doc where doc.entidade = :entidade and doc.exercicio = :exercicio and doc.documentoTipo.id = :documentoTipo and doc.documento = :documento")
    public Long existsByEntidadeAndExercicioAndTipoDocumentoAndDocumento(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="documentoTipo") Long var3, @Param(value="documento") Long var4);

    @Modifying
    @Query(value="delete from tribdocumentopeticaocda where idcertidaodividaativa= :id", nativeQuery=true)
    public void removeDividaAtivaPeticao(@Param(value="id") Long var1);

    @Query(value="select doc from Documento doc where doc.documentoTipo = 27 and doc.documento = :numero and doc.exercicio = :exercicio")
    public Optional<Documento> findPeticaoByNumeroExercicio(@Param(value="numero") Long var1, @Param(value="exercicio") Long var2);

    @Query(value="select doc from Documento doc where doc.documentoTipo = 26 and doc.documento = :numero and doc.exercicio = :exercicio")
    public Documento findCdaByNumeroExercicioAndTipo(@Param(value="numero") Long var1, @Param(value="exercicio") Long var2);

    @Query(value="select case when count(*) > 0 then 'true' else 'false' end from Documento doc inner join doc.cadastroGeral cg where doc.documentoTipo = 27 and doc.cancelado = false and doc.tipoCadastro = :tipoCadastro and cg.cadastroGeral = :cadastroGeral")
    public Boolean existsDocumentoPeticaoAtivoByTipoCadastroAndCadastroGeral(@Param(value="tipoCadastro") TipoCadastro var1, @Param(value="cadastroGeral") Long var2);

    @Query(value="select count(*) from Documento doc where doc.tipoDocumento in (15,52,14,51)  and doc.dataEmissao >= :dataInicial and doc.dataEmissao <= :dataFinal")
    public Long findQuantidadeDocumentosEmitidosByDataInicialAndDataFinal(@Param(value="dataInicial") LocalDate var1, @Param(value="dataFinal") LocalDate var2);

    @Query(value="select distinct d from Documento d join d.documentoItemDividaAtivas dida where d.cancelado = 'N' and dida.id.entidade = :entidade and dida.exercicioDebito = :exercicioDebito and dida.tipoCadastro = :tipoCadastro and dida.cadastroGeral = :cadastroGeral and dida.codigoDivida = :divida and dida.subDivida = :subDivida")
    public Documento findCdaEmAbertoByDebito(@Param(value="entidade") Long var1, @Param(value="exercicioDebito") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6);

    @Query(value="select distinct d from Documento d join d.documentoItemDividaAtivas dida where d.cancelado = 'N' and dida.id.entidade = :entidade and dida.exercicioDebito = :exercicioDebito and dida.tipoCadastro = :tipoCadastro and dida.cadastroGeral = :cadastroGeral and dida.codigoDivida = :divida and dida.subDivida = :subDivida and dida.parcela = :parcela")
    public List<Documento> findCdasEmAbertoByDebito(@Param(value="entidade") Long var1, @Param(value="exercicioDebito") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6, @Param(value="parcela") Long var7);
}

