/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.repository.ConsultaDebitoCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import br.com.elotech.tributos.util.debito.ConsultaDebitoUtils;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ConsultaDebitoRepositoryImpl
implements ConsultaDebitoCustomRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaDebitoRepositoryImpl.class);
    private static final String SQL_CONSULTA_DEBITO = "br/com/elotech/tributos/repository/find-consulta-debito.sql";
    private static final String ID_CONSULTA = "idConsulta";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ConsultaDebitoValoresDTO getResumo(Long idConsulta) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), "", "", "", "");
        log.debug("getResumo - SQL utilizado para trazer os valores da consulta de d\u00e9bitos: {}", (Object)sql);
        log.debug("getResumo - Par\u00e2metros utilizados para trazer os valores da consulta de d\u00e9bitos: {}", (Object)parameterSource.getValues());
        return (ConsultaDebitoValoresDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoValoresDTO.class));
    }

    public Page<ConsultaDebitoItemDTO> findDebitos(Long idConsulta, String tipoAgrupamento, Pageable pageable) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        ConsultaDebitoTipoAgrupamento tipoAgrupamentoEnum = ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento);
        String query = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), ConsultaDebitoUtils.getConsultaGeradaSelect((ConsultaDebitoTipoAgrupamento)tipoAgrupamentoEnum), ConsultaDebitoUtils.getConsultaGeradaJoin((ConsultaDebitoTipoAgrupamento)tipoAgrupamentoEnum), ConsultaDebitoUtils.getConsultaGeradaGroupBy((ConsultaDebitoTipoAgrupamento)tipoAgrupamentoEnum), ConsultaDebitoUtils.getConsultaGeradaOrderBy((ConsultaDebitoTipoAgrupamento)tipoAgrupamentoEnum));
        String queryCount = String.format("select count(*) as total from (%s) queryCount", query);
        Long sqlCount = (Long)this.namedParameterJdbcTemplate.queryForObject(queryCount, (SqlParameterSource)parameterSource, (rs, rowNum) -> rs.getLong("total"));
        String pagedQuery = SqlUtils.withPagination((String)query, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        log.debug("findDebitos - SQL utilizado para trazer os registros da consulta de d\u00e9bitos: {}", (Object)pagedQuery);
        log.debug("findDebitos - Par\u00e2metros utilizados para trazer os registros da consulta de d\u00e9bitos: {}", (Object)parameterSource.getValues());
        List pagedContent = this.namedParameterJdbcTemplate.query(pagedQuery, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoItemDTO.class));
        return new PageImpl(pagedContent, pageable, sqlCount.longValue());
    }

    public List<ConsultaDebitoItemDTO> getDebitosPorAgrupamento(Long idConsulta, ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String query = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), ConsultaDebitoUtils.getConsultaGeradaSelect((ConsultaDebitoTipoAgrupamento)tipoAgrupamento), ConsultaDebitoUtils.getConsultaGeradaJoin((ConsultaDebitoTipoAgrupamento)tipoAgrupamento), ConsultaDebitoUtils.getConsultaGeradaGroupBy((ConsultaDebitoTipoAgrupamento)tipoAgrupamento), ConsultaDebitoUtils.getConsultaGeradaOrderBy((ConsultaDebitoTipoAgrupamento)tipoAgrupamento));
        log.debug("getDebitosPorAgrupamento - SQL utilizado para trazer os registros da consulta de d\u00e9bitos para impress\u00e3o: {}", (Object)query);
        log.debug("getDebitosPorAgrupamento - Par\u00e2metros utilizados para trazer os registros da consulta de d\u00e9bitos para impress\u00e3o: {}", (Object)parameterSource.getValues());
        return this.namedParameterJdbcTemplate.query(query, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoItemDTO.class));
    }

    @Generated
    public ConsultaDebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

