/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.documento.peticao.CdaGeracaoPeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertidaoDividaAtivaRepository {
    private static final String SQL_CONSULTA_CDA_POR_PARCELA = "br/com/elotech/tributos/repository/find-certidao-divida-ativa-por-parcela.sql";
    private static final String SQL_CONSULTA_CDA_GERACAO_PETICAO = "br/com/elotech/tributos/repository/documento/peticao/find-cdas-geracao-peticao.sql";
    private static final String SQL_EXTRATO_DEBITOS_CDA = "br/com/elotech/tributos/repository/extrato-debitos-cda.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CertidaoDividaAtivaRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<CertidaoDividaAtivaDTO> findByDebitoParcela(DebitoParcelaId parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_CONSULTA_CDA_POR_PARCELA);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)parcela.getEntidade());
        parameters.addValue("exercicio", (Object)parcela.getExercicio());
        parameters.addValue("tipoCadastro", (Object)parcela.getTipoCadastro());
        parameters.addValue("cadastroGeral", (Object)parcela.getCadastroGeral());
        parameters.addValue("divida", (Object)parcela.getDivida());
        parameters.addValue("subDivida", (Object)parcela.getSubDivida());
        parameters.addValue("parcela", (Object)parcela.getParcela());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CertidaoDividaAtivaDTO.class));
    }

    public List<CdaGeracaoPeticaoDTO> findCdaGeracaoPeticao(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO, Long entidade) {
        String sql = FileUtils.readResourceAsString((String)SQL_CONSULTA_CDA_GERACAO_PETICAO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        String sqlComFiltro = sql.replace("$[FILTROS]", geracaoLotePeticaoDTO.filtro());
        return this.namedParameterJdbcTemplate.query(sqlComFiltro, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CdaGeracaoPeticaoDTO.class));
    }

    public List<ExtratoDebitoDTO> findDebitosExtratoCda(List<Long> idDocumento) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXTRATO_DEBITOS_CDA).replace("[WHERE_TEMPLATE]", "WHERE doc.idkey in (:ids)");
        MapSqlParameterSource params = new MapSqlParameterSource("ids", idDocumento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ExtratoDebitoDTO.class));
    }
}

