/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ContextService;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class EspelhoCarneParamLoader {
    private static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    private static final String PARAM_DESC_UF = "PDescUF";
    private static final String PARAM_EXERCICIO = "PExercicio";
    private static final String PARAM_MASK_CEP = "PMascara_CEP";
    private static final String PARAM_ENDERECO = "PEndereco";
    private static final String PARAM_CEP = "PCEP";
    private static final String PARAM_MATCHER_FORMAT = "%s=%s%n";
    private static final String MASK_CEP = "XXXXX-XXX";
    private final EntidadeRepository entidadeRepository;
    private final ContextService contextService;

    public String load() {
        Entidade entidadePrincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return String.format(PARAM_MATCHER_FORMAT, PARAM_NOME_ENTIDADE, entidadePrincipal.getNome()).concat(String.format("%s=Estado do %s%n", PARAM_DESC_UF, unidadeFederacaoDescr)).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_EXERCICIO, exercicio)).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_ENDERECO, "")).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_CEP, StringUtils.defaultString((String)entidadePrincipal.getCep(), (String)""))).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_MASK_CEP, MASK_CEP));
    }

    @Generated
    public EspelhoCarneParamLoader(EntidadeRepository entidadeRepository, ContextService contextService) {
        this.entidadeRepository = entidadeRepository;
        this.contextService = contextService;
    }
}

