/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CarneParamLoader {
    private static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    private static final String PARAM_DESC_UF = "PDescUF";
    private static final String PARAM_CIDADE = "PCidade";
    private static final String PARAM_DATA = "PData";
    private static final String PARAM_MASK_CNPJ = "PMascaraCEP";
    private static final String MASCARA_CNPJ = "XX.XXX.XXX/XXXX-XX";
    private static final String PARAM_FORMAT = "%s=%s%n";
    private static final String PARAM_EXERCICIO = "PExercicio";
    private static final String PARAM_IMPRIMECAPA = "PImprimeCapa";
    private static final String PARAM_ENDERECO = "PEndereco";
    private static final String PARAM_BAIRRO = "PBairro";
    private static final String PARAM_CEP = "PCEP";
    private static final String PARAM_OBSERVACAO = "PObservacao";
    private static final String PARAM_TRIBUTO = "PTributo";
    private final EntidadeRepository entidadeRepository;
    private final ContextService contextService;
    private final LogradouroRepository logradouroRepository;
    private final BairroRepository bairroRepository;

    public String load() {
        Entidade entidadePrincipal = this.entidadeRepository.findByEntidadeprincipal();
        String descricaoUF = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Optional logradouro = this.logradouroRepository.findByLogradouroAndCidadeEntidadePrincipal(entidadePrincipal.getLogradouro());
        Optional bairro = this.bairroRepository.findByBairroAndCidadeEntidadePrincipal(entidadePrincipal.getBairro());
        return String.format(PARAM_FORMAT, PARAM_NOME_ENTIDADE, entidadePrincipal.getNome()).concat(String.format(PARAM_FORMAT, PARAM_DESC_UF, "Estado do " + descricaoUF)).concat(String.format(PARAM_FORMAT, PARAM_EXERCICIO, this.contextService.getExercicioAtual())).concat(String.format(PARAM_FORMAT, PARAM_CIDADE, this.getDescricaoCidade(entidadePrincipal.getCidade()))).concat(String.format(PARAM_FORMAT, PARAM_IMPRIMECAPA, "N")).concat(String.format(PARAM_FORMAT, PARAM_ENDERECO, Optional.ofNullable(((Logradouro)logradouro.get()).getDescricao()).orElse(""))).concat(String.format(PARAM_FORMAT, PARAM_BAIRRO, Optional.ofNullable(((Bairro)bairro.get()).getDescricao()).orElse(""))).concat(String.format(PARAM_FORMAT, PARAM_CEP, entidadePrincipal.getCep())).concat(String.format(PARAM_FORMAT, PARAM_OBSERVACAO, "")).concat(String.format(PARAM_FORMAT, PARAM_TRIBUTO, "")).concat(String.format(PARAM_FORMAT, PARAM_DATA, String.format("Atual - %s", this.getFormattedDate()))).concat(String.format(PARAM_FORMAT, PARAM_MASK_CNPJ, MASCARA_CNPJ));
    }

    private String getDescricaoCidade(Cidade cidade) {
        return Optional.ofNullable(cidade).map(Cidade::getDescricao).orElse("");
    }

    private String getFormattedDate() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm:ss"));
    }

    @Generated
    public CarneParamLoader(EntidadeRepository entidadeRepository, ContextService contextService, LogradouroRepository logradouroRepository, BairroRepository bairroRepository) {
        this.entidadeRepository = entidadeRepository;
        this.contextService = contextService;
        this.logradouroRepository = logradouroRepository;
        this.bairroRepository = bairroRepository;
    }
}

