/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.outboxdataintegration.service;

import ajuizamentomanifestcaofiscal.AjuizamentoManifestacaoFiscalPayload;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class IntegracaoAjuizamentoManifestacaoService {
    private DocumentoRepository documentoRepository;
    private DebitoParcelaService debitoParcelaService;

    public void saveProtocoloRetorno(AjuizamentoManifestacaoFiscalPayload payload) {
        Optional peticao = this.documentoRepository.findPeticaoByNumeroExercicio(payload.getNumeroPeticao(), payload.getExercicioPeticao());
        if (peticao.isEmpty() || Objects.isNull(((Documento)peticao.get()).getId())) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a peti\u00e7\u00e3o %s/%s para ser ajuizada", payload.getNumeroPeticao(), payload.getExercicioPeticao()));
        }
        for (DebitoParcela debitoParcela : this.debitoParcelaService.findByIdPeticao(((Documento)peticao.get()).getId())) {
            debitoParcela.setDataAjuizamento(payload.getDataEnvio());
            debitoParcela.setProcessoJudicial(payload.getProtocoloRetorno());
            this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        }
    }

    @Generated
    public IntegracaoAjuizamentoManifestacaoService(DocumentoRepository documentoRepository, DebitoParcelaService debitoParcelaService) {
        this.documentoRepository = documentoRepository;
        this.debitoParcelaService = debitoParcelaService;
    }
}

