/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.hibernatesearch.progressmonitor;

import br.com.elotech.tributos.enums.hibernatesearch.StatusHibernateSearchIndexed;
import br.com.elotech.tributos.enums.hibernatesearch.TipoCadastroIndexacao;
import br.com.elotech.tributos.hibernatesearch.dto.IndexacaoHibernateSearchDTO;
import br.com.elotech.tributos.service.hibernatesearch.HibernateSearchLockService;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class HibernateSearchIndexingProgressMonitor
implements MassIndexerProgressMonitor {
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final LongAdder totalCounter = new LongAdder();
    private final SseEmitter emitter;
    private final TipoCadastroIndexacao tipoCadastro;
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateSearchIndexingProgressMonitor.class);
    private final HibernateSearchLockService hibernateSearchLockService;

    public HibernateSearchIndexingProgressMonitor(SseEmitter emitter, TipoCadastroIndexacao tipoCadastro, HibernateSearchLockService hibernateSearchLockService) {
        this.emitter = emitter;
        this.tipoCadastro = tipoCadastro;
        this.hibernateSearchLockService = hibernateSearchLockService;
    }

    public void addToTotalCount(long count) {
        this.totalCounter.add(count);
    }

    public void documentsAdded(long increment) {
        this.documentsDoneCounter.getAndAdd(increment);
        String messageIndexing = String.format("a indexa\u00e7\u00e3o %d/%d", this.documentsDoneCounter.get(), this.totalCounter.longValue());
        try {
            LOGGER.debug(String.format("Realizando %s.", messageIndexing));
            long indexed = this.documentsDoneCounter.get();
            if (indexed % 10L == 0L) {
                this.emitter.send(SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)new IndexacaoHibernateSearchDTO(Long.valueOf(this.totalCounter.longValue()), Long.valueOf(indexed)), MediaType.APPLICATION_JSON));
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Erro ao realizar %s: %s", messageIndexing, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexingCompleted() {
        IndexacaoHibernateSearchDTO indexedHibernateSearch = new IndexacaoHibernateSearchDTO(Long.valueOf(this.totalCounter.longValue()), Long.valueOf(this.documentsDoneCounter.get()));
        indexedHibernateSearch.setTipoCadastro(this.tipoCadastro);
        indexedHibernateSearch.setCompleted(Boolean.TRUE);
        try {
            indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.SUCESSO);
            this.emitter.send(SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)indexedHibernateSearch, MediaType.APPLICATION_JSON));
            LOGGER.debug(String.format("Indexa\u00e7\u00e3o finalizada com sucesso.", new Object[0]));
        }
        catch (IOException e) {
            String messageError = String.format("Erro ao realizar a indexa\u00e7\u00e3o: %s.", e.getMessage());
            LOGGER.error(messageError);
            indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.ERRO);
            indexedHibernateSearch.setMessageError(messageError);
        }
        finally {
            this.emitter.complete();
            this.hibernateSearchLockService.updateStatusHibernateSearchFromTipoCadastro(indexedHibernateSearch);
        }
    }

    public void documentsBuilt(int increment) {
    }

    public void entitiesLoaded(int increment) {
    }
}

