/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.webiss;

import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoSocio;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocialPessoa;
import br.com.elotech.tributos.dto.webiss.SocioWebIssDTO;
import br.com.elotech.tributos.enums.NivelProfissional;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SocioWebIssDTO {
    private static final Long ADMINISTRADOR = 5L;
    private static final Long SOCIO = 22L;
    @JsonProperty(value="QualificacaoRFB")
    private Long qualificacaoRFB;
    @JsonProperty(value="Nome")
    private String nome;
    @JsonProperty(value="Documento")
    private String documento;
    @JsonProperty(value="DataEntrada")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    private LocalDate dataEntrada;
    @JsonProperty(value="DataSaida")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    private LocalDate dataSaida;
    @JsonProperty(value="Participacao")
    private BigDecimal participacao;
    @JsonProperty(value="RepresentanteLegal")
    private Boolean representanteLegal;
    @JsonProperty(value="SituacaoCadastral")
    private String situacaoCadastral;
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="DataRegistroOrgao")
    private String dataRegistroOrgao;
    @JsonProperty(value="NivelProfissional")
    private String nivelProfissional;
    @JsonProperty(value="Ativo")
    private Boolean ativo;

    public static List<SocioWebIssDTO> from(CadastroMobiliario cadastroMobiliario) {
        return Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getContratosSocial).filter(list -> !list.isEmpty()).map(List::getLast).map(ContratoSocial::getPessoas).map(contratoSocialPessoas -> contratoSocialPessoas.stream().map(SocioWebIssDTO::fromContratoSocial).toList()).orElse(Collections.emptyList());
    }

    public static SocioWebIssDTO fromContratoSocial(ContratoSocialPessoa contratoSocialPessoa) {
        BigDecimal participacao = SocioWebIssDTO.getParticipacao((ContratoSocialPessoa)contratoSocialPessoa);
        Long qualificacao = SocioWebIssDTO.getQualificacao((ContratoSocialPessoa)contratoSocialPessoa, (BigDecimal)participacao);
        return SocioWebIssDTO.builder().qualificacaoRFB(qualificacao).nome((String)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getPessoa).map(Pessoa::getNome).orElse(null)).documento((String)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getPessoa).map(Pessoa::getCnpjCpf).orElse(null)).participacao(participacao).dataEntrada((LocalDate)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getDataEntrada).orElse(null)).dataSaida((LocalDate)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getDataSaida).orElse(null)).representanteLegal(null).situacaoCadastral(null).email((String)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getPessoa).map(Pessoa::getContatoPrincipal).map(ContatoPessoa::getEmail).orElse(null)).dataRegistroOrgao((String)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getDataRegistroOrgao).map(Objects::toString).orElse(null)).nivelProfissional((String)Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getNivelProfissional).map(NivelProfissional::getDescricao).map(Objects::toString).orElse(null)).ativo(Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getAtivo).orElse(Boolean.TRUE)).build();
    }

    private static Long getQualificacao(ContratoSocialPessoa contratoSocialPessoa, BigDecimal participacao) {
        return Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getTipoSocio).map(TipoSocio::getTipoSocio).orElse(SocioWebIssDTO.getTipoSocioByParticipacao((BigDecimal)participacao));
    }

    public static Long getTipoSocioByParticipacao(BigDecimal participacao) {
        if (participacao.compareTo(BigDecimal.ZERO) > 0) {
            return participacao.compareTo(BigDecimal.valueOf(100L)) >= 0 ? ADMINISTRADOR : SOCIO;
        }
        return null;
    }

    private static BigDecimal getParticipacao(ContratoSocialPessoa contratoSocialPessoa) {
        return Optional.ofNullable(contratoSocialPessoa).map(ContratoSocialPessoa::getPercentualCapital).orElse(BigDecimal.ZERO);
    }

    @Generated
    public static SocioWebIssDTOBuilder builder() {
        return new SocioWebIssDTOBuilder();
    }

    @Generated
    public Long getQualificacaoRFB() {
        return this.qualificacaoRFB;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getDocumento() {
        return this.documento;
    }

    @Generated
    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    @Generated
    public LocalDate getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public BigDecimal getParticipacao() {
        return this.participacao;
    }

    @Generated
    public Boolean getRepresentanteLegal() {
        return this.representanteLegal;
    }

    @Generated
    public String getSituacaoCadastral() {
        return this.situacaoCadastral;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getDataRegistroOrgao() {
        return this.dataRegistroOrgao;
    }

    @Generated
    public String getNivelProfissional() {
        return this.nivelProfissional;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @JsonProperty(value="QualificacaoRFB")
    @Generated
    public void setQualificacaoRFB(Long qualificacaoRFB) {
        this.qualificacaoRFB = qualificacaoRFB;
    }

    @JsonProperty(value="Nome")
    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @JsonProperty(value="Documento")
    @Generated
    public void setDocumento(String documento) {
        this.documento = documento;
    }

    @JsonProperty(value="DataEntrada")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    @Generated
    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @JsonProperty(value="DataSaida")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    @Generated
    public void setDataSaida(LocalDate dataSaida) {
        this.dataSaida = dataSaida;
    }

    @JsonProperty(value="Participacao")
    @Generated
    public void setParticipacao(BigDecimal participacao) {
        this.participacao = participacao;
    }

    @JsonProperty(value="RepresentanteLegal")
    @Generated
    public void setRepresentanteLegal(Boolean representanteLegal) {
        this.representanteLegal = representanteLegal;
    }

    @JsonProperty(value="SituacaoCadastral")
    @Generated
    public void setSituacaoCadastral(String situacaoCadastral) {
        this.situacaoCadastral = situacaoCadastral;
    }

    @JsonProperty(value="Email")
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="DataRegistroOrgao")
    @Generated
    public void setDataRegistroOrgao(String dataRegistroOrgao) {
        this.dataRegistroOrgao = dataRegistroOrgao;
    }

    @JsonProperty(value="NivelProfissional")
    @Generated
    public void setNivelProfissional(String nivelProfissional) {
        this.nivelProfissional = nivelProfissional;
    }

    @JsonProperty(value="Ativo")
    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SocioWebIssDTO)) {
            return false;
        }
        SocioWebIssDTO other = (SocioWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$qualificacaoRFB = this.getQualificacaoRFB();
        Long other$qualificacaoRFB = other.getQualificacaoRFB();
        if (this$qualificacaoRFB == null ? other$qualificacaoRFB != null : !((Object)this$qualificacaoRFB).equals(other$qualificacaoRFB)) {
            return false;
        }
        Boolean this$representanteLegal = this.getRepresentanteLegal();
        Boolean other$representanteLegal = other.getRepresentanteLegal();
        if (this$representanteLegal == null ? other$representanteLegal != null : !((Object)this$representanteLegal).equals(other$representanteLegal)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$documento = this.getDocumento();
        String other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        LocalDate this$dataEntrada = this.getDataEntrada();
        LocalDate other$dataEntrada = other.getDataEntrada();
        if (this$dataEntrada == null ? other$dataEntrada != null : !((Object)this$dataEntrada).equals(other$dataEntrada)) {
            return false;
        }
        LocalDate this$dataSaida = this.getDataSaida();
        LocalDate other$dataSaida = other.getDataSaida();
        if (this$dataSaida == null ? other$dataSaida != null : !((Object)this$dataSaida).equals(other$dataSaida)) {
            return false;
        }
        BigDecimal this$participacao = this.getParticipacao();
        BigDecimal other$participacao = other.getParticipacao();
        if (this$participacao == null ? other$participacao != null : !((Object)this$participacao).equals(other$participacao)) {
            return false;
        }
        String this$situacaoCadastral = this.getSituacaoCadastral();
        String other$situacaoCadastral = other.getSituacaoCadastral();
        if (this$situacaoCadastral == null ? other$situacaoCadastral != null : !this$situacaoCadastral.equals(other$situacaoCadastral)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$dataRegistroOrgao = this.getDataRegistroOrgao();
        String other$dataRegistroOrgao = other.getDataRegistroOrgao();
        if (this$dataRegistroOrgao == null ? other$dataRegistroOrgao != null : !this$dataRegistroOrgao.equals(other$dataRegistroOrgao)) {
            return false;
        }
        String this$nivelProfissional = this.getNivelProfissional();
        String other$nivelProfissional = other.getNivelProfissional();
        return !(this$nivelProfissional == null ? other$nivelProfissional != null : !this$nivelProfissional.equals(other$nivelProfissional));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SocioWebIssDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $qualificacaoRFB = this.getQualificacaoRFB();
        result = result * 59 + ($qualificacaoRFB == null ? 43 : ((Object)$qualificacaoRFB).hashCode());
        Boolean $representanteLegal = this.getRepresentanteLegal();
        result = result * 59 + ($representanteLegal == null ? 43 : ((Object)$representanteLegal).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        LocalDate $dataEntrada = this.getDataEntrada();
        result = result * 59 + ($dataEntrada == null ? 43 : ((Object)$dataEntrada).hashCode());
        LocalDate $dataSaida = this.getDataSaida();
        result = result * 59 + ($dataSaida == null ? 43 : ((Object)$dataSaida).hashCode());
        BigDecimal $participacao = this.getParticipacao();
        result = result * 59 + ($participacao == null ? 43 : ((Object)$participacao).hashCode());
        String $situacaoCadastral = this.getSituacaoCadastral();
        result = result * 59 + ($situacaoCadastral == null ? 43 : $situacaoCadastral.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $dataRegistroOrgao = this.getDataRegistroOrgao();
        result = result * 59 + ($dataRegistroOrgao == null ? 43 : $dataRegistroOrgao.hashCode());
        String $nivelProfissional = this.getNivelProfissional();
        result = result * 59 + ($nivelProfissional == null ? 43 : $nivelProfissional.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SocioWebIssDTO(qualificacaoRFB=" + this.getQualificacaoRFB() + ", nome=" + this.getNome() + ", documento=" + this.getDocumento() + ", dataEntrada=" + String.valueOf(this.getDataEntrada()) + ", dataSaida=" + String.valueOf(this.getDataSaida()) + ", participacao=" + String.valueOf(this.getParticipacao()) + ", representanteLegal=" + this.getRepresentanteLegal() + ", situacaoCadastral=" + this.getSituacaoCadastral() + ", email=" + this.getEmail() + ", dataRegistroOrgao=" + this.getDataRegistroOrgao() + ", nivelProfissional=" + this.getNivelProfissional() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public SocioWebIssDTO() {
    }

    @Generated
    public SocioWebIssDTO(Long qualificacaoRFB, String nome, String documento, LocalDate dataEntrada, LocalDate dataSaida, BigDecimal participacao, Boolean representanteLegal, String situacaoCadastral, String email, String dataRegistroOrgao, String nivelProfissional, Boolean ativo) {
        this.qualificacaoRFB = qualificacaoRFB;
        this.nome = nome;
        this.documento = documento;
        this.dataEntrada = dataEntrada;
        this.dataSaida = dataSaida;
        this.participacao = participacao;
        this.representanteLegal = representanteLegal;
        this.situacaoCadastral = situacaoCadastral;
        this.email = email;
        this.dataRegistroOrgao = dataRegistroOrgao;
        this.nivelProfissional = nivelProfissional;
        this.ativo = ativo;
    }
}

