/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.webiss;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.webiss.EnderecoWebIssDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaRequestDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EnderecoWebIssDTO {
    private static final String LOCALIZACAO = "Localizacao";
    private static final String CORRESPONDENCIA = "Correspondencia";
    @JsonProperty(value="Tipo")
    private String tipo;
    @JsonProperty(value="Logradouro")
    private String logradouro;
    @JsonProperty(value="CEP")
    private String cep;
    @JsonProperty(value="Numero")
    private String numero;
    @JsonProperty(value="Complemento")
    private String complemento;
    @JsonProperty(value="Referencia")
    private String referencia;
    @JsonProperty(value="Bairro")
    private String bairro;
    @JsonProperty(value="Cidade")
    private String cidade;
    @JsonProperty(value="Estado")
    private String estado;
    @JsonProperty(value="CodIBGE")
    private String codIbge;

    public static List<EnderecoWebIssDTO> fromEnderecoAndEnderecoCorrespondencia(CadastroMobiliario cadastroMobiliario, EnderecoCorrespondenciaDTO enderecoCorrespondencia) {
        ArrayList<EnderecoWebIssDTO> enderecos = new ArrayList<EnderecoWebIssDTO>();
        if (cadastroMobiliario != null) {
            EnderecoWebIssDTO enderecoPrincipal = EnderecoWebIssDTO.fromCadastroMobiliario((CadastroMobiliario)cadastroMobiliario);
            enderecos.add(enderecoPrincipal);
            Optional enderecoCorrespondecia = EnderecoWebIssDTO.fromEnderecoCorrespondenciaDTO((EnderecoCorrespondenciaDTO)enderecoCorrespondencia);
            enderecoCorrespondecia.ifPresent(enderecos::add);
        }
        return enderecos;
    }

    public static EnderecoWebIssDTO fromCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        if (cadastroMobiliario == null) {
            return null;
        }
        return EnderecoWebIssDTO.builder().tipo("Localizacao").logradouro((String)Optional.ofNullable(cadastroMobiliario.getLogradouro()).map(Logradouro::getDescricao).orElse(null)).cep((String)Optional.ofNullable(cadastroMobiliario.getCep()).map(String::valueOf).orElse(null)).numero(cadastroMobiliario.getNumero()).complemento(cadastroMobiliario.getComplemento()).referencia(null).codIbge((String)Optional.ofNullable(cadastroMobiliario.getLogradouro()).map(Logradouro::getCidade).map(Cidade::getCodigoIbge).map(String::valueOf).orElse(null)).bairro((String)Optional.ofNullable(cadastroMobiliario.getBairro()).map(Bairro::getDescricao).orElse(null)).cidade((String)Optional.ofNullable(cadastroMobiliario.getCidade()).map(Cidade::getDescricao).orElse(null)).estado((String)Optional.ofNullable(cadastroMobiliario.getCidade()).map(Cidade::getUnidadeFederacao).orElse(null)).build();
    }

    public static Optional<EnderecoWebIssDTO> fromEnderecoCorrespondenciaDTO(EnderecoCorrespondenciaDTO enderecoCorrespondencia) {
        if (Objects.isNull(enderecoCorrespondencia)) {
            return Optional.empty();
        }
        EnderecoWebIssDTO enderecoCorrespondeciaWebIss = EnderecoWebIssDTO.builder().tipo("Correspondencia").logradouro(enderecoCorrespondencia.getLogradouroDescricao()).cep(enderecoCorrespondencia.getCep()).numero(enderecoCorrespondencia.getNumero()).complemento(enderecoCorrespondencia.getComplemento()).referencia(null).codIbge((String)Optional.ofNullable(enderecoCorrespondencia.getCodigoIbge()).map(String::valueOf).orElse(null)).bairro(enderecoCorrespondencia.getBairroDescricao()).cidade(enderecoCorrespondencia.getCidadeDescricao()).estado(enderecoCorrespondencia.getUnidadeFederacao()).build();
        return Optional.ofNullable(enderecoCorrespondeciaWebIss);
    }

    private static EnderecoTipo getTipoEnderecoOxyByWebIss(String enderecoTipo) {
        if (EnderecoTipo.CORRESPONDENCIA.getDescricao().equals(enderecoTipo)) {
            return EnderecoTipo.CORRESPONDENCIA;
        }
        return EnderecoTipo.COMERCIAL;
    }

    public static EnderecoPessoaRequestDTO toEnderecoPessoaRequestDTO(EnderecoWebIssDTO enderecoWebIssDTO) {
        EnderecoPessoaRequestDTO enderecoPessoaRequestDTO = new EnderecoPessoaRequestDTO();
        enderecoPessoaRequestDTO.setTipoEndereco(EnderecoWebIssDTO.getTipoEnderecoOxyByWebIss((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getTipo).orElse(null)));
        enderecoPessoaRequestDTO.setCep((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getCep).orElse(null));
        enderecoPessoaRequestDTO.setBairro((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getBairro).orElse(null));
        enderecoPessoaRequestDTO.setCidade((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getCidade).orElse(null));
        enderecoPessoaRequestDTO.setComplemento((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getComplemento).orElse(null));
        enderecoPessoaRequestDTO.setLogradouro((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getLogradouro).orElse(null));
        enderecoPessoaRequestDTO.setNumero((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getNumero).orElse(null));
        enderecoPessoaRequestDTO.setUnidadeFederacao((String)Optional.ofNullable(enderecoWebIssDTO).map(EnderecoWebIssDTO::getEstado).orElse(null));
        return enderecoPessoaRequestDTO;
    }

    @Generated
    public static EnderecoWebIssDTOBuilder builder() {
        return new EnderecoWebIssDTOBuilder();
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getReferencia() {
        return this.referencia;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getEstado() {
        return this.estado;
    }

    @Generated
    public String getCodIbge() {
        return this.codIbge;
    }

    @JsonProperty(value="Tipo")
    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @JsonProperty(value="Logradouro")
    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @JsonProperty(value="CEP")
    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @JsonProperty(value="Numero")
    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @JsonProperty(value="Complemento")
    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @JsonProperty(value="Referencia")
    @Generated
    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    @JsonProperty(value="Bairro")
    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @JsonProperty(value="Cidade")
    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @JsonProperty(value="Estado")
    @Generated
    public void setEstado(String estado) {
        this.estado = estado;
    }

    @JsonProperty(value="CodIBGE")
    @Generated
    public void setCodIbge(String codIbge) {
        this.codIbge = codIbge;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnderecoWebIssDTO)) {
            return false;
        }
        EnderecoWebIssDTO other = (EnderecoWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$referencia = this.getReferencia();
        String other$referencia = other.getReferencia();
        if (this$referencia == null ? other$referencia != null : !this$referencia.equals(other$referencia)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$estado = this.getEstado();
        String other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        String this$codIbge = this.getCodIbge();
        String other$codIbge = other.getCodIbge();
        return !(this$codIbge == null ? other$codIbge != null : !this$codIbge.equals(other$codIbge));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnderecoWebIssDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $referencia = this.getReferencia();
        result = result * 59 + ($referencia == null ? 43 : $referencia.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        String $codIbge = this.getCodIbge();
        result = result * 59 + ($codIbge == null ? 43 : $codIbge.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EnderecoWebIssDTO(tipo=" + this.getTipo() + ", logradouro=" + this.getLogradouro() + ", cep=" + this.getCep() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", referencia=" + this.getReferencia() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", estado=" + this.getEstado() + ", codIbge=" + this.getCodIbge() + ")";
    }

    @Generated
    public EnderecoWebIssDTO() {
    }

    @Generated
    public EnderecoWebIssDTO(String tipo, String logradouro, String cep, String numero, String complemento, String referencia, String bairro, String cidade, String estado, String codIbge) {
        this.tipo = tipo;
        this.logradouro = logradouro;
        this.cep = cep;
        this.numero = numero;
        this.complemento = complemento;
        this.referencia = referencia;
        this.bairro = bairro;
        this.cidade = cidade;
        this.estado = estado;
        this.codIbge = codIbge;
    }
}

