/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.webiss;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.NaturezaJuridica;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoSituacaoMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.webiss.AtividadeWebIssDTO;
import br.com.elotech.tributos.dto.webiss.CadastroPessoaJuridicaWebIssDTO;
import br.com.elotech.tributos.dto.webiss.CnaeWebIssDTO;
import br.com.elotech.tributos.dto.webiss.EmailWebIssDTO;
import br.com.elotech.tributos.dto.webiss.EnderecoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.NireWebIssDTO;
import br.com.elotech.tributos.dto.webiss.RegimeFiscalWebIssDTO;
import br.com.elotech.tributos.dto.webiss.SocioWebIssDTO;
import br.com.elotech.tributos.dto.webiss.TelefoneWebIssDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CadastroPessoaJuridicaWebIssDTO {
    private static final String ATIVA = "Ativa";
    private static final String SUSPENSA = "Suspensa";
    private static final String BAIXADA = "Baixada";
    private static final String INAPTA = "Inapta";
    @JsonProperty(value="CNPJ")
    private String cnpj;
    @JsonProperty(value="RazaoSocial")
    private String razaoSocial;
    @JsonProperty(value="NomeFantasia")
    private String nomeFantasia;
    @JsonProperty(value="InscricaoEstadual")
    private String inscricaoEstadual;
    @JsonProperty(value="InscricaoMunicipal")
    private String inscricaoMuncipal;
    @JsonProperty(value="Situacao")
    private String situacao;
    @JsonProperty(value="DataAbertura")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    private LocalDate dataAbertura;
    @JsonProperty(value="NaturezaJuridica")
    private String naturezaJuridica;
    @JsonProperty(value="CapitalSocial")
    private BigDecimal capitalSocial;
    @JsonProperty(value="TipoEstabelecimento")
    private String tipoEstabelecimento;
    @JsonProperty(value="Porte")
    private String porte;
    @JsonProperty(value="IndicaSubstitutoTributario")
    private Boolean indicaSubstitutoTributario;
    @JsonProperty(value="NIRE")
    private NireWebIssDTO nire;
    @JsonProperty(value="CNAEs")
    private List<CnaeWebIssDTO> cnaes;
    @JsonProperty(value="Enderecos")
    private List<EnderecoWebIssDTO> enderecos;
    @JsonProperty(value="Telefones")
    private List<TelefoneWebIssDTO> telefones;
    @JsonProperty(value="Emails")
    private List<EmailWebIssDTO> emails;
    @JsonProperty(value="Socios")
    private List<SocioWebIssDTO> socios;
    @JsonProperty(value="RegimeFiscal")
    private RegimeFiscalWebIssDTO regimeFiscal;
    @JsonProperty(value="Atividades")
    private List<AtividadeWebIssDTO> atividades;

    public static CadastroPessoaJuridicaWebIssDTO from(CadastroMobiliario cadastroMobiliario, EnderecoCorrespondenciaDTO enderecoCorrespondencia) {
        return CadastroPessoaJuridicaWebIssDTO.builder().cnpj((String)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).map(Pessoa::getCnpjCpf).orElse(null)).razaoSocial((String)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).map(Pessoa::getNome).orElse(null)).nomeFantasia((String)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).map(Pessoa::getNomeFantasia).orElse(null)).inscricaoEstadual((String)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).map(Pessoa::getInscricaoEstadual).orElse(null)).inscricaoMuncipal(Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getCadastroGeral).map(String::valueOf).orElseGet(() -> Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).map(Pessoa::getInscricaoMunicipal).orElse(null))).situacao(CadastroPessoaJuridicaWebIssDTO.getSituacaoWebIss((CadastroMobiliario)cadastroMobiliario)).dataAbertura((LocalDate)Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getDataAbertura).orElse(null)).naturezaJuridica((String)Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getNaturezaJuridica).map(NaturezaJuridica::getId).map(String::valueOf).orElse(null)).capitalSocial((BigDecimal)Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getContratosSocial).filter(lista -> !lista.isEmpty()).map(List::getLast).map(ContratoSocial::getCapitalSocial).map(bigDecimal -> bigDecimal.setScale(2, RoundingMode.HALF_EVEN)).orElse(null)).tipoEstabelecimento(null).porte(null).indicaSubstitutoTributario((Boolean)Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getSubstituicaoTributaria).orElse(null)).nire(NireWebIssDTO.from((Pessoa)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).orElse(null))).cnaes(CnaeWebIssDTO.from((CadastroMobiliario)cadastroMobiliario)).emails(EmailWebIssDTO.from((Pessoa)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).orElse(null))).enderecos(EnderecoWebIssDTO.fromEnderecoAndEnderecoCorrespondencia((CadastroMobiliario)cadastroMobiliario, (EnderecoCorrespondenciaDTO)enderecoCorrespondencia)).telefones(TelefoneWebIssDTO.from((Pessoa)Optional.ofNullable(cadastroMobiliario).map(CadastroGeral::getPessoa).orElse(null))).socios(SocioWebIssDTO.from((CadastroMobiliario)cadastroMobiliario)).regimeFiscal(RegimeFiscalWebIssDTO.fromLastRegimeFiscal((CadastroMobiliario)cadastroMobiliario)).atividades(AtividadeWebIssDTO.from((CadastroMobiliario)cadastroMobiliario)).build();
    }

    public static String getSituacaoWebIss(CadastroMobiliario cadastroMobiliario) {
        TipoSituacaoMobiliario tipoSituacao = Optional.ofNullable(cadastroMobiliario).map(CadastroMobiliario::getSituacaoAtual).map(SituacaoMobiliario::getTipoSituacaoMobiliario).orElse(null);
        if (Objects.nonNull(tipoSituacao)) {
            if (Boolean.TRUE.equals(tipoSituacao.isEncerrado())) {
                return "Baixada";
            }
            if (Boolean.TRUE.equals(tipoSituacao.isSuspenso())) {
                return "Suspensa";
            }
            if (Boolean.TRUE.equals(tipoSituacao.isDesatualizado())) {
                return "Inapta";
            }
            return "Ativa";
        }
        return null;
    }

    @Generated
    public static CadastroPessoaJuridicaWebIssDTOBuilder builder() {
        return new CadastroPessoaJuridicaWebIssDTOBuilder();
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    @Generated
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Generated
    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    @Generated
    public String getInscricaoMuncipal() {
        return this.inscricaoMuncipal;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public String getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    @Generated
    public BigDecimal getCapitalSocial() {
        return this.capitalSocial;
    }

    @Generated
    public String getTipoEstabelecimento() {
        return this.tipoEstabelecimento;
    }

    @Generated
    public String getPorte() {
        return this.porte;
    }

    @Generated
    public Boolean getIndicaSubstitutoTributario() {
        return this.indicaSubstitutoTributario;
    }

    @Generated
    public NireWebIssDTO getNire() {
        return this.nire;
    }

    @Generated
    public List<CnaeWebIssDTO> getCnaes() {
        return this.cnaes;
    }

    @Generated
    public List<EnderecoWebIssDTO> getEnderecos() {
        return this.enderecos;
    }

    @Generated
    public List<TelefoneWebIssDTO> getTelefones() {
        return this.telefones;
    }

    @Generated
    public List<EmailWebIssDTO> getEmails() {
        return this.emails;
    }

    @Generated
    public List<SocioWebIssDTO> getSocios() {
        return this.socios;
    }

    @Generated
    public RegimeFiscalWebIssDTO getRegimeFiscal() {
        return this.regimeFiscal;
    }

    @Generated
    public List<AtividadeWebIssDTO> getAtividades() {
        return this.atividades;
    }

    @JsonProperty(value="CNPJ")
    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @JsonProperty(value="RazaoSocial")
    @Generated
    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    @JsonProperty(value="NomeFantasia")
    @Generated
    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    @JsonProperty(value="InscricaoEstadual")
    @Generated
    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    @JsonProperty(value="InscricaoMunicipal")
    @Generated
    public void setInscricaoMuncipal(String inscricaoMuncipal) {
        this.inscricaoMuncipal = inscricaoMuncipal;
    }

    @JsonProperty(value="Situacao")
    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @JsonProperty(value="DataAbertura")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @JsonProperty(value="NaturezaJuridica")
    @Generated
    public void setNaturezaJuridica(String naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    @JsonProperty(value="CapitalSocial")
    @Generated
    public void setCapitalSocial(BigDecimal capitalSocial) {
        this.capitalSocial = capitalSocial;
    }

    @JsonProperty(value="TipoEstabelecimento")
    @Generated
    public void setTipoEstabelecimento(String tipoEstabelecimento) {
        this.tipoEstabelecimento = tipoEstabelecimento;
    }

    @JsonProperty(value="Porte")
    @Generated
    public void setPorte(String porte) {
        this.porte = porte;
    }

    @JsonProperty(value="IndicaSubstitutoTributario")
    @Generated
    public void setIndicaSubstitutoTributario(Boolean indicaSubstitutoTributario) {
        this.indicaSubstitutoTributario = indicaSubstitutoTributario;
    }

    @JsonProperty(value="NIRE")
    @Generated
    public void setNire(NireWebIssDTO nire) {
        this.nire = nire;
    }

    @JsonProperty(value="CNAEs")
    @Generated
    public void setCnaes(List<CnaeWebIssDTO> cnaes) {
        this.cnaes = cnaes;
    }

    @JsonProperty(value="Enderecos")
    @Generated
    public void setEnderecos(List<EnderecoWebIssDTO> enderecos) {
        this.enderecos = enderecos;
    }

    @JsonProperty(value="Telefones")
    @Generated
    public void setTelefones(List<TelefoneWebIssDTO> telefones) {
        this.telefones = telefones;
    }

    @JsonProperty(value="Emails")
    @Generated
    public void setEmails(List<EmailWebIssDTO> emails) {
        this.emails = emails;
    }

    @JsonProperty(value="Socios")
    @Generated
    public void setSocios(List<SocioWebIssDTO> socios) {
        this.socios = socios;
    }

    @JsonProperty(value="RegimeFiscal")
    @Generated
    public void setRegimeFiscal(RegimeFiscalWebIssDTO regimeFiscal) {
        this.regimeFiscal = regimeFiscal;
    }

    @JsonProperty(value="Atividades")
    @Generated
    public void setAtividades(List<AtividadeWebIssDTO> atividades) {
        this.atividades = atividades;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroPessoaJuridicaWebIssDTO)) {
            return false;
        }
        CadastroPessoaJuridicaWebIssDTO other = (CadastroPessoaJuridicaWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$indicaSubstitutoTributario = this.getIndicaSubstitutoTributario();
        Boolean other$indicaSubstitutoTributario = other.getIndicaSubstitutoTributario();
        if (this$indicaSubstitutoTributario == null ? other$indicaSubstitutoTributario != null : !((Object)this$indicaSubstitutoTributario).equals(other$indicaSubstitutoTributario)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        String this$razaoSocial = this.getRazaoSocial();
        String other$razaoSocial = other.getRazaoSocial();
        if (this$razaoSocial == null ? other$razaoSocial != null : !this$razaoSocial.equals(other$razaoSocial)) {
            return false;
        }
        String this$nomeFantasia = this.getNomeFantasia();
        String other$nomeFantasia = other.getNomeFantasia();
        if (this$nomeFantasia == null ? other$nomeFantasia != null : !this$nomeFantasia.equals(other$nomeFantasia)) {
            return false;
        }
        String this$inscricaoEstadual = this.getInscricaoEstadual();
        String other$inscricaoEstadual = other.getInscricaoEstadual();
        if (this$inscricaoEstadual == null ? other$inscricaoEstadual != null : !this$inscricaoEstadual.equals(other$inscricaoEstadual)) {
            return false;
        }
        String this$inscricaoMuncipal = this.getInscricaoMuncipal();
        String other$inscricaoMuncipal = other.getInscricaoMuncipal();
        if (this$inscricaoMuncipal == null ? other$inscricaoMuncipal != null : !this$inscricaoMuncipal.equals(other$inscricaoMuncipal)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDate this$dataAbertura = this.getDataAbertura();
        LocalDate other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        String this$naturezaJuridica = this.getNaturezaJuridica();
        String other$naturezaJuridica = other.getNaturezaJuridica();
        if (this$naturezaJuridica == null ? other$naturezaJuridica != null : !this$naturezaJuridica.equals(other$naturezaJuridica)) {
            return false;
        }
        BigDecimal this$capitalSocial = this.getCapitalSocial();
        BigDecimal other$capitalSocial = other.getCapitalSocial();
        if (this$capitalSocial == null ? other$capitalSocial != null : !((Object)this$capitalSocial).equals(other$capitalSocial)) {
            return false;
        }
        String this$tipoEstabelecimento = this.getTipoEstabelecimento();
        String other$tipoEstabelecimento = other.getTipoEstabelecimento();
        if (this$tipoEstabelecimento == null ? other$tipoEstabelecimento != null : !this$tipoEstabelecimento.equals(other$tipoEstabelecimento)) {
            return false;
        }
        String this$porte = this.getPorte();
        String other$porte = other.getPorte();
        if (this$porte == null ? other$porte != null : !this$porte.equals(other$porte)) {
            return false;
        }
        NireWebIssDTO this$nire = this.getNire();
        NireWebIssDTO other$nire = other.getNire();
        if (this$nire == null ? other$nire != null : !this$nire.equals(other$nire)) {
            return false;
        }
        List this$cnaes = this.getCnaes();
        List other$cnaes = other.getCnaes();
        if (this$cnaes == null ? other$cnaes != null : !((Object)this$cnaes).equals(other$cnaes)) {
            return false;
        }
        List this$enderecos = this.getEnderecos();
        List other$enderecos = other.getEnderecos();
        if (this$enderecos == null ? other$enderecos != null : !((Object)this$enderecos).equals(other$enderecos)) {
            return false;
        }
        List this$telefones = this.getTelefones();
        List other$telefones = other.getTelefones();
        if (this$telefones == null ? other$telefones != null : !((Object)this$telefones).equals(other$telefones)) {
            return false;
        }
        List this$emails = this.getEmails();
        List other$emails = other.getEmails();
        if (this$emails == null ? other$emails != null : !((Object)this$emails).equals(other$emails)) {
            return false;
        }
        List this$socios = this.getSocios();
        List other$socios = other.getSocios();
        if (this$socios == null ? other$socios != null : !((Object)this$socios).equals(other$socios)) {
            return false;
        }
        RegimeFiscalWebIssDTO this$regimeFiscal = this.getRegimeFiscal();
        RegimeFiscalWebIssDTO other$regimeFiscal = other.getRegimeFiscal();
        if (this$regimeFiscal == null ? other$regimeFiscal != null : !this$regimeFiscal.equals(other$regimeFiscal)) {
            return false;
        }
        List this$atividades = this.getAtividades();
        List other$atividades = other.getAtividades();
        return !(this$atividades == null ? other$atividades != null : !((Object)this$atividades).equals(other$atividades));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroPessoaJuridicaWebIssDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $indicaSubstitutoTributario = this.getIndicaSubstitutoTributario();
        result = result * 59 + ($indicaSubstitutoTributario == null ? 43 : ((Object)$indicaSubstitutoTributario).hashCode());
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        String $razaoSocial = this.getRazaoSocial();
        result = result * 59 + ($razaoSocial == null ? 43 : $razaoSocial.hashCode());
        String $nomeFantasia = this.getNomeFantasia();
        result = result * 59 + ($nomeFantasia == null ? 43 : $nomeFantasia.hashCode());
        String $inscricaoEstadual = this.getInscricaoEstadual();
        result = result * 59 + ($inscricaoEstadual == null ? 43 : $inscricaoEstadual.hashCode());
        String $inscricaoMuncipal = this.getInscricaoMuncipal();
        result = result * 59 + ($inscricaoMuncipal == null ? 43 : $inscricaoMuncipal.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDate $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        String $naturezaJuridica = this.getNaturezaJuridica();
        result = result * 59 + ($naturezaJuridica == null ? 43 : $naturezaJuridica.hashCode());
        BigDecimal $capitalSocial = this.getCapitalSocial();
        result = result * 59 + ($capitalSocial == null ? 43 : ((Object)$capitalSocial).hashCode());
        String $tipoEstabelecimento = this.getTipoEstabelecimento();
        result = result * 59 + ($tipoEstabelecimento == null ? 43 : $tipoEstabelecimento.hashCode());
        String $porte = this.getPorte();
        result = result * 59 + ($porte == null ? 43 : $porte.hashCode());
        NireWebIssDTO $nire = this.getNire();
        result = result * 59 + ($nire == null ? 43 : $nire.hashCode());
        List $cnaes = this.getCnaes();
        result = result * 59 + ($cnaes == null ? 43 : ((Object)$cnaes).hashCode());
        List $enderecos = this.getEnderecos();
        result = result * 59 + ($enderecos == null ? 43 : ((Object)$enderecos).hashCode());
        List $telefones = this.getTelefones();
        result = result * 59 + ($telefones == null ? 43 : ((Object)$telefones).hashCode());
        List $emails = this.getEmails();
        result = result * 59 + ($emails == null ? 43 : ((Object)$emails).hashCode());
        List $socios = this.getSocios();
        result = result * 59 + ($socios == null ? 43 : ((Object)$socios).hashCode());
        RegimeFiscalWebIssDTO $regimeFiscal = this.getRegimeFiscal();
        result = result * 59 + ($regimeFiscal == null ? 43 : $regimeFiscal.hashCode());
        List $atividades = this.getAtividades();
        result = result * 59 + ($atividades == null ? 43 : ((Object)$atividades).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroPessoaJuridicaWebIssDTO(cnpj=" + this.getCnpj() + ", razaoSocial=" + this.getRazaoSocial() + ", nomeFantasia=" + this.getNomeFantasia() + ", inscricaoEstadual=" + this.getInscricaoEstadual() + ", inscricaoMuncipal=" + this.getInscricaoMuncipal() + ", situacao=" + this.getSituacao() + ", dataAbertura=" + String.valueOf(this.getDataAbertura()) + ", naturezaJuridica=" + this.getNaturezaJuridica() + ", capitalSocial=" + String.valueOf(this.getCapitalSocial()) + ", tipoEstabelecimento=" + this.getTipoEstabelecimento() + ", porte=" + this.getPorte() + ", indicaSubstitutoTributario=" + this.getIndicaSubstitutoTributario() + ", nire=" + String.valueOf(this.getNire()) + ", cnaes=" + String.valueOf(this.getCnaes()) + ", enderecos=" + String.valueOf(this.getEnderecos()) + ", telefones=" + String.valueOf(this.getTelefones()) + ", emails=" + String.valueOf(this.getEmails()) + ", socios=" + String.valueOf(this.getSocios()) + ", regimeFiscal=" + String.valueOf(this.getRegimeFiscal()) + ", atividades=" + String.valueOf(this.getAtividades()) + ")";
    }

    @Generated
    public CadastroPessoaJuridicaWebIssDTO() {
    }

    @Generated
    public CadastroPessoaJuridicaWebIssDTO(String cnpj, String razaoSocial, String nomeFantasia, String inscricaoEstadual, String inscricaoMuncipal, String situacao, LocalDate dataAbertura, String naturezaJuridica, BigDecimal capitalSocial, String tipoEstabelecimento, String porte, Boolean indicaSubstitutoTributario, NireWebIssDTO nire, List<CnaeWebIssDTO> cnaes, List<EnderecoWebIssDTO> enderecos, List<TelefoneWebIssDTO> telefones, List<EmailWebIssDTO> emails, List<SocioWebIssDTO> socios, RegimeFiscalWebIssDTO regimeFiscal, List<AtividadeWebIssDTO> atividades) {
        this.cnpj = cnpj;
        this.razaoSocial = razaoSocial;
        this.nomeFantasia = nomeFantasia;
        this.inscricaoEstadual = inscricaoEstadual;
        this.inscricaoMuncipal = inscricaoMuncipal;
        this.situacao = situacao;
        this.dataAbertura = dataAbertura;
        this.naturezaJuridica = naturezaJuridica;
        this.capitalSocial = capitalSocial;
        this.tipoEstabelecimento = tipoEstabelecimento;
        this.porte = porte;
        this.indicaSubstitutoTributario = indicaSubstitutoTributario;
        this.nire = nire;
        this.cnaes = cnaes;
        this.enderecos = enderecos;
        this.telefones = telefones;
        this.emails = emails;
        this.socios = socios;
        this.regimeFiscal = regimeFiscal;
        this.atividades = atividades;
    }
}

