/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.transferenciadebito;

import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.dto.SituacaoLegal;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class TDDebitoParcelaDTO {
    private Long idDebitoParcela;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long exercicio;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private String situacao;
    private Integer situacaoLegal;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private BigDecimal valor;

    public static TDDebitoParcelaDTO from(DebitoParcela debitoParcela) {
        TDDebitoParcelaDTO dto = new TDDebitoParcelaDTO();
        dto.setIdDebitoParcela(debitoParcela.getIdDebitoParcela());
        dto.setTipoCadastro(debitoParcela.getId().getTipoCadastro());
        dto.setCadastroGeral(debitoParcela.getId().getCadastroGeral());
        dto.setExercicio(debitoParcela.getId().getExercicio());
        dto.setDivida(debitoParcela.getId().getDivida());
        dto.setSubDivida(debitoParcela.getId().getSubDivida());
        dto.setParcela(debitoParcela.getId().getParcela());
        dto.setSituacao(debitoParcela.getSituacaoDebito().getTipoSituacaoParcela().getDescricao());
        dto.setSituacaoLegal(debitoParcela.getSituacaoLegal().getCodigo());
        dto.setDataLancamento(debitoParcela.getDataLancamento());
        dto.setDataVencimento(debitoParcela.getDataVencimento());
        dto.setValor(debitoParcela.getValorTotal());
        return dto;
    }

    public String getSituacaoLegal() {
        return Optional.ofNullable(this.situacaoLegal).map(SituacaoLegal::fromValue).map(sl -> String.format("%d - %s", sl.getCodigo(), sl.getDescricao())).orElse(null);
    }

    @Generated
    public TDDebitoParcelaDTO() {
    }

    @Generated
    public Long getIdDebitoParcela() {
        return this.idDebitoParcela;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public void setIdDebitoParcela(Long idDebitoParcela) {
        this.idDebitoParcela = idDebitoParcela;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSituacaoLegal(Integer situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDDebitoParcelaDTO)) {
            return false;
        }
        TDDebitoParcelaDTO other = (TDDebitoParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebitoParcela = this.getIdDebitoParcela();
        Long other$idDebitoParcela = other.getIdDebitoParcela();
        if (this$idDebitoParcela == null ? other$idDebitoParcela != null : !((Object)this$idDebitoParcela).equals(other$idDebitoParcela)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        String this$situacaoLegal = this.getSituacaoLegal();
        String other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        return !(this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TDDebitoParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebitoParcela = this.getIdDebitoParcela();
        result = result * 59 + ($idDebitoParcela == null ? 43 : ((Object)$idDebitoParcela).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        String $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TDDebitoParcelaDTO(idDebitoParcela=" + this.getIdDebitoParcela() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", situacao=" + this.getSituacao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", valor=" + String.valueOf(this.getValor()) + ")";
    }
}

