/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.simam.validacaoimportacao;

import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoArrecadacaoCreditoValidacao;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class EstornoArrecadacaoCreditoValidacao {
    private Long idTceArrTipoCreditoEst;
    private Long nrEstorno;
    private Long nrAnoEstorno;
    private BigDecimal vlEstorno;
    private Long nrArrecadacao;
    private Long nrAnoArrecadacao;
    private Long arrecadacaoNrArrecadacao;
    private Long arrecadacaoNrAnoArrecadacao;
    private Long qtRegistros;
    private Long qtEstornos;
    private Long nrEstornoAnterior;

    public boolean isDuplicado() {
        return this.qtRegistros > 1L;
    }

    public boolean isSequencial() {
        return this.nrEstornoAnterior == 0L || this.nrEstorno - this.nrEstornoAnterior == 1L;
    }

    public boolean isArrecadacaoValida() {
        return this.nrArrecadacao != null && this.nrArrecadacao.equals(this.arrecadacaoNrArrecadacao) && this.nrAnoArrecadacao != null && this.nrAnoArrecadacao.equals(this.arrecadacaoNrAnoArrecadacao);
    }

    public boolean isEstornoUnico() {
        return this.qtEstornos == 1L;
    }

    public boolean isEstornoDeArrecadacaoDoPeriodoDeTrabalho(LocalDate dataTrabalho) {
        return this.nrAnoArrecadacao != null && this.nrAnoArrecadacao.compareTo(Long.valueOf(dataTrabalho.getYear())) == 0;
    }

    @Generated
    public static EstornoArrecadacaoCreditoValidacaoBuilder builder() {
        return new EstornoArrecadacaoCreditoValidacaoBuilder();
    }

    @Generated
    public Long getIdTceArrTipoCreditoEst() {
        return this.idTceArrTipoCreditoEst;
    }

    @Generated
    public Long getNrEstorno() {
        return this.nrEstorno;
    }

    @Generated
    public Long getNrAnoEstorno() {
        return this.nrAnoEstorno;
    }

    @Generated
    public BigDecimal getVlEstorno() {
        return this.vlEstorno;
    }

    @Generated
    public Long getNrArrecadacao() {
        return this.nrArrecadacao;
    }

    @Generated
    public Long getNrAnoArrecadacao() {
        return this.nrAnoArrecadacao;
    }

    @Generated
    public Long getArrecadacaoNrArrecadacao() {
        return this.arrecadacaoNrArrecadacao;
    }

    @Generated
    public Long getArrecadacaoNrAnoArrecadacao() {
        return this.arrecadacaoNrAnoArrecadacao;
    }

    @Generated
    public Long getQtRegistros() {
        return this.qtRegistros;
    }

    @Generated
    public Long getQtEstornos() {
        return this.qtEstornos;
    }

    @Generated
    public Long getNrEstornoAnterior() {
        return this.nrEstornoAnterior;
    }

    @Generated
    public void setIdTceArrTipoCreditoEst(Long idTceArrTipoCreditoEst) {
        this.idTceArrTipoCreditoEst = idTceArrTipoCreditoEst;
    }

    @Generated
    public void setNrEstorno(Long nrEstorno) {
        this.nrEstorno = nrEstorno;
    }

    @Generated
    public void setNrAnoEstorno(Long nrAnoEstorno) {
        this.nrAnoEstorno = nrAnoEstorno;
    }

    @Generated
    public void setVlEstorno(BigDecimal vlEstorno) {
        this.vlEstorno = vlEstorno;
    }

    @Generated
    public void setNrArrecadacao(Long nrArrecadacao) {
        this.nrArrecadacao = nrArrecadacao;
    }

    @Generated
    public void setNrAnoArrecadacao(Long nrAnoArrecadacao) {
        this.nrAnoArrecadacao = nrAnoArrecadacao;
    }

    @Generated
    public void setArrecadacaoNrArrecadacao(Long arrecadacaoNrArrecadacao) {
        this.arrecadacaoNrArrecadacao = arrecadacaoNrArrecadacao;
    }

    @Generated
    public void setArrecadacaoNrAnoArrecadacao(Long arrecadacaoNrAnoArrecadacao) {
        this.arrecadacaoNrAnoArrecadacao = arrecadacaoNrAnoArrecadacao;
    }

    @Generated
    public void setQtRegistros(Long qtRegistros) {
        this.qtRegistros = qtRegistros;
    }

    @Generated
    public void setQtEstornos(Long qtEstornos) {
        this.qtEstornos = qtEstornos;
    }

    @Generated
    public void setNrEstornoAnterior(Long nrEstornoAnterior) {
        this.nrEstornoAnterior = nrEstornoAnterior;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstornoArrecadacaoCreditoValidacao)) {
            return false;
        }
        EstornoArrecadacaoCreditoValidacao other = (EstornoArrecadacaoCreditoValidacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idTceArrTipoCreditoEst = this.getIdTceArrTipoCreditoEst();
        Long other$idTceArrTipoCreditoEst = other.getIdTceArrTipoCreditoEst();
        if (this$idTceArrTipoCreditoEst == null ? other$idTceArrTipoCreditoEst != null : !((Object)this$idTceArrTipoCreditoEst).equals(other$idTceArrTipoCreditoEst)) {
            return false;
        }
        Long this$nrEstorno = this.getNrEstorno();
        Long other$nrEstorno = other.getNrEstorno();
        if (this$nrEstorno == null ? other$nrEstorno != null : !((Object)this$nrEstorno).equals(other$nrEstorno)) {
            return false;
        }
        Long this$nrAnoEstorno = this.getNrAnoEstorno();
        Long other$nrAnoEstorno = other.getNrAnoEstorno();
        if (this$nrAnoEstorno == null ? other$nrAnoEstorno != null : !((Object)this$nrAnoEstorno).equals(other$nrAnoEstorno)) {
            return false;
        }
        Long this$nrArrecadacao = this.getNrArrecadacao();
        Long other$nrArrecadacao = other.getNrArrecadacao();
        if (this$nrArrecadacao == null ? other$nrArrecadacao != null : !((Object)this$nrArrecadacao).equals(other$nrArrecadacao)) {
            return false;
        }
        Long this$nrAnoArrecadacao = this.getNrAnoArrecadacao();
        Long other$nrAnoArrecadacao = other.getNrAnoArrecadacao();
        if (this$nrAnoArrecadacao == null ? other$nrAnoArrecadacao != null : !((Object)this$nrAnoArrecadacao).equals(other$nrAnoArrecadacao)) {
            return false;
        }
        Long this$arrecadacaoNrArrecadacao = this.getArrecadacaoNrArrecadacao();
        Long other$arrecadacaoNrArrecadacao = other.getArrecadacaoNrArrecadacao();
        if (this$arrecadacaoNrArrecadacao == null ? other$arrecadacaoNrArrecadacao != null : !((Object)this$arrecadacaoNrArrecadacao).equals(other$arrecadacaoNrArrecadacao)) {
            return false;
        }
        Long this$arrecadacaoNrAnoArrecadacao = this.getArrecadacaoNrAnoArrecadacao();
        Long other$arrecadacaoNrAnoArrecadacao = other.getArrecadacaoNrAnoArrecadacao();
        if (this$arrecadacaoNrAnoArrecadacao == null ? other$arrecadacaoNrAnoArrecadacao != null : !((Object)this$arrecadacaoNrAnoArrecadacao).equals(other$arrecadacaoNrAnoArrecadacao)) {
            return false;
        }
        Long this$qtRegistros = this.getQtRegistros();
        Long other$qtRegistros = other.getQtRegistros();
        if (this$qtRegistros == null ? other$qtRegistros != null : !((Object)this$qtRegistros).equals(other$qtRegistros)) {
            return false;
        }
        Long this$qtEstornos = this.getQtEstornos();
        Long other$qtEstornos = other.getQtEstornos();
        if (this$qtEstornos == null ? other$qtEstornos != null : !((Object)this$qtEstornos).equals(other$qtEstornos)) {
            return false;
        }
        Long this$nrEstornoAnterior = this.getNrEstornoAnterior();
        Long other$nrEstornoAnterior = other.getNrEstornoAnterior();
        if (this$nrEstornoAnterior == null ? other$nrEstornoAnterior != null : !((Object)this$nrEstornoAnterior).equals(other$nrEstornoAnterior)) {
            return false;
        }
        BigDecimal this$vlEstorno = this.getVlEstorno();
        BigDecimal other$vlEstorno = other.getVlEstorno();
        return !(this$vlEstorno == null ? other$vlEstorno != null : !((Object)this$vlEstorno).equals(other$vlEstorno));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EstornoArrecadacaoCreditoValidacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idTceArrTipoCreditoEst = this.getIdTceArrTipoCreditoEst();
        result = result * 59 + ($idTceArrTipoCreditoEst == null ? 43 : ((Object)$idTceArrTipoCreditoEst).hashCode());
        Long $nrEstorno = this.getNrEstorno();
        result = result * 59 + ($nrEstorno == null ? 43 : ((Object)$nrEstorno).hashCode());
        Long $nrAnoEstorno = this.getNrAnoEstorno();
        result = result * 59 + ($nrAnoEstorno == null ? 43 : ((Object)$nrAnoEstorno).hashCode());
        Long $nrArrecadacao = this.getNrArrecadacao();
        result = result * 59 + ($nrArrecadacao == null ? 43 : ((Object)$nrArrecadacao).hashCode());
        Long $nrAnoArrecadacao = this.getNrAnoArrecadacao();
        result = result * 59 + ($nrAnoArrecadacao == null ? 43 : ((Object)$nrAnoArrecadacao).hashCode());
        Long $arrecadacaoNrArrecadacao = this.getArrecadacaoNrArrecadacao();
        result = result * 59 + ($arrecadacaoNrArrecadacao == null ? 43 : ((Object)$arrecadacaoNrArrecadacao).hashCode());
        Long $arrecadacaoNrAnoArrecadacao = this.getArrecadacaoNrAnoArrecadacao();
        result = result * 59 + ($arrecadacaoNrAnoArrecadacao == null ? 43 : ((Object)$arrecadacaoNrAnoArrecadacao).hashCode());
        Long $qtRegistros = this.getQtRegistros();
        result = result * 59 + ($qtRegistros == null ? 43 : ((Object)$qtRegistros).hashCode());
        Long $qtEstornos = this.getQtEstornos();
        result = result * 59 + ($qtEstornos == null ? 43 : ((Object)$qtEstornos).hashCode());
        Long $nrEstornoAnterior = this.getNrEstornoAnterior();
        result = result * 59 + ($nrEstornoAnterior == null ? 43 : ((Object)$nrEstornoAnterior).hashCode());
        BigDecimal $vlEstorno = this.getVlEstorno();
        result = result * 59 + ($vlEstorno == null ? 43 : ((Object)$vlEstorno).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EstornoArrecadacaoCreditoValidacao(idTceArrTipoCreditoEst=" + this.getIdTceArrTipoCreditoEst() + ", nrEstorno=" + this.getNrEstorno() + ", nrAnoEstorno=" + this.getNrAnoEstorno() + ", vlEstorno=" + String.valueOf(this.getVlEstorno()) + ", nrArrecadacao=" + this.getNrArrecadacao() + ", nrAnoArrecadacao=" + this.getNrAnoArrecadacao() + ", arrecadacaoNrArrecadacao=" + this.getArrecadacaoNrArrecadacao() + ", arrecadacaoNrAnoArrecadacao=" + this.getArrecadacaoNrAnoArrecadacao() + ", qtRegistros=" + this.getQtRegistros() + ", qtEstornos=" + this.getQtEstornos() + ", nrEstornoAnterior=" + this.getNrEstornoAnterior() + ")";
    }

    @Generated
    public EstornoArrecadacaoCreditoValidacao() {
    }

    @Generated
    public EstornoArrecadacaoCreditoValidacao(Long idTceArrTipoCreditoEst, Long nrEstorno, Long nrAnoEstorno, BigDecimal vlEstorno, Long nrArrecadacao, Long nrAnoArrecadacao, Long arrecadacaoNrArrecadacao, Long arrecadacaoNrAnoArrecadacao, Long qtRegistros, Long qtEstornos, Long nrEstornoAnterior) {
        this.idTceArrTipoCreditoEst = idTceArrTipoCreditoEst;
        this.nrEstorno = nrEstorno;
        this.nrAnoEstorno = nrAnoEstorno;
        this.vlEstorno = vlEstorno;
        this.nrArrecadacao = nrArrecadacao;
        this.nrAnoArrecadacao = nrAnoArrecadacao;
        this.arrecadacaoNrArrecadacao = arrecadacaoNrArrecadacao;
        this.arrecadacaoNrAnoArrecadacao = arrecadacaoNrAnoArrecadacao;
        this.qtRegistros = qtRegistros;
        this.qtEstornos = qtEstornos;
        this.nrEstornoAnterior = nrEstornoAnterior;
    }
}

