/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.simam.validacaoimportacao;

import br.com.elotech.tributos.dto.TipoArrecadacao;
import br.com.elotech.tributos.dto.diarioarrecadacao.TipoOrigemReceita;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.ArrecadacaoCreditoValidacao;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import lombok.Generated;

public class ArrecadacaoCreditoValidacao {
    private TipoOrigemReceita currentTipoOrigemReceita;
    private TipoArrecadacao currentTipoArrecadacao;
    private Long idTceArrTipoCredito;
    private Long nrArrecadacao;
    private Long nrAnoArrecadacao;
    private BigDecimal vlArrecadacao;
    private Long nrCredito;
    private Long nrAnoCredito;
    private Long nrDivida;
    private Long nrAnoDivida;
    private Long nrMes;
    private Long nrAno;
    private Long lancamentoNrCredito;
    private Long lancamentoNrAnoCredito;
    private Long inscricaoNrDivida;
    private Long inscricaoNrAnoDivida;
    private Long qtRegistros;
    private Long qtArrecadacao;
    private Long nrArrecadacaoAnterior;
    private Long idTipoOrigemReceita;
    private Long idTipoArrecadacao;

    public void loadInformacoesAdicionais() {
        this.currentTipoOrigemReceita = TipoOrigemReceita.fromValue((Long)this.idTipoOrigemReceita);
        this.currentTipoArrecadacao = TipoArrecadacao.fromValue((Long)this.idTipoArrecadacao);
    }

    public boolean isDuplicado() {
        return this.qtRegistros > 1L;
    }

    public boolean isTipoOrigemReceitaValida() {
        return Arrays.asList(TipoOrigemReceita.values()).contains(this.currentTipoOrigemReceita);
    }

    public boolean isLancamentoParaArrecadacaoValida() {
        return this.isArrecadacaoDeDividaAtiva() || this.nrCredito == null && this.nrAnoCredito == null || this.nrAnoCredito != null && this.nrAnoCredito.equals(this.lancamentoNrAnoCredito) && this.nrCredito != null && this.nrCredito.equals(this.lancamentoNrCredito);
    }

    public boolean isInscricaoDividaAtivaParaArrecadacaoValida() {
        return this.isArrecadacaoDoExercicio() || this.nrDivida == null && this.nrAnoDivida == null || this.nrAnoDivida != null && this.nrAnoDivida.equals(this.inscricaoNrAnoDivida) && this.nrDivida != null && this.nrDivida.equals(this.inscricaoNrDivida);
    }

    public boolean isTipoArrecadacaoValida() {
        return Arrays.asList(TipoArrecadacao.values()).contains(this.currentTipoArrecadacao);
    }

    public boolean isArrecadacaoDoAnoEMesDeTrabalho(LocalDate dataTrabalho) {
        return this.nrMes.equals(dataTrabalho.getMonthValue()) && this.nrAno.equals(dataTrabalho.getYear());
    }

    public boolean isValorArrecadacaoPositiva() {
        return this.vlArrecadacao.compareTo(BigDecimal.ZERO) >= 0;
    }

    public boolean isArrecadacaoDeLancamentoDoExercicio() {
        return this.isArrecadacaoDeDividaAtiva() || this.nrDivida == null && this.nrAnoDivida == null && this.nrCredito != null && this.nrAnoCredito != null;
    }

    public boolean isArreacadacaoDeInscricaoEmDividaAtiva() {
        return this.isArrecadacaoDoExercicio() || this.nrDivida != null && this.nrAnoDivida != null && this.nrCredito == null && this.nrAnoCredito == null;
    }

    public boolean isArrecadacaoDeLancamentoDoExercicioOuDividaAtiva() {
        return this.isArrecadacaoDeDividaAtiva() || this.isArrecadacaoDoExercicio();
    }

    public boolean isArrecadacaoDuplicado() {
        return this.qtArrecadacao > 1L;
    }

    public boolean isArrecadacaoELancamentoDeCreditoDoAnoDeTrabalho() {
        long menorExercicioFinanceiroValido = 2023L;
        return !this.isArrecadacaoDoExercicio() && !this.isArrecadacaoDeDividaAtiva() || (this.isArrecadacaoDoExercicio() ? this.nrAnoCredito != null && this.nrAnoCredito >= 2023L : this.nrAnoDivida != null && this.nrAnoDivida >= 2023L);
    }

    private boolean isArrecadacaoDoExercicio() {
        return TipoOrigemReceita.NAO_INSCRITO_DIVIDA_ATIVA.equals((Object)this.currentTipoOrigemReceita);
    }

    private boolean isArrecadacaoDeDividaAtiva() {
        return TipoOrigemReceita.DIVIDA_ATIVA.equals((Object)this.currentTipoOrigemReceita);
    }

    @Generated
    public static ArrecadacaoCreditoValidacaoBuilder builder() {
        return new ArrecadacaoCreditoValidacaoBuilder();
    }

    @Generated
    public TipoOrigemReceita getCurrentTipoOrigemReceita() {
        return this.currentTipoOrigemReceita;
    }

    @Generated
    public TipoArrecadacao getCurrentTipoArrecadacao() {
        return this.currentTipoArrecadacao;
    }

    @Generated
    public Long getIdTceArrTipoCredito() {
        return this.idTceArrTipoCredito;
    }

    @Generated
    public Long getNrArrecadacao() {
        return this.nrArrecadacao;
    }

    @Generated
    public Long getNrAnoArrecadacao() {
        return this.nrAnoArrecadacao;
    }

    @Generated
    public BigDecimal getVlArrecadacao() {
        return this.vlArrecadacao;
    }

    @Generated
    public Long getNrCredito() {
        return this.nrCredito;
    }

    @Generated
    public Long getNrAnoCredito() {
        return this.nrAnoCredito;
    }

    @Generated
    public Long getNrDivida() {
        return this.nrDivida;
    }

    @Generated
    public Long getNrAnoDivida() {
        return this.nrAnoDivida;
    }

    @Generated
    public Long getNrMes() {
        return this.nrMes;
    }

    @Generated
    public Long getNrAno() {
        return this.nrAno;
    }

    @Generated
    public Long getLancamentoNrCredito() {
        return this.lancamentoNrCredito;
    }

    @Generated
    public Long getLancamentoNrAnoCredito() {
        return this.lancamentoNrAnoCredito;
    }

    @Generated
    public Long getInscricaoNrDivida() {
        return this.inscricaoNrDivida;
    }

    @Generated
    public Long getInscricaoNrAnoDivida() {
        return this.inscricaoNrAnoDivida;
    }

    @Generated
    public Long getQtRegistros() {
        return this.qtRegistros;
    }

    @Generated
    public Long getQtArrecadacao() {
        return this.qtArrecadacao;
    }

    @Generated
    public Long getNrArrecadacaoAnterior() {
        return this.nrArrecadacaoAnterior;
    }

    @Generated
    public Long getIdTipoOrigemReceita() {
        return this.idTipoOrigemReceita;
    }

    @Generated
    public Long getIdTipoArrecadacao() {
        return this.idTipoArrecadacao;
    }

    @Generated
    public void setCurrentTipoOrigemReceita(TipoOrigemReceita currentTipoOrigemReceita) {
        this.currentTipoOrigemReceita = currentTipoOrigemReceita;
    }

    @Generated
    public void setCurrentTipoArrecadacao(TipoArrecadacao currentTipoArrecadacao) {
        this.currentTipoArrecadacao = currentTipoArrecadacao;
    }

    @Generated
    public void setIdTceArrTipoCredito(Long idTceArrTipoCredito) {
        this.idTceArrTipoCredito = idTceArrTipoCredito;
    }

    @Generated
    public void setNrArrecadacao(Long nrArrecadacao) {
        this.nrArrecadacao = nrArrecadacao;
    }

    @Generated
    public void setNrAnoArrecadacao(Long nrAnoArrecadacao) {
        this.nrAnoArrecadacao = nrAnoArrecadacao;
    }

    @Generated
    public void setVlArrecadacao(BigDecimal vlArrecadacao) {
        this.vlArrecadacao = vlArrecadacao;
    }

    @Generated
    public void setNrCredito(Long nrCredito) {
        this.nrCredito = nrCredito;
    }

    @Generated
    public void setNrAnoCredito(Long nrAnoCredito) {
        this.nrAnoCredito = nrAnoCredito;
    }

    @Generated
    public void setNrDivida(Long nrDivida) {
        this.nrDivida = nrDivida;
    }

    @Generated
    public void setNrAnoDivida(Long nrAnoDivida) {
        this.nrAnoDivida = nrAnoDivida;
    }

    @Generated
    public void setNrMes(Long nrMes) {
        this.nrMes = nrMes;
    }

    @Generated
    public void setNrAno(Long nrAno) {
        this.nrAno = nrAno;
    }

    @Generated
    public void setLancamentoNrCredito(Long lancamentoNrCredito) {
        this.lancamentoNrCredito = lancamentoNrCredito;
    }

    @Generated
    public void setLancamentoNrAnoCredito(Long lancamentoNrAnoCredito) {
        this.lancamentoNrAnoCredito = lancamentoNrAnoCredito;
    }

    @Generated
    public void setInscricaoNrDivida(Long inscricaoNrDivida) {
        this.inscricaoNrDivida = inscricaoNrDivida;
    }

    @Generated
    public void setInscricaoNrAnoDivida(Long inscricaoNrAnoDivida) {
        this.inscricaoNrAnoDivida = inscricaoNrAnoDivida;
    }

    @Generated
    public void setQtRegistros(Long qtRegistros) {
        this.qtRegistros = qtRegistros;
    }

    @Generated
    public void setQtArrecadacao(Long qtArrecadacao) {
        this.qtArrecadacao = qtArrecadacao;
    }

    @Generated
    public void setNrArrecadacaoAnterior(Long nrArrecadacaoAnterior) {
        this.nrArrecadacaoAnterior = nrArrecadacaoAnterior;
    }

    @Generated
    public void setIdTipoOrigemReceita(Long idTipoOrigemReceita) {
        this.idTipoOrigemReceita = idTipoOrigemReceita;
    }

    @Generated
    public void setIdTipoArrecadacao(Long idTipoArrecadacao) {
        this.idTipoArrecadacao = idTipoArrecadacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoCreditoValidacao)) {
            return false;
        }
        ArrecadacaoCreditoValidacao other = (ArrecadacaoCreditoValidacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idTceArrTipoCredito = this.getIdTceArrTipoCredito();
        Long other$idTceArrTipoCredito = other.getIdTceArrTipoCredito();
        if (this$idTceArrTipoCredito == null ? other$idTceArrTipoCredito != null : !((Object)this$idTceArrTipoCredito).equals(other$idTceArrTipoCredito)) {
            return false;
        }
        Long this$nrArrecadacao = this.getNrArrecadacao();
        Long other$nrArrecadacao = other.getNrArrecadacao();
        if (this$nrArrecadacao == null ? other$nrArrecadacao != null : !((Object)this$nrArrecadacao).equals(other$nrArrecadacao)) {
            return false;
        }
        Long this$nrAnoArrecadacao = this.getNrAnoArrecadacao();
        Long other$nrAnoArrecadacao = other.getNrAnoArrecadacao();
        if (this$nrAnoArrecadacao == null ? other$nrAnoArrecadacao != null : !((Object)this$nrAnoArrecadacao).equals(other$nrAnoArrecadacao)) {
            return false;
        }
        Long this$nrCredito = this.getNrCredito();
        Long other$nrCredito = other.getNrCredito();
        if (this$nrCredito == null ? other$nrCredito != null : !((Object)this$nrCredito).equals(other$nrCredito)) {
            return false;
        }
        Long this$nrAnoCredito = this.getNrAnoCredito();
        Long other$nrAnoCredito = other.getNrAnoCredito();
        if (this$nrAnoCredito == null ? other$nrAnoCredito != null : !((Object)this$nrAnoCredito).equals(other$nrAnoCredito)) {
            return false;
        }
        Long this$nrDivida = this.getNrDivida();
        Long other$nrDivida = other.getNrDivida();
        if (this$nrDivida == null ? other$nrDivida != null : !((Object)this$nrDivida).equals(other$nrDivida)) {
            return false;
        }
        Long this$nrAnoDivida = this.getNrAnoDivida();
        Long other$nrAnoDivida = other.getNrAnoDivida();
        if (this$nrAnoDivida == null ? other$nrAnoDivida != null : !((Object)this$nrAnoDivida).equals(other$nrAnoDivida)) {
            return false;
        }
        Long this$nrMes = this.getNrMes();
        Long other$nrMes = other.getNrMes();
        if (this$nrMes == null ? other$nrMes != null : !((Object)this$nrMes).equals(other$nrMes)) {
            return false;
        }
        Long this$nrAno = this.getNrAno();
        Long other$nrAno = other.getNrAno();
        if (this$nrAno == null ? other$nrAno != null : !((Object)this$nrAno).equals(other$nrAno)) {
            return false;
        }
        Long this$lancamentoNrCredito = this.getLancamentoNrCredito();
        Long other$lancamentoNrCredito = other.getLancamentoNrCredito();
        if (this$lancamentoNrCredito == null ? other$lancamentoNrCredito != null : !((Object)this$lancamentoNrCredito).equals(other$lancamentoNrCredito)) {
            return false;
        }
        Long this$lancamentoNrAnoCredito = this.getLancamentoNrAnoCredito();
        Long other$lancamentoNrAnoCredito = other.getLancamentoNrAnoCredito();
        if (this$lancamentoNrAnoCredito == null ? other$lancamentoNrAnoCredito != null : !((Object)this$lancamentoNrAnoCredito).equals(other$lancamentoNrAnoCredito)) {
            return false;
        }
        Long this$inscricaoNrDivida = this.getInscricaoNrDivida();
        Long other$inscricaoNrDivida = other.getInscricaoNrDivida();
        if (this$inscricaoNrDivida == null ? other$inscricaoNrDivida != null : !((Object)this$inscricaoNrDivida).equals(other$inscricaoNrDivida)) {
            return false;
        }
        Long this$inscricaoNrAnoDivida = this.getInscricaoNrAnoDivida();
        Long other$inscricaoNrAnoDivida = other.getInscricaoNrAnoDivida();
        if (this$inscricaoNrAnoDivida == null ? other$inscricaoNrAnoDivida != null : !((Object)this$inscricaoNrAnoDivida).equals(other$inscricaoNrAnoDivida)) {
            return false;
        }
        Long this$qtRegistros = this.getQtRegistros();
        Long other$qtRegistros = other.getQtRegistros();
        if (this$qtRegistros == null ? other$qtRegistros != null : !((Object)this$qtRegistros).equals(other$qtRegistros)) {
            return false;
        }
        Long this$qtArrecadacao = this.getQtArrecadacao();
        Long other$qtArrecadacao = other.getQtArrecadacao();
        if (this$qtArrecadacao == null ? other$qtArrecadacao != null : !((Object)this$qtArrecadacao).equals(other$qtArrecadacao)) {
            return false;
        }
        Long this$nrArrecadacaoAnterior = this.getNrArrecadacaoAnterior();
        Long other$nrArrecadacaoAnterior = other.getNrArrecadacaoAnterior();
        if (this$nrArrecadacaoAnterior == null ? other$nrArrecadacaoAnterior != null : !((Object)this$nrArrecadacaoAnterior).equals(other$nrArrecadacaoAnterior)) {
            return false;
        }
        Long this$idTipoOrigemReceita = this.getIdTipoOrigemReceita();
        Long other$idTipoOrigemReceita = other.getIdTipoOrigemReceita();
        if (this$idTipoOrigemReceita == null ? other$idTipoOrigemReceita != null : !((Object)this$idTipoOrigemReceita).equals(other$idTipoOrigemReceita)) {
            return false;
        }
        Long this$idTipoArrecadacao = this.getIdTipoArrecadacao();
        Long other$idTipoArrecadacao = other.getIdTipoArrecadacao();
        if (this$idTipoArrecadacao == null ? other$idTipoArrecadacao != null : !((Object)this$idTipoArrecadacao).equals(other$idTipoArrecadacao)) {
            return false;
        }
        TipoOrigemReceita this$currentTipoOrigemReceita = this.getCurrentTipoOrigemReceita();
        TipoOrigemReceita other$currentTipoOrigemReceita = other.getCurrentTipoOrigemReceita();
        if (this$currentTipoOrigemReceita == null ? other$currentTipoOrigemReceita != null : !this$currentTipoOrigemReceita.equals(other$currentTipoOrigemReceita)) {
            return false;
        }
        TipoArrecadacao this$currentTipoArrecadacao = this.getCurrentTipoArrecadacao();
        TipoArrecadacao other$currentTipoArrecadacao = other.getCurrentTipoArrecadacao();
        if (this$currentTipoArrecadacao == null ? other$currentTipoArrecadacao != null : !this$currentTipoArrecadacao.equals(other$currentTipoArrecadacao)) {
            return false;
        }
        BigDecimal this$vlArrecadacao = this.getVlArrecadacao();
        BigDecimal other$vlArrecadacao = other.getVlArrecadacao();
        return !(this$vlArrecadacao == null ? other$vlArrecadacao != null : !((Object)this$vlArrecadacao).equals(other$vlArrecadacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoCreditoValidacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idTceArrTipoCredito = this.getIdTceArrTipoCredito();
        result = result * 59 + ($idTceArrTipoCredito == null ? 43 : ((Object)$idTceArrTipoCredito).hashCode());
        Long $nrArrecadacao = this.getNrArrecadacao();
        result = result * 59 + ($nrArrecadacao == null ? 43 : ((Object)$nrArrecadacao).hashCode());
        Long $nrAnoArrecadacao = this.getNrAnoArrecadacao();
        result = result * 59 + ($nrAnoArrecadacao == null ? 43 : ((Object)$nrAnoArrecadacao).hashCode());
        Long $nrCredito = this.getNrCredito();
        result = result * 59 + ($nrCredito == null ? 43 : ((Object)$nrCredito).hashCode());
        Long $nrAnoCredito = this.getNrAnoCredito();
        result = result * 59 + ($nrAnoCredito == null ? 43 : ((Object)$nrAnoCredito).hashCode());
        Long $nrDivida = this.getNrDivida();
        result = result * 59 + ($nrDivida == null ? 43 : ((Object)$nrDivida).hashCode());
        Long $nrAnoDivida = this.getNrAnoDivida();
        result = result * 59 + ($nrAnoDivida == null ? 43 : ((Object)$nrAnoDivida).hashCode());
        Long $nrMes = this.getNrMes();
        result = result * 59 + ($nrMes == null ? 43 : ((Object)$nrMes).hashCode());
        Long $nrAno = this.getNrAno();
        result = result * 59 + ($nrAno == null ? 43 : ((Object)$nrAno).hashCode());
        Long $lancamentoNrCredito = this.getLancamentoNrCredito();
        result = result * 59 + ($lancamentoNrCredito == null ? 43 : ((Object)$lancamentoNrCredito).hashCode());
        Long $lancamentoNrAnoCredito = this.getLancamentoNrAnoCredito();
        result = result * 59 + ($lancamentoNrAnoCredito == null ? 43 : ((Object)$lancamentoNrAnoCredito).hashCode());
        Long $inscricaoNrDivida = this.getInscricaoNrDivida();
        result = result * 59 + ($inscricaoNrDivida == null ? 43 : ((Object)$inscricaoNrDivida).hashCode());
        Long $inscricaoNrAnoDivida = this.getInscricaoNrAnoDivida();
        result = result * 59 + ($inscricaoNrAnoDivida == null ? 43 : ((Object)$inscricaoNrAnoDivida).hashCode());
        Long $qtRegistros = this.getQtRegistros();
        result = result * 59 + ($qtRegistros == null ? 43 : ((Object)$qtRegistros).hashCode());
        Long $qtArrecadacao = this.getQtArrecadacao();
        result = result * 59 + ($qtArrecadacao == null ? 43 : ((Object)$qtArrecadacao).hashCode());
        Long $nrArrecadacaoAnterior = this.getNrArrecadacaoAnterior();
        result = result * 59 + ($nrArrecadacaoAnterior == null ? 43 : ((Object)$nrArrecadacaoAnterior).hashCode());
        Long $idTipoOrigemReceita = this.getIdTipoOrigemReceita();
        result = result * 59 + ($idTipoOrigemReceita == null ? 43 : ((Object)$idTipoOrigemReceita).hashCode());
        Long $idTipoArrecadacao = this.getIdTipoArrecadacao();
        result = result * 59 + ($idTipoArrecadacao == null ? 43 : ((Object)$idTipoArrecadacao).hashCode());
        TipoOrigemReceita $currentTipoOrigemReceita = this.getCurrentTipoOrigemReceita();
        result = result * 59 + ($currentTipoOrigemReceita == null ? 43 : $currentTipoOrigemReceita.hashCode());
        TipoArrecadacao $currentTipoArrecadacao = this.getCurrentTipoArrecadacao();
        result = result * 59 + ($currentTipoArrecadacao == null ? 43 : $currentTipoArrecadacao.hashCode());
        BigDecimal $vlArrecadacao = this.getVlArrecadacao();
        result = result * 59 + ($vlArrecadacao == null ? 43 : ((Object)$vlArrecadacao).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrecadacaoCreditoValidacao(currentTipoOrigemReceita=" + String.valueOf(this.getCurrentTipoOrigemReceita()) + ", currentTipoArrecadacao=" + String.valueOf(this.getCurrentTipoArrecadacao()) + ", idTceArrTipoCredito=" + this.getIdTceArrTipoCredito() + ", nrArrecadacao=" + this.getNrArrecadacao() + ", nrAnoArrecadacao=" + this.getNrAnoArrecadacao() + ", vlArrecadacao=" + String.valueOf(this.getVlArrecadacao()) + ", nrCredito=" + this.getNrCredito() + ", nrAnoCredito=" + this.getNrAnoCredito() + ", nrDivida=" + this.getNrDivida() + ", nrAnoDivida=" + this.getNrAnoDivida() + ", nrMes=" + this.getNrMes() + ", nrAno=" + this.getNrAno() + ", lancamentoNrCredito=" + this.getLancamentoNrCredito() + ", lancamentoNrAnoCredito=" + this.getLancamentoNrAnoCredito() + ", inscricaoNrDivida=" + this.getInscricaoNrDivida() + ", inscricaoNrAnoDivida=" + this.getInscricaoNrAnoDivida() + ", qtRegistros=" + this.getQtRegistros() + ", qtArrecadacao=" + this.getQtArrecadacao() + ", nrArrecadacaoAnterior=" + this.getNrArrecadacaoAnterior() + ", idTipoOrigemReceita=" + this.getIdTipoOrigemReceita() + ", idTipoArrecadacao=" + this.getIdTipoArrecadacao() + ")";
    }

    @Generated
    public ArrecadacaoCreditoValidacao() {
    }

    @Generated
    public ArrecadacaoCreditoValidacao(TipoOrigemReceita currentTipoOrigemReceita, TipoArrecadacao currentTipoArrecadacao, Long idTceArrTipoCredito, Long nrArrecadacao, Long nrAnoArrecadacao, BigDecimal vlArrecadacao, Long nrCredito, Long nrAnoCredito, Long nrDivida, Long nrAnoDivida, Long nrMes, Long nrAno, Long lancamentoNrCredito, Long lancamentoNrAnoCredito, Long inscricaoNrDivida, Long inscricaoNrAnoDivida, Long qtRegistros, Long qtArrecadacao, Long nrArrecadacaoAnterior, Long idTipoOrigemReceita, Long idTipoArrecadacao) {
        this.currentTipoOrigemReceita = currentTipoOrigemReceita;
        this.currentTipoArrecadacao = currentTipoArrecadacao;
        this.idTceArrTipoCredito = idTceArrTipoCredito;
        this.nrArrecadacao = nrArrecadacao;
        this.nrAnoArrecadacao = nrAnoArrecadacao;
        this.vlArrecadacao = vlArrecadacao;
        this.nrCredito = nrCredito;
        this.nrAnoCredito = nrAnoCredito;
        this.nrDivida = nrDivida;
        this.nrAnoDivida = nrAnoDivida;
        this.nrMes = nrMes;
        this.nrAno = nrAno;
        this.lancamentoNrCredito = lancamentoNrCredito;
        this.lancamentoNrAnoCredito = lancamentoNrAnoCredito;
        this.inscricaoNrDivida = inscricaoNrDivida;
        this.inscricaoNrAnoDivida = inscricaoNrAnoDivida;
        this.qtRegistros = qtRegistros;
        this.qtArrecadacao = qtArrecadacao;
        this.nrArrecadacaoAnterior = nrArrecadacaoAnterior;
        this.idTipoOrigemReceita = idTipoOrigemReceita;
        this.idTipoArrecadacao = idTipoArrecadacao;
    }
}

