/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.sanepar;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparItemDTO;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaixaSaneparItemDTO
implements DatasetRecord {
    @NotNull
    private Long id;
    @NotNull
    private Long linha;
    @NotNull
    private String matricula;
    @NotNull
    private BigDecimal valor;
    @NotNull
    private LocalDate dataPagamento;
    @NotNull
    private SituacaoItemSanepar situacao;
    @Nullable
    String mensagem;
    @Nullable
    private Map<String, Object> debito;
    @Nullable
    private Map<String, Object> boleto;
    @Nullable
    private Map<String, Object> pagamento;
    @NotNull
    private String banco;
    @NotNull
    private String dataMovimentoFormatada;
    @NotNull
    private String contaBancaria;
    @NotNull
    private String convenio;
    @NotNull
    private String descricaoLote;
    @NotNull
    private int numeroItens;
    @NotNull
    private String nomeArquivo;
    @NotNull
    private String dataLoteFormatada;
    @NotNull
    private String nome;
    @NotNull
    private String documento;
    @NotNull
    private String logradouro;
    @NotNull
    private String numeroImovel;

    public static BaixaSaneparItemDTO from(BaixaSaneparItem entity) {
        return BaixaSaneparItemDTO.builder().id(entity.getId()).linha(entity.getLinha()).matricula(entity.getMatricula()).valor(entity.getValor()).dataPagamento(entity.getDataPagamento()).situacao(entity.getSituacao()).mensagem(entity.getMensagem()).debito(BaixaSaneparItemDTO.createDebito((Debito)entity.getDebito())).boleto(BaixaSaneparItemDTO.createBoleto((Bloqueto)entity.getBoleto())).pagamento(BaixaSaneparItemDTO.createPagamento((Pagamento)entity.getPagamento())).build();
    }

    public static BaixaSaneparItemDTO fromWithReportData(BaixaSaneparItem entity) {
        return BaixaSaneparItemDTO.builder().id(entity.getId()).linha(entity.getLinha()).matricula(entity.getMatricula()).valor(entity.getValor()).dataPagamento(entity.getDataPagamento()).situacao(entity.getSituacao()).mensagem(entity.getMensagem()).debito(BaixaSaneparItemDTO.createDebito((Debito)entity.getDebito())).boleto(BaixaSaneparItemDTO.createBoleto((Bloqueto)entity.getBoleto())).pagamento(BaixaSaneparItemDTO.createPagamento((Pagamento)entity.getPagamento())).dataMovimentoFormatada(DateUtils.localDateToStringFormatoBrasileiro((LocalDate)entity.getBaixa().getLote().getDataMovimento())).banco(entity.getBaixa().getLote().getBanco().getId() + " - " + entity.getBaixa().getLote().getBanco().getDescricao()).contaBancaria(entity.getBaixa().getLote().getContaBancaria().getId() + " - " + entity.getBaixa().getLote().getContaBancaria().getDescricao()).convenio(entity.getBaixa().getLote().getConvenio().getId() + " - " + entity.getBaixa().getLote().getConvenio().getDescricao()).descricaoLote(entity.getBaixa().getLote().getId().getLote() + "/" + entity.getBaixa().getLote().getId().getExercicio()).nomeArquivo(entity.getBaixa().getNomeArquivo()).numeroItens(entity.getBaixa().getItens().size()).dataLoteFormatada(DateUtils.localDateToStringFormatoBrasileiro((LocalDate)entity.getBaixa().getLote().getDataLote())).nome(entity.getNome()).documento(entity.getDocNumero()).logradouro(entity.getLogradouro()).numeroImovel(entity.getNumeroImovel()).build();
    }

    private static Map<String, Object> createDebito(Debito entity) {
        if (entity == null) {
            return null;
        }
        return Map.of("id", entity.getId(), "exercicio", entity.getExercicio(), "guiaRecolhimento", entity.getGuiaRecolhimento(), "subDivida", entity.getSubDivida());
    }

    private static Map<String, Object> createBoleto(Bloqueto entity) {
        if (entity == null) {
            return null;
        }
        return Map.of("id", entity.getId(), "bloqueto", entity.getBloqueto(), "exercicio", entity.getExercicioBloqueto());
    }

    private static Map<String, Object> createPagamento(Pagamento entity) {
        if (entity == null) {
            return null;
        }
        return Map.of("id", entity.getId(), "entidade", entity.getId().getEntidade(), "exercicio", entity.getId().getExercicioPagamento(), "pagamento", entity.getId().getPagamento());
    }

    @Generated
    public static BaixaSaneparItemDTOBuilder builder() {
        return new BaixaSaneparItemDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getLinha() {
        return this.linha;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public SituacaoItemSanepar getSituacao() {
        return this.situacao;
    }

    @Nullable
    @Generated
    public String getMensagem() {
        return this.mensagem;
    }

    @Nullable
    @Generated
    public Map<String, Object> getDebito() {
        return this.debito;
    }

    @Nullable
    @Generated
    public Map<String, Object> getBoleto() {
        return this.boleto;
    }

    @Nullable
    @Generated
    public Map<String, Object> getPagamento() {
        return this.pagamento;
    }

    @Generated
    public String getBanco() {
        return this.banco;
    }

    @Generated
    public String getDataMovimentoFormatada() {
        return this.dataMovimentoFormatada;
    }

    @Generated
    public String getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public String getConvenio() {
        return this.convenio;
    }

    @Generated
    public String getDescricaoLote() {
        return this.descricaoLote;
    }

    @Generated
    public int getNumeroItens() {
        return this.numeroItens;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public String getDataLoteFormatada() {
        return this.dataLoteFormatada;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getDocumento() {
        return this.documento;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumeroImovel() {
        return this.numeroImovel;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLinha(Long linha) {
        this.linha = linha;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setSituacao(SituacaoItemSanepar situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setMensagem(@Nullable String mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public void setDebito(@Nullable Map<String, Object> debito) {
        this.debito = debito;
    }

    @Generated
    public void setBoleto(@Nullable Map<String, Object> boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setPagamento(@Nullable Map<String, Object> pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setBanco(String banco) {
        this.banco = banco;
    }

    @Generated
    public void setDataMovimentoFormatada(String dataMovimentoFormatada) {
        this.dataMovimentoFormatada = dataMovimentoFormatada;
    }

    @Generated
    public void setContaBancaria(String contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setConvenio(String convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDescricaoLote(String descricaoLote) {
        this.descricaoLote = descricaoLote;
    }

    @Generated
    public void setNumeroItens(int numeroItens) {
        this.numeroItens = numeroItens;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setDataLoteFormatada(String dataLoteFormatada) {
        this.dataLoteFormatada = dataLoteFormatada;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDocumento(String documento) {
        this.documento = documento;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumeroImovel(String numeroImovel) {
        this.numeroImovel = numeroImovel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaixaSaneparItemDTO)) {
            return false;
        }
        BaixaSaneparItemDTO other = (BaixaSaneparItemDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getNumeroItens() != other.getNumeroItens()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$linha = this.getLinha();
        Long other$linha = other.getLinha();
        if (this$linha == null ? other$linha != null : !((Object)this$linha).equals(other$linha)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        SituacaoItemSanepar this$situacao = this.getSituacao();
        SituacaoItemSanepar other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$mensagem = this.getMensagem();
        String other$mensagem = other.getMensagem();
        if (this$mensagem == null ? other$mensagem != null : !this$mensagem.equals(other$mensagem)) {
            return false;
        }
        Map this$debito = this.getDebito();
        Map other$debito = other.getDebito();
        if (this$debito == null ? other$debito != null : !((Object)this$debito).equals(other$debito)) {
            return false;
        }
        Map this$boleto = this.getBoleto();
        Map other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Map this$pagamento = this.getPagamento();
        Map other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        String this$banco = this.getBanco();
        String other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !this$banco.equals(other$banco)) {
            return false;
        }
        String this$dataMovimentoFormatada = this.getDataMovimentoFormatada();
        String other$dataMovimentoFormatada = other.getDataMovimentoFormatada();
        if (this$dataMovimentoFormatada == null ? other$dataMovimentoFormatada != null : !this$dataMovimentoFormatada.equals(other$dataMovimentoFormatada)) {
            return false;
        }
        String this$contaBancaria = this.getContaBancaria();
        String other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        String this$convenio = this.getConvenio();
        String other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !this$convenio.equals(other$convenio)) {
            return false;
        }
        String this$descricaoLote = this.getDescricaoLote();
        String other$descricaoLote = other.getDescricaoLote();
        if (this$descricaoLote == null ? other$descricaoLote != null : !this$descricaoLote.equals(other$descricaoLote)) {
            return false;
        }
        String this$nomeArquivo = this.getNomeArquivo();
        String other$nomeArquivo = other.getNomeArquivo();
        if (this$nomeArquivo == null ? other$nomeArquivo != null : !this$nomeArquivo.equals(other$nomeArquivo)) {
            return false;
        }
        String this$dataLoteFormatada = this.getDataLoteFormatada();
        String other$dataLoteFormatada = other.getDataLoteFormatada();
        if (this$dataLoteFormatada == null ? other$dataLoteFormatada != null : !this$dataLoteFormatada.equals(other$dataLoteFormatada)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$documento = this.getDocumento();
        String other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numeroImovel = this.getNumeroImovel();
        String other$numeroImovel = other.getNumeroImovel();
        return !(this$numeroImovel == null ? other$numeroImovel != null : !this$numeroImovel.equals(other$numeroImovel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaixaSaneparItemDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumeroItens();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $linha = this.getLinha();
        result = result * 59 + ($linha == null ? 43 : ((Object)$linha).hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        SituacaoItemSanepar $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $mensagem = this.getMensagem();
        result = result * 59 + ($mensagem == null ? 43 : $mensagem.hashCode());
        Map $debito = this.getDebito();
        result = result * 59 + ($debito == null ? 43 : ((Object)$debito).hashCode());
        Map $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Map $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        String $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : $banco.hashCode());
        String $dataMovimentoFormatada = this.getDataMovimentoFormatada();
        result = result * 59 + ($dataMovimentoFormatada == null ? 43 : $dataMovimentoFormatada.hashCode());
        String $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        String $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : $convenio.hashCode());
        String $descricaoLote = this.getDescricaoLote();
        result = result * 59 + ($descricaoLote == null ? 43 : $descricaoLote.hashCode());
        String $nomeArquivo = this.getNomeArquivo();
        result = result * 59 + ($nomeArquivo == null ? 43 : $nomeArquivo.hashCode());
        String $dataLoteFormatada = this.getDataLoteFormatada();
        result = result * 59 + ($dataLoteFormatada == null ? 43 : $dataLoteFormatada.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numeroImovel = this.getNumeroImovel();
        result = result * 59 + ($numeroImovel == null ? 43 : $numeroImovel.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaixaSaneparItemDTO(id=" + this.getId() + ", linha=" + this.getLinha() + ", matricula=" + this.getMatricula() + ", valor=" + String.valueOf(this.getValor()) + ", dataPagamento=" + String.valueOf(this.getDataPagamento()) + ", situacao=" + String.valueOf(this.getSituacao()) + ", mensagem=" + this.getMensagem() + ", debito=" + String.valueOf(this.getDebito()) + ", boleto=" + String.valueOf(this.getBoleto()) + ", pagamento=" + String.valueOf(this.getPagamento()) + ", banco=" + this.getBanco() + ", dataMovimentoFormatada=" + this.getDataMovimentoFormatada() + ", contaBancaria=" + this.getContaBancaria() + ", convenio=" + this.getConvenio() + ", descricaoLote=" + this.getDescricaoLote() + ", numeroItens=" + this.getNumeroItens() + ", nomeArquivo=" + this.getNomeArquivo() + ", dataLoteFormatada=" + this.getDataLoteFormatada() + ", nome=" + this.getNome() + ", documento=" + this.getDocumento() + ", logradouro=" + this.getLogradouro() + ", numeroImovel=" + this.getNumeroImovel() + ")";
    }

    @Generated
    public BaixaSaneparItemDTO() {
    }

    @Generated
    public BaixaSaneparItemDTO(Long id, Long linha, String matricula, BigDecimal valor, LocalDate dataPagamento, SituacaoItemSanepar situacao, @Nullable String mensagem, @Nullable Map<String, Object> debito, @Nullable Map<String, Object> boleto, @Nullable Map<String, Object> pagamento, String banco, String dataMovimentoFormatada, String contaBancaria, String convenio, String descricaoLote, int numeroItens, String nomeArquivo, String dataLoteFormatada, String nome, String documento, String logradouro, String numeroImovel) {
        this.id = id;
        this.linha = linha;
        this.matricula = matricula;
        this.valor = valor;
        this.dataPagamento = dataPagamento;
        this.situacao = situacao;
        this.mensagem = mensagem;
        this.debito = debito;
        this.boleto = boleto;
        this.pagamento = pagamento;
        this.banco = banco;
        this.dataMovimentoFormatada = dataMovimentoFormatada;
        this.contaBancaria = contaBancaria;
        this.convenio = convenio;
        this.descricaoLote = descricaoLote;
        this.numeroItens = numeroItens;
        this.nomeArquivo = nomeArquivo;
        this.dataLoteFormatada = dataLoteFormatada;
        this.nome = nome;
        this.documento = documento;
        this.logradouro = logradouro;
        this.numeroImovel = numeroImovel;
    }
}

