/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.projeto.construtora;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.projeto.construtora.Construtora;
import br.com.elotech.tributos.dto.ProfissionalDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConstrutoraDTO {
    private Long id;
    private Long idCadastro;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private String nomeConstrutora;
    private String nomeFantasia;
    private LocalDate validade;
    private Boolean ativo;
    private List<ProfissionalDTO> profissionais;

    public static ConstrutoraDTO from(Construtora construtora, List<ProfissionalDTO> profissionais) {
        ConstrutoraDTO construtoraDTO = new ConstrutoraDTO();
        construtoraDTO.setId(construtora.getId());
        construtoraDTO.setIdCadastro((Long)Optional.ofNullable(construtora.getCadastroGeral()).map(CadastroGeral::getId).orElse(null));
        construtoraDTO.setTipoCadastro((TipoCadastro)Optional.ofNullable(construtora.getCadastroGeral()).map(CadastroGeral::getTipoCadastro).orElse(null));
        construtoraDTO.setCadastroGeral((Long)Optional.ofNullable(construtora.getCadastroGeral()).map(CadastroGeral::getCadastroGeral).orElse(null));
        construtoraDTO.setNomeConstrutora((String)Optional.ofNullable(construtora.getCadastroGeral()).map(CadastroGeral::getPessoa).map(Pessoa::getNome).orElse(null));
        construtoraDTO.setNomeFantasia((String)Optional.ofNullable(construtora.getCadastroGeral()).map(CadastroGeral::getPessoa).map(Pessoa::getNomeFantasia).orElse(null));
        construtoraDTO.setValidade(construtora.getValidade());
        construtoraDTO.setAtivo(construtora.getAtivo());
        construtoraDTO.setProfissionais(profissionais);
        return construtoraDTO;
    }

    public Construtora toEntity() {
        Construtora construtora = new Construtora();
        construtora.setId(this.id);
        CadastroGeral cadastroGeralEntity = new CadastroGeral();
        cadastroGeralEntity.setId(this.idCadastro);
        cadastroGeralEntity.setCadastroGeral(this.cadastroGeral);
        cadastroGeralEntity.setTipoCadastro(this.tipoCadastro);
        construtora.setCadastroGeral(cadastroGeralEntity);
        construtora.setValidade(this.validade);
        construtora.setAtivo(this.ativo);
        List profissionaisEntity = this.profissionais.stream().map(p -> {
            Profissional profissional = new Profissional();
            Pessoa pessoa = new Pessoa();
            pessoa.setId(p.getId());
            ProfissionalId id = new ProfissionalId();
            id.setPessoa(pessoa);
            profissional.setId(id);
            return profissional;
        }).collect(Collectors.toList());
        construtora.setProfissionais(profissionaisEntity);
        return construtora;
    }

    @Generated
    public ConstrutoraDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNomeConstrutora() {
        return this.nomeConstrutora;
    }

    @Generated
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Generated
    public LocalDate getValidade() {
        return this.validade;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public List<ProfissionalDTO> getProfissionais() {
        return this.profissionais;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNomeConstrutora(String nomeConstrutora) {
        this.nomeConstrutora = nomeConstrutora;
    }

    @Generated
    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    @Generated
    public void setValidade(LocalDate validade) {
        this.validade = validade;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setProfissionais(List<ProfissionalDTO> profissionais) {
        this.profissionais = profissionais;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstrutoraDTO)) {
            return false;
        }
        ConstrutoraDTO other = (ConstrutoraDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$nomeConstrutora = this.getNomeConstrutora();
        String other$nomeConstrutora = other.getNomeConstrutora();
        if (this$nomeConstrutora == null ? other$nomeConstrutora != null : !this$nomeConstrutora.equals(other$nomeConstrutora)) {
            return false;
        }
        String this$nomeFantasia = this.getNomeFantasia();
        String other$nomeFantasia = other.getNomeFantasia();
        if (this$nomeFantasia == null ? other$nomeFantasia != null : !this$nomeFantasia.equals(other$nomeFantasia)) {
            return false;
        }
        LocalDate this$validade = this.getValidade();
        LocalDate other$validade = other.getValidade();
        if (this$validade == null ? other$validade != null : !((Object)this$validade).equals(other$validade)) {
            return false;
        }
        List this$profissionais = this.getProfissionais();
        List other$profissionais = other.getProfissionais();
        return !(this$profissionais == null ? other$profissionais != null : !((Object)this$profissionais).equals(other$profissionais));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConstrutoraDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $nomeConstrutora = this.getNomeConstrutora();
        result = result * 59 + ($nomeConstrutora == null ? 43 : $nomeConstrutora.hashCode());
        String $nomeFantasia = this.getNomeFantasia();
        result = result * 59 + ($nomeFantasia == null ? 43 : $nomeFantasia.hashCode());
        LocalDate $validade = this.getValidade();
        result = result * 59 + ($validade == null ? 43 : ((Object)$validade).hashCode());
        List $profissionais = this.getProfissionais();
        result = result * 59 + ($profissionais == null ? 43 : ((Object)$profissionais).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConstrutoraDTO(id=" + this.getId() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", nomeConstrutora=" + this.getNomeConstrutora() + ", nomeFantasia=" + this.getNomeFantasia() + ", validade=" + String.valueOf(this.getValidade()) + ", ativo=" + this.getAtivo() + ", profissionais=" + String.valueOf(this.getProfissionais()) + ")";
    }
}

