/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.projeto;

import br.com.elotech.tributos.domain.projeto.ProjetoItem;
import br.com.elotech.tributos.domain.projeto.TipoConstrucao;
import br.com.elotech.tributos.dto.projeto.ItemConstrucaoCivilDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoItemGeraDebitoDTO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjetoItemGeraDebitoDTO {
    private Long id;
    private ItemConstrucaoCivilDTO itemConstrucaoCivil;
    private String utilizacao;
    private Boolean calculoPorUtilizacao;
    private String tipoConstrucao;
    private BigDecimal area;
    private BigDecimal areaProjeto;
    private List<String> tributosGeradas;

    public static ProjetoItemGeraDebitoDTO from(ProjetoItem item) {
        ProjetoItemGeraDebitoDTO dto = new ProjetoItemGeraDebitoDTO();
        dto.setId(item.getId());
        dto.setArea(item.getArea());
        dto.setAreaProjeto(item.getProjeto().getArea());
        dto.setTributosGeradas(ProjetoItemGeraDebitoDTO.getTributosJaGerados((ProjetoItem)item));
        Optional.ofNullable(item.getItemConstrucaoCivil()).map(ItemConstrucaoCivilDTO::from).ifPresent(arg_0 -> dto.setItemConstrucaoCivil(arg_0));
        Optional.ofNullable(item.getUtilizacao()).ifPresent(utilizacao -> {
            dto.setUtilizacao(utilizacao.getDescricao());
            dto.setCalculoPorUtilizacao(utilizacao.getCalculoPorUtilizacao());
        });
        Optional.ofNullable(item.getTipoConstrucao()).map(TipoConstrucao::getDescricao).ifPresent(arg_0 -> dto.setTipoConstrucao(arg_0));
        dto.getItemConstrucaoCivil().getFormulas().forEach(formula -> {
            boolean tributoGerado = dto.getTributosGeradas().contains(formula.getTributo().getTributo());
            formula.setGeraDebito(!tributoGerado);
            formula.setProjetoItem(dto.getId());
        });
        return dto;
    }

    private static List<String> getTributosJaGerados(ProjetoItem projetoItem) {
        return Stream.of(ProjetoItemGeraDebitoDTO.getTributosJaGeradosItem((ProjetoItem)projetoItem), ProjetoItemGeraDebitoDTO.getTributosJaGeradosUtilizacao((ProjetoItem)projetoItem), ProjetoItemGeraDebitoDTO.getTributosJaGeradosProjeto((ProjetoItem)projetoItem)).flatMap(Collection::stream).toList();
    }

    private static List<String> getTributosJaGeradosItem(ProjetoItem projetoItem) {
        return projetoItem.getProjeto().getDebitos().stream().filter(projetoDebito -> Objects.nonNull(projetoDebito.getProjetoItem()) && projetoDebito.getProjetoItem().equals(projetoItem.getId())).flatMap(projetoDebito -> projetoDebito.getDebito().getTributos().stream()).map(debitoTributo -> debitoTributo.getId().getTributo()).toList();
    }

    private static List<String> getTributosJaGeradosUtilizacao(ProjetoItem projetoItem) {
        if (Objects.isNull(projetoItem.getUtilizacao())) {
            return List.of();
        }
        return projetoItem.getProjeto().getDebitos().stream().filter(projetoDebito -> Objects.nonNull(projetoDebito.getUtilizacao()) && projetoDebito.getUtilizacao().getId().equals(projetoItem.getUtilizacao().getId())).flatMap(projetoDebito -> projetoDebito.getDebito().getTributos().stream()).map(debitoTributo -> debitoTributo.getId().getTributo()).toList();
    }

    private static List<String> getTributosJaGeradosProjeto(ProjetoItem projetoItem) {
        return projetoItem.getProjeto().getDebitos().stream().filter(projetoDebito -> Objects.isNull(projetoDebito.getProjetoItem()) && Objects.isNull(projetoDebito.getUtilizacao())).flatMap(projetoDebito -> projetoDebito.getDebito().getTributos().stream()).map(debitoTributo -> debitoTributo.getId().getTributo()).toList();
    }

    @Generated
    public static ProjetoItemGeraDebitoDTOBuilder builder() {
        return new ProjetoItemGeraDebitoDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public ItemConstrucaoCivilDTO getItemConstrucaoCivil() {
        return this.itemConstrucaoCivil;
    }

    @Generated
    public String getUtilizacao() {
        return this.utilizacao;
    }

    @Generated
    public Boolean getCalculoPorUtilizacao() {
        return this.calculoPorUtilizacao;
    }

    @Generated
    public String getTipoConstrucao() {
        return this.tipoConstrucao;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public BigDecimal getAreaProjeto() {
        return this.areaProjeto;
    }

    @Generated
    public List<String> getTributosGeradas() {
        return this.tributosGeradas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setItemConstrucaoCivil(ItemConstrucaoCivilDTO itemConstrucaoCivil) {
        this.itemConstrucaoCivil = itemConstrucaoCivil;
    }

    @Generated
    public void setUtilizacao(String utilizacao) {
        this.utilizacao = utilizacao;
    }

    @Generated
    public void setCalculoPorUtilizacao(Boolean calculoPorUtilizacao) {
        this.calculoPorUtilizacao = calculoPorUtilizacao;
    }

    @Generated
    public void setTipoConstrucao(String tipoConstrucao) {
        this.tipoConstrucao = tipoConstrucao;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setAreaProjeto(BigDecimal areaProjeto) {
        this.areaProjeto = areaProjeto;
    }

    @Generated
    public void setTributosGeradas(List<String> tributosGeradas) {
        this.tributosGeradas = tributosGeradas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjetoItemGeraDebitoDTO)) {
            return false;
        }
        ProjetoItemGeraDebitoDTO other = (ProjetoItemGeraDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$calculoPorUtilizacao = this.getCalculoPorUtilizacao();
        Boolean other$calculoPorUtilizacao = other.getCalculoPorUtilizacao();
        if (this$calculoPorUtilizacao == null ? other$calculoPorUtilizacao != null : !((Object)this$calculoPorUtilizacao).equals(other$calculoPorUtilizacao)) {
            return false;
        }
        ItemConstrucaoCivilDTO this$itemConstrucaoCivil = this.getItemConstrucaoCivil();
        ItemConstrucaoCivilDTO other$itemConstrucaoCivil = other.getItemConstrucaoCivil();
        if (this$itemConstrucaoCivil == null ? other$itemConstrucaoCivil != null : !this$itemConstrucaoCivil.equals(other$itemConstrucaoCivil)) {
            return false;
        }
        String this$utilizacao = this.getUtilizacao();
        String other$utilizacao = other.getUtilizacao();
        if (this$utilizacao == null ? other$utilizacao != null : !this$utilizacao.equals(other$utilizacao)) {
            return false;
        }
        String this$tipoConstrucao = this.getTipoConstrucao();
        String other$tipoConstrucao = other.getTipoConstrucao();
        if (this$tipoConstrucao == null ? other$tipoConstrucao != null : !this$tipoConstrucao.equals(other$tipoConstrucao)) {
            return false;
        }
        BigDecimal this$area = this.getArea();
        BigDecimal other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)this$area).equals(other$area)) {
            return false;
        }
        BigDecimal this$areaProjeto = this.getAreaProjeto();
        BigDecimal other$areaProjeto = other.getAreaProjeto();
        if (this$areaProjeto == null ? other$areaProjeto != null : !((Object)this$areaProjeto).equals(other$areaProjeto)) {
            return false;
        }
        List this$tributosGeradas = this.getTributosGeradas();
        List other$tributosGeradas = other.getTributosGeradas();
        return !(this$tributosGeradas == null ? other$tributosGeradas != null : !((Object)this$tributosGeradas).equals(other$tributosGeradas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjetoItemGeraDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $calculoPorUtilizacao = this.getCalculoPorUtilizacao();
        result = result * 59 + ($calculoPorUtilizacao == null ? 43 : ((Object)$calculoPorUtilizacao).hashCode());
        ItemConstrucaoCivilDTO $itemConstrucaoCivil = this.getItemConstrucaoCivil();
        result = result * 59 + ($itemConstrucaoCivil == null ? 43 : $itemConstrucaoCivil.hashCode());
        String $utilizacao = this.getUtilizacao();
        result = result * 59 + ($utilizacao == null ? 43 : $utilizacao.hashCode());
        String $tipoConstrucao = this.getTipoConstrucao();
        result = result * 59 + ($tipoConstrucao == null ? 43 : $tipoConstrucao.hashCode());
        BigDecimal $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
        BigDecimal $areaProjeto = this.getAreaProjeto();
        result = result * 59 + ($areaProjeto == null ? 43 : ((Object)$areaProjeto).hashCode());
        List $tributosGeradas = this.getTributosGeradas();
        result = result * 59 + ($tributosGeradas == null ? 43 : ((Object)$tributosGeradas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProjetoItemGeraDebitoDTO(id=" + this.getId() + ", itemConstrucaoCivil=" + String.valueOf(this.getItemConstrucaoCivil()) + ", utilizacao=" + this.getUtilizacao() + ", calculoPorUtilizacao=" + this.getCalculoPorUtilizacao() + ", tipoConstrucao=" + this.getTipoConstrucao() + ", area=" + String.valueOf(this.getArea()) + ", areaProjeto=" + String.valueOf(this.getAreaProjeto()) + ", tributosGeradas=" + String.valueOf(this.getTributosGeradas()) + ")";
    }

    @Generated
    public ProjetoItemGeraDebitoDTO(Long id, ItemConstrucaoCivilDTO itemConstrucaoCivil, String utilizacao, Boolean calculoPorUtilizacao, String tipoConstrucao, BigDecimal area, BigDecimal areaProjeto, List<String> tributosGeradas) {
        this.id = id;
        this.itemConstrucaoCivil = itemConstrucaoCivil;
        this.utilizacao = utilizacao;
        this.calculoPorUtilizacao = calculoPorUtilizacao;
        this.tipoConstrucao = tipoConstrucao;
        this.area = area;
        this.areaProjeto = areaProjeto;
        this.tributosGeradas = tributosGeradas;
    }

    @Generated
    public ProjetoItemGeraDebitoDTO() {
    }
}

