/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.projeto;

import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.projeto.CalculoProjetoAggregateKey;
import br.com.elotech.tributos.dto.projeto.CalculoProjetoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoProjetoDTO {
    private Long id;
    private Long exercicio;
    private DividaDTO divida;
    private TributoDTO tributo;
    private Long projetoItem;
    private boolean geraDebito;
    private Utilizacao utilizacao;
    private TipoCalculoConfig tipoCalculoConfig;

    @JsonIgnore
    public String getSiglaTributo() {
        return this.tributo.getTributo();
    }

    public static CalculoProjetoDTO from(CalculoProjeto calculoProjeto) {
        return CalculoProjetoDTO.builder().id(calculoProjeto.getId()).exercicio(calculoProjeto.getExercicio()).divida(DividaDTO.of((Divida)calculoProjeto.getDivida())).tributo(TributoDTO.from((Tributo)calculoProjeto.getTributo())).tipoCalculoConfig(calculoProjeto.getTipo()).build();
    }

    public CalculoProjetoAggregateKey buildKeyItem() {
        CalculoProjetoAggregateKey key = new CalculoProjetoAggregateKey();
        key.setProjetoItem(this.projetoItem);
        key.setDivida(this.divida.getDivida());
        return key;
    }

    public CalculoProjetoAggregateKey buildKeyUtilizacao() {
        CalculoProjetoAggregateKey key = new CalculoProjetoAggregateKey();
        key.setDivida(this.divida.getDivida());
        Optional.ofNullable(this.utilizacao).ifPresent(arg_0 -> ((CalculoProjetoAggregateKey)key).setUtilizacao(arg_0));
        return key;
    }

    public CalculoProjetoAggregateKey buildKeyProjeto() {
        CalculoProjetoAggregateKey key = new CalculoProjetoAggregateKey();
        key.setDivida(this.divida.getDivida());
        return key;
    }

    @Generated
    public static CalculoProjetoDTOBuilder builder() {
        return new CalculoProjetoDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public DividaDTO getDivida() {
        return this.divida;
    }

    @Generated
    public TributoDTO getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getProjetoItem() {
        return this.projetoItem;
    }

    @Generated
    public boolean isGeraDebito() {
        return this.geraDebito;
    }

    @Generated
    public Utilizacao getUtilizacao() {
        return this.utilizacao;
    }

    @Generated
    public TipoCalculoConfig getTipoCalculoConfig() {
        return this.tipoCalculoConfig;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(DividaDTO divida) {
        this.divida = divida;
    }

    @Generated
    public void setTributo(TributoDTO tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setProjetoItem(Long projetoItem) {
        this.projetoItem = projetoItem;
    }

    @Generated
    public void setGeraDebito(boolean geraDebito) {
        this.geraDebito = geraDebito;
    }

    @Generated
    public void setUtilizacao(Utilizacao utilizacao) {
        this.utilizacao = utilizacao;
    }

    @Generated
    public void setTipoCalculoConfig(TipoCalculoConfig tipoCalculoConfig) {
        this.tipoCalculoConfig = tipoCalculoConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoProjetoDTO)) {
            return false;
        }
        CalculoProjetoDTO other = (CalculoProjetoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGeraDebito() != other.isGeraDebito()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$projetoItem = this.getProjetoItem();
        Long other$projetoItem = other.getProjetoItem();
        if (this$projetoItem == null ? other$projetoItem != null : !((Object)this$projetoItem).equals(other$projetoItem)) {
            return false;
        }
        DividaDTO this$divida = this.getDivida();
        DividaDTO other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        TributoDTO this$tributo = this.getTributo();
        TributoDTO other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        Utilizacao this$utilizacao = this.getUtilizacao();
        Utilizacao other$utilizacao = other.getUtilizacao();
        if (this$utilizacao == null ? other$utilizacao != null : !this$utilizacao.equals(other$utilizacao)) {
            return false;
        }
        TipoCalculoConfig this$tipoCalculoConfig = this.getTipoCalculoConfig();
        TipoCalculoConfig other$tipoCalculoConfig = other.getTipoCalculoConfig();
        return !(this$tipoCalculoConfig == null ? other$tipoCalculoConfig != null : !this$tipoCalculoConfig.equals(other$tipoCalculoConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoProjetoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGeraDebito() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $projetoItem = this.getProjetoItem();
        result = result * 59 + ($projetoItem == null ? 43 : ((Object)$projetoItem).hashCode());
        DividaDTO $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        TributoDTO $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        Utilizacao $utilizacao = this.getUtilizacao();
        result = result * 59 + ($utilizacao == null ? 43 : $utilizacao.hashCode());
        TipoCalculoConfig $tipoCalculoConfig = this.getTipoCalculoConfig();
        result = result * 59 + ($tipoCalculoConfig == null ? 43 : $tipoCalculoConfig.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoProjetoDTO(id=" + this.getId() + ", exercicio=" + this.getExercicio() + ", divida=" + String.valueOf(this.getDivida()) + ", tributo=" + String.valueOf(this.getTributo()) + ", projetoItem=" + this.getProjetoItem() + ", geraDebito=" + this.isGeraDebito() + ", utilizacao=" + String.valueOf(this.getUtilizacao()) + ", tipoCalculoConfig=" + String.valueOf(this.getTipoCalculoConfig()) + ")";
    }

    @Generated
    public CalculoProjetoDTO(Long id, Long exercicio, DividaDTO divida, TributoDTO tributo, Long projetoItem, boolean geraDebito, Utilizacao utilizacao, TipoCalculoConfig tipoCalculoConfig) {
        this.id = id;
        this.exercicio = exercicio;
        this.divida = divida;
        this.tributo = tributo;
        this.projetoItem = projetoItem;
        this.geraDebito = geraDebito;
        this.utilizacao = utilizacao;
        this.tipoCalculoConfig = tipoCalculoConfig;
    }

    @Generated
    public CalculoProjetoDTO() {
    }
}

