/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.parcelamento.EstornoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.pagamento.EstornoParcelamentoDebitoParcelaPagoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoParcelamentoDebitoReceitaEmAbertoDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class TermoRecisaoParcelamentoDTO
implements DatasetRecord {
    private Long idParcelamento;
    private Long entidade;
    private Long cadastroGeral;
    private Long tipoCadastro;
    private Long anoParcelamento;
    private Long numeroParcelamento;
    private LocalDate dataParcelamento;
    private LocalDate dataInclusaoParcelamento;
    private String usuarioParcelamento;
    private String tipoParcelamento;
    private Long idParametroParcelamento;
    private Long idRequerenteParcelamento;
    private String nomeRequerenteParcelamento;
    private String situacaoParcelamento;
    private Boolean porContribuinte;
    private Long contribuinte;
    private String nomeContribuinte;
    private Long idEstornoParcelamento;
    private LocalDate dataEstorno;
    private String motivoEstorno;
    private String usuarioEstorno;
    private Boolean estornado;
    private List<EstornoParcelamentoDebitoParcelaPagoDTO> parcelasPagas = new ArrayList();
    private List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> receitasPendentes = new ArrayList();

    public TermoRecisaoParcelamentoDTO(Parcelamento parcelamento, EstornoParcelamento estornoParcelamento, List<EstornoParcelamentoDebitoParcelaPagoDTO> parcelasPagas, List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> receitasPendentes) {
        this.idParcelamento = parcelamento.getId();
        this.entidade = parcelamento.getEntidade();
        this.cadastroGeral = Optional.ofNullable(parcelamento.getCadastroGeral()).map(CadastroGeral::getCadastroGeral).orElse(null);
        this.tipoCadastro = Optional.ofNullable(parcelamento.getCadastroGeral()).map(CadastroGeral::getTipoCadastro).map(TipoCadastro::getValue).orElse(null);
        this.anoParcelamento = parcelamento.getAnoContrato();
        this.numeroParcelamento = parcelamento.getNumeroContrato();
        this.dataParcelamento = parcelamento.getDataParcelamento();
        this.dataInclusaoParcelamento = parcelamento.getDataInclusao();
        this.usuarioParcelamento = parcelamento.getUsuario();
        this.tipoParcelamento = parcelamento.getTipo().getDescricao();
        this.idParametroParcelamento = parcelamento.getIdParametroParcelamento();
        this.idRequerenteParcelamento = Optional.ofNullable(parcelamento.getRequerente()).map(Pessoa::getId).orElse(null);
        this.nomeRequerenteParcelamento = Optional.ofNullable(parcelamento.getRequerente()).map(Pessoa::getNome).orElse(null);
        this.situacaoParcelamento = parcelamento.getSituacao().getDescricao();
        this.porContribuinte = Boolean.TRUE.equals(parcelamento.getPorContribuinte());
        this.contribuinte = Optional.ofNullable(parcelamento.getPessoa()).orElse(parcelamento.getCadastroGeral().getPessoa()).getId();
        this.nomeContribuinte = Optional.ofNullable(parcelamento.getPessoa()).orElse(parcelamento.getCadastroGeral().getPessoa()).getNome();
        this.idEstornoParcelamento = estornoParcelamento.getId();
        this.dataEstorno = estornoParcelamento.getDataEstorno();
        this.motivoEstorno = estornoParcelamento.getMotivo();
        this.usuarioEstorno = estornoParcelamento.getUsuario();
        this.estornado = Boolean.TRUE.equals(estornoParcelamento.getEstornado());
        this.parcelasPagas = parcelasPagas;
        this.receitasPendentes = receitasPendentes;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getAnoParcelamento() {
        return this.anoParcelamento;
    }

    @Generated
    public Long getNumeroParcelamento() {
        return this.numeroParcelamento;
    }

    @Generated
    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    @Generated
    public LocalDate getDataInclusaoParcelamento() {
        return this.dataInclusaoParcelamento;
    }

    @Generated
    public String getUsuarioParcelamento() {
        return this.usuarioParcelamento;
    }

    @Generated
    public String getTipoParcelamento() {
        return this.tipoParcelamento;
    }

    @Generated
    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    @Generated
    public Long getIdRequerenteParcelamento() {
        return this.idRequerenteParcelamento;
    }

    @Generated
    public String getNomeRequerenteParcelamento() {
        return this.nomeRequerenteParcelamento;
    }

    @Generated
    public String getSituacaoParcelamento() {
        return this.situacaoParcelamento;
    }

    @Generated
    public Boolean getPorContribuinte() {
        return this.porContribuinte;
    }

    @Generated
    public Long getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public String getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    @Generated
    public Long getIdEstornoParcelamento() {
        return this.idEstornoParcelamento;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public String getMotivoEstorno() {
        return this.motivoEstorno;
    }

    @Generated
    public String getUsuarioEstorno() {
        return this.usuarioEstorno;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public List<EstornoParcelamentoDebitoParcelaPagoDTO> getParcelasPagas() {
        return this.parcelasPagas;
    }

    @Generated
    public List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> getReceitasPendentes() {
        return this.receitasPendentes;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setAnoParcelamento(Long anoParcelamento) {
        this.anoParcelamento = anoParcelamento;
    }

    @Generated
    public void setNumeroParcelamento(Long numeroParcelamento) {
        this.numeroParcelamento = numeroParcelamento;
    }

    @Generated
    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    @Generated
    public void setDataInclusaoParcelamento(LocalDate dataInclusaoParcelamento) {
        this.dataInclusaoParcelamento = dataInclusaoParcelamento;
    }

    @Generated
    public void setUsuarioParcelamento(String usuarioParcelamento) {
        this.usuarioParcelamento = usuarioParcelamento;
    }

    @Generated
    public void setTipoParcelamento(String tipoParcelamento) {
        this.tipoParcelamento = tipoParcelamento;
    }

    @Generated
    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    @Generated
    public void setIdRequerenteParcelamento(Long idRequerenteParcelamento) {
        this.idRequerenteParcelamento = idRequerenteParcelamento;
    }

    @Generated
    public void setNomeRequerenteParcelamento(String nomeRequerenteParcelamento) {
        this.nomeRequerenteParcelamento = nomeRequerenteParcelamento;
    }

    @Generated
    public void setSituacaoParcelamento(String situacaoParcelamento) {
        this.situacaoParcelamento = situacaoParcelamento;
    }

    @Generated
    public void setPorContribuinte(Boolean porContribuinte) {
        this.porContribuinte = porContribuinte;
    }

    @Generated
    public void setContribuinte(Long contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setNomeContribuinte(String nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    @Generated
    public void setIdEstornoParcelamento(Long idEstornoParcelamento) {
        this.idEstornoParcelamento = idEstornoParcelamento;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setMotivoEstorno(String motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    @Generated
    public void setUsuarioEstorno(String usuarioEstorno) {
        this.usuarioEstorno = usuarioEstorno;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setParcelasPagas(List<EstornoParcelamentoDebitoParcelaPagoDTO> parcelasPagas) {
        this.parcelasPagas = parcelasPagas;
    }

    @Generated
    public void setReceitasPendentes(List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> receitasPendentes) {
        this.receitasPendentes = receitasPendentes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TermoRecisaoParcelamentoDTO)) {
            return false;
        }
        TermoRecisaoParcelamentoDTO other = (TermoRecisaoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$anoParcelamento = this.getAnoParcelamento();
        Long other$anoParcelamento = other.getAnoParcelamento();
        if (this$anoParcelamento == null ? other$anoParcelamento != null : !((Object)this$anoParcelamento).equals(other$anoParcelamento)) {
            return false;
        }
        Long this$numeroParcelamento = this.getNumeroParcelamento();
        Long other$numeroParcelamento = other.getNumeroParcelamento();
        if (this$numeroParcelamento == null ? other$numeroParcelamento != null : !((Object)this$numeroParcelamento).equals(other$numeroParcelamento)) {
            return false;
        }
        Long this$idParametroParcelamento = this.getIdParametroParcelamento();
        Long other$idParametroParcelamento = other.getIdParametroParcelamento();
        if (this$idParametroParcelamento == null ? other$idParametroParcelamento != null : !((Object)this$idParametroParcelamento).equals(other$idParametroParcelamento)) {
            return false;
        }
        Long this$idRequerenteParcelamento = this.getIdRequerenteParcelamento();
        Long other$idRequerenteParcelamento = other.getIdRequerenteParcelamento();
        if (this$idRequerenteParcelamento == null ? other$idRequerenteParcelamento != null : !((Object)this$idRequerenteParcelamento).equals(other$idRequerenteParcelamento)) {
            return false;
        }
        Boolean this$porContribuinte = this.getPorContribuinte();
        Boolean other$porContribuinte = other.getPorContribuinte();
        if (this$porContribuinte == null ? other$porContribuinte != null : !((Object)this$porContribuinte).equals(other$porContribuinte)) {
            return false;
        }
        Long this$contribuinte = this.getContribuinte();
        Long other$contribuinte = other.getContribuinte();
        if (this$contribuinte == null ? other$contribuinte != null : !((Object)this$contribuinte).equals(other$contribuinte)) {
            return false;
        }
        Long this$idEstornoParcelamento = this.getIdEstornoParcelamento();
        Long other$idEstornoParcelamento = other.getIdEstornoParcelamento();
        if (this$idEstornoParcelamento == null ? other$idEstornoParcelamento != null : !((Object)this$idEstornoParcelamento).equals(other$idEstornoParcelamento)) {
            return false;
        }
        Boolean this$estornado = this.getEstornado();
        Boolean other$estornado = other.getEstornado();
        if (this$estornado == null ? other$estornado != null : !((Object)this$estornado).equals(other$estornado)) {
            return false;
        }
        LocalDate this$dataParcelamento = this.getDataParcelamento();
        LocalDate other$dataParcelamento = other.getDataParcelamento();
        if (this$dataParcelamento == null ? other$dataParcelamento != null : !((Object)this$dataParcelamento).equals(other$dataParcelamento)) {
            return false;
        }
        LocalDate this$dataInclusaoParcelamento = this.getDataInclusaoParcelamento();
        LocalDate other$dataInclusaoParcelamento = other.getDataInclusaoParcelamento();
        if (this$dataInclusaoParcelamento == null ? other$dataInclusaoParcelamento != null : !((Object)this$dataInclusaoParcelamento).equals(other$dataInclusaoParcelamento)) {
            return false;
        }
        String this$usuarioParcelamento = this.getUsuarioParcelamento();
        String other$usuarioParcelamento = other.getUsuarioParcelamento();
        if (this$usuarioParcelamento == null ? other$usuarioParcelamento != null : !this$usuarioParcelamento.equals(other$usuarioParcelamento)) {
            return false;
        }
        String this$tipoParcelamento = this.getTipoParcelamento();
        String other$tipoParcelamento = other.getTipoParcelamento();
        if (this$tipoParcelamento == null ? other$tipoParcelamento != null : !this$tipoParcelamento.equals(other$tipoParcelamento)) {
            return false;
        }
        String this$nomeRequerenteParcelamento = this.getNomeRequerenteParcelamento();
        String other$nomeRequerenteParcelamento = other.getNomeRequerenteParcelamento();
        if (this$nomeRequerenteParcelamento == null ? other$nomeRequerenteParcelamento != null : !this$nomeRequerenteParcelamento.equals(other$nomeRequerenteParcelamento)) {
            return false;
        }
        String this$situacaoParcelamento = this.getSituacaoParcelamento();
        String other$situacaoParcelamento = other.getSituacaoParcelamento();
        if (this$situacaoParcelamento == null ? other$situacaoParcelamento != null : !this$situacaoParcelamento.equals(other$situacaoParcelamento)) {
            return false;
        }
        String this$nomeContribuinte = this.getNomeContribuinte();
        String other$nomeContribuinte = other.getNomeContribuinte();
        if (this$nomeContribuinte == null ? other$nomeContribuinte != null : !this$nomeContribuinte.equals(other$nomeContribuinte)) {
            return false;
        }
        LocalDate this$dataEstorno = this.getDataEstorno();
        LocalDate other$dataEstorno = other.getDataEstorno();
        if (this$dataEstorno == null ? other$dataEstorno != null : !((Object)this$dataEstorno).equals(other$dataEstorno)) {
            return false;
        }
        String this$motivoEstorno = this.getMotivoEstorno();
        String other$motivoEstorno = other.getMotivoEstorno();
        if (this$motivoEstorno == null ? other$motivoEstorno != null : !this$motivoEstorno.equals(other$motivoEstorno)) {
            return false;
        }
        String this$usuarioEstorno = this.getUsuarioEstorno();
        String other$usuarioEstorno = other.getUsuarioEstorno();
        if (this$usuarioEstorno == null ? other$usuarioEstorno != null : !this$usuarioEstorno.equals(other$usuarioEstorno)) {
            return false;
        }
        List this$parcelasPagas = this.getParcelasPagas();
        List other$parcelasPagas = other.getParcelasPagas();
        if (this$parcelasPagas == null ? other$parcelasPagas != null : !((Object)this$parcelasPagas).equals(other$parcelasPagas)) {
            return false;
        }
        List this$receitasPendentes = this.getReceitasPendentes();
        List other$receitasPendentes = other.getReceitasPendentes();
        return !(this$receitasPendentes == null ? other$receitasPendentes != null : !((Object)this$receitasPendentes).equals(other$receitasPendentes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TermoRecisaoParcelamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $anoParcelamento = this.getAnoParcelamento();
        result = result * 59 + ($anoParcelamento == null ? 43 : ((Object)$anoParcelamento).hashCode());
        Long $numeroParcelamento = this.getNumeroParcelamento();
        result = result * 59 + ($numeroParcelamento == null ? 43 : ((Object)$numeroParcelamento).hashCode());
        Long $idParametroParcelamento = this.getIdParametroParcelamento();
        result = result * 59 + ($idParametroParcelamento == null ? 43 : ((Object)$idParametroParcelamento).hashCode());
        Long $idRequerenteParcelamento = this.getIdRequerenteParcelamento();
        result = result * 59 + ($idRequerenteParcelamento == null ? 43 : ((Object)$idRequerenteParcelamento).hashCode());
        Boolean $porContribuinte = this.getPorContribuinte();
        result = result * 59 + ($porContribuinte == null ? 43 : ((Object)$porContribuinte).hashCode());
        Long $contribuinte = this.getContribuinte();
        result = result * 59 + ($contribuinte == null ? 43 : ((Object)$contribuinte).hashCode());
        Long $idEstornoParcelamento = this.getIdEstornoParcelamento();
        result = result * 59 + ($idEstornoParcelamento == null ? 43 : ((Object)$idEstornoParcelamento).hashCode());
        Boolean $estornado = this.getEstornado();
        result = result * 59 + ($estornado == null ? 43 : ((Object)$estornado).hashCode());
        LocalDate $dataParcelamento = this.getDataParcelamento();
        result = result * 59 + ($dataParcelamento == null ? 43 : ((Object)$dataParcelamento).hashCode());
        LocalDate $dataInclusaoParcelamento = this.getDataInclusaoParcelamento();
        result = result * 59 + ($dataInclusaoParcelamento == null ? 43 : ((Object)$dataInclusaoParcelamento).hashCode());
        String $usuarioParcelamento = this.getUsuarioParcelamento();
        result = result * 59 + ($usuarioParcelamento == null ? 43 : $usuarioParcelamento.hashCode());
        String $tipoParcelamento = this.getTipoParcelamento();
        result = result * 59 + ($tipoParcelamento == null ? 43 : $tipoParcelamento.hashCode());
        String $nomeRequerenteParcelamento = this.getNomeRequerenteParcelamento();
        result = result * 59 + ($nomeRequerenteParcelamento == null ? 43 : $nomeRequerenteParcelamento.hashCode());
        String $situacaoParcelamento = this.getSituacaoParcelamento();
        result = result * 59 + ($situacaoParcelamento == null ? 43 : $situacaoParcelamento.hashCode());
        String $nomeContribuinte = this.getNomeContribuinte();
        result = result * 59 + ($nomeContribuinte == null ? 43 : $nomeContribuinte.hashCode());
        LocalDate $dataEstorno = this.getDataEstorno();
        result = result * 59 + ($dataEstorno == null ? 43 : ((Object)$dataEstorno).hashCode());
        String $motivoEstorno = this.getMotivoEstorno();
        result = result * 59 + ($motivoEstorno == null ? 43 : $motivoEstorno.hashCode());
        String $usuarioEstorno = this.getUsuarioEstorno();
        result = result * 59 + ($usuarioEstorno == null ? 43 : $usuarioEstorno.hashCode());
        List $parcelasPagas = this.getParcelasPagas();
        result = result * 59 + ($parcelasPagas == null ? 43 : ((Object)$parcelasPagas).hashCode());
        List $receitasPendentes = this.getReceitasPendentes();
        result = result * 59 + ($receitasPendentes == null ? 43 : ((Object)$receitasPendentes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TermoRecisaoParcelamentoDTO(idParcelamento=" + this.getIdParcelamento() + ", entidade=" + this.getEntidade() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipoCadastro=" + this.getTipoCadastro() + ", anoParcelamento=" + this.getAnoParcelamento() + ", numeroParcelamento=" + this.getNumeroParcelamento() + ", dataParcelamento=" + String.valueOf(this.getDataParcelamento()) + ", dataInclusaoParcelamento=" + String.valueOf(this.getDataInclusaoParcelamento()) + ", usuarioParcelamento=" + this.getUsuarioParcelamento() + ", tipoParcelamento=" + this.getTipoParcelamento() + ", idParametroParcelamento=" + this.getIdParametroParcelamento() + ", idRequerenteParcelamento=" + this.getIdRequerenteParcelamento() + ", nomeRequerenteParcelamento=" + this.getNomeRequerenteParcelamento() + ", situacaoParcelamento=" + this.getSituacaoParcelamento() + ", porContribuinte=" + this.getPorContribuinte() + ", contribuinte=" + this.getContribuinte() + ", nomeContribuinte=" + this.getNomeContribuinte() + ", idEstornoParcelamento=" + this.getIdEstornoParcelamento() + ", dataEstorno=" + String.valueOf(this.getDataEstorno()) + ", motivoEstorno=" + this.getMotivoEstorno() + ", usuarioEstorno=" + this.getUsuarioEstorno() + ", estornado=" + this.getEstornado() + ", parcelasPagas=" + String.valueOf(this.getParcelasPagas()) + ", receitasPendentes=" + String.valueOf(this.getReceitasPendentes()) + ")";
    }

    @Generated
    public TermoRecisaoParcelamentoDTO() {
    }
}

