/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelaReceitaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoTributoDTO;
import br.com.elotech.tributos.dto.parcelamento.TributoParcelamentoDTO;
import java.math.BigDecimal;
import lombok.Generated;

public class ParcelamentoTributoDTO {
    private String receita;
    private String descricaoReceita;
    private ClassificacaoTributo classificacaoTributo;
    private BigDecimal valor;
    private BigDecimal valorJuros;
    private BigDecimal valorMulta;
    private BigDecimal valorCorrecao;
    private BigDecimal valorDesconto;
    private BigDecimal valorAVista = BigDecimal.ZERO;

    public ParcelamentoTributoDTO(Builder builder) {
        this.receita = builder.receita;
        this.descricaoReceita = builder.descricaoReceita;
        this.valor = builder.valor;
        this.valorJuros = builder.valorJuros;
        this.valorMulta = builder.valorMulta;
        this.valorCorrecao = builder.valorCorrecao;
        this.valorDesconto = builder.valorDesconto;
    }

    public static ParcelamentoTributoDTO from(AiseParcelaReceitaParcelamentoDTO aiseParcelaReceita) {
        ParcelamentoTributoDTO parcelamentoReceitaDTO = new ParcelamentoTributoDTO();
        parcelamentoReceitaDTO.setReceita(aiseParcelaReceita.getReceita());
        parcelamentoReceitaDTO.setDescricaoReceita(aiseParcelaReceita.getReceitaDescricao());
        parcelamentoReceitaDTO.setValor(aiseParcelaReceita.getValor());
        parcelamentoReceitaDTO.setValorJuros(aiseParcelaReceita.getValorJuros());
        parcelamentoReceitaDTO.setValorMulta(aiseParcelaReceita.getValorMulta());
        parcelamentoReceitaDTO.setValorCorrecao(aiseParcelaReceita.getValorCorrecao());
        parcelamentoReceitaDTO.setValorDesconto(aiseParcelaReceita.getValorDesconto());
        parcelamentoReceitaDTO.setValorAVista(aiseParcelaReceita.getValorAVista());
        parcelamentoReceitaDTO.setClassificacaoTributo(ClassificacaoTributo.fromValue((String)aiseParcelaReceita.getClassificacaoTributo()));
        return parcelamentoReceitaDTO;
    }

    public static ParcelamentoTributoDTO from(TributoParcelamentoDTO aiseReceita) {
        ParcelamentoTributoDTO parcelamentoTributoDTO = new ParcelamentoTributoDTO();
        parcelamentoTributoDTO.setReceita(aiseReceita.getTributo());
        parcelamentoTributoDTO.setDescricaoReceita(aiseReceita.getTributoDescricao());
        parcelamentoTributoDTO.setValor(aiseReceita.getValor());
        parcelamentoTributoDTO.setValorCorrecao(aiseReceita.getValorCorrecao());
        parcelamentoTributoDTO.setValorDesconto(aiseReceita.getValorDesconto());
        parcelamentoTributoDTO.setValorJuros(aiseReceita.getValorJuros());
        parcelamentoTributoDTO.setValorMulta(aiseReceita.getValorMulta());
        return parcelamentoTributoDTO;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public String getDescricaoReceita() {
        return this.descricaoReceita;
    }

    @Generated
    public ClassificacaoTributo getClassificacaoTributo() {
        return this.classificacaoTributo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorAVista() {
        return this.valorAVista;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setDescricaoReceita(String descricaoReceita) {
        this.descricaoReceita = descricaoReceita;
    }

    @Generated
    public void setClassificacaoTributo(ClassificacaoTributo classificacaoTributo) {
        this.classificacaoTributo = classificacaoTributo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorAVista(BigDecimal valorAVista) {
        this.valorAVista = valorAVista;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParcelamentoTributoDTO)) {
            return false;
        }
        ParcelamentoTributoDTO other = (ParcelamentoTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !this$receita.equals(other$receita)) {
            return false;
        }
        String this$descricaoReceita = this.getDescricaoReceita();
        String other$descricaoReceita = other.getDescricaoReceita();
        if (this$descricaoReceita == null ? other$descricaoReceita != null : !this$descricaoReceita.equals(other$descricaoReceita)) {
            return false;
        }
        ClassificacaoTributo this$classificacaoTributo = this.getClassificacaoTributo();
        ClassificacaoTributo other$classificacaoTributo = other.getClassificacaoTributo();
        if (this$classificacaoTributo == null ? other$classificacaoTributo != null : !this$classificacaoTributo.equals(other$classificacaoTributo)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorAVista = this.getValorAVista();
        BigDecimal other$valorAVista = other.getValorAVista();
        return !(this$valorAVista == null ? other$valorAVista != null : !((Object)this$valorAVista).equals(other$valorAVista));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParcelamentoTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        String $descricaoReceita = this.getDescricaoReceita();
        result = result * 59 + ($descricaoReceita == null ? 43 : $descricaoReceita.hashCode());
        ClassificacaoTributo $classificacaoTributo = this.getClassificacaoTributo();
        result = result * 59 + ($classificacaoTributo == null ? 43 : $classificacaoTributo.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorAVista = this.getValorAVista();
        result = result * 59 + ($valorAVista == null ? 43 : ((Object)$valorAVista).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParcelamentoTributoDTO(receita=" + this.getReceita() + ", descricaoReceita=" + this.getDescricaoReceita() + ", classificacaoTributo=" + String.valueOf(this.getClassificacaoTributo()) + ", valor=" + String.valueOf(this.getValor()) + ", valorJuros=" + String.valueOf(this.getValorJuros()) + ", valorMulta=" + String.valueOf(this.getValorMulta()) + ", valorCorrecao=" + String.valueOf(this.getValorCorrecao()) + ", valorDesconto=" + String.valueOf(this.getValorDesconto()) + ", valorAVista=" + String.valueOf(this.getValorAVista()) + ")";
    }

    @Generated
    public ParcelamentoTributoDTO() {
    }
}

