/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jsonwebtoken.lang.Assert;
import java.time.LocalDate;
import lombok.Generated;

public class ParcelamentoPassivelQuitacaoDTO {
    @JsonProperty(value="tipocadastro")
    private Long tipoCadastro;
    @JsonProperty(value="cadastrogeral")
    private Long cadastroGeral;
    @JsonProperty(value="numerocontrato")
    private Long numeroContrato;
    @JsonProperty(value="anocontrato")
    private Integer anoContrato;
    @JsonProperty(value="datacontrato")
    private LocalDate dataContrato;
    @JsonProperty(value="idparcelamento")
    private Long idParcelamento;
    @JsonProperty(value="idparametroparcelamento")
    private Long idParametroParcelamento;
    @JsonProperty(value="parcelaspagas")
    private Integer parcelasPagas;
    @JsonProperty(value="parcelasabertas")
    private Integer parcelasAbertas;
    @JsonProperty(value="tipojurosfinanciamento")
    private Long tipoJurosFinanciamento;
    @JsonProperty(value="descricao")
    private String descricao;
    @JsonProperty(value="contribuinte")
    private Long contribuinte;
    @JsonProperty(value="porcontribuinte")
    private Boolean porContribuinte;

    public static ParcelamentoPassivelQuitacaoDTO of(Parcelamento parcelamento, ParamParcelamento paramParcelamento, Integer parcelasEmAberto, Integer parcelasPagas) {
        boolean isPorContribuinte = Boolean.TRUE.equals(parcelamento.getPorContribuinte());
        if (!isPorContribuinte) {
            Assert.notNull((Object)parcelamento.getCadastroGeral().getTipoCadastro(), (String)"Erro ao fazer convers\u00e3o de dados: Tipo Cadastro est\u00e1 nulo.");
            Assert.notNull((Object)parcelamento.getCadastroGeral().getCadastroGeral(), (String)"Erro ao fazer convers\u00e3o de dados: Cadastro Geral est\u00e1 nulo.");
        }
        if (isPorContribuinte) {
            Assert.notNull((Object)parcelamento.getPessoa().getId(), (String)"Erro ao fazer convers\u00e3o de dados: Pessoa contribuinte est\u00e1 nulo.");
        }
        Assert.notNull((Object)parcelamento.getNumeroContrato(), (String)"Erro ao fazer convers\u00e3o de dados: N\u00famero do Contrato de Parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getAnoContrato(), (String)"Erro ao fazer convers\u00e3o de dados: Ano Contrato est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getDataParcelamento(), (String)"Erro ao fazer convers\u00e3o de dados: Data Parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getId(), (String)"Erro ao fazer convers\u00e3o de dados: Id do Parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getIdParametroParcelamento(), (String)"Erro ao fazer convers\u00e3o de dados: Id do Par\u00e2metro do Parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)parcelasPagas, (String)"Erro ao fazer convers\u00e3o de dados: N\u00e3o h\u00e1 parcelas pagas.");
        Assert.notNull((Object)parcelasEmAberto, (String)"Erro ao fazer convers\u00e3o de dados: N\u00e3o h\u00e1 parcelas em aberto.");
        Assert.notNull((Object)paramParcelamento.getDescricao(), (String)"Erro ao fazer convers\u00e3o de dados: Descri\u00e7\u00e3o do Par\u00e2metro est\u00e1 nulo.");
        Assert.notNull((Object)paramParcelamento.getTipoJurosFinanciamento(), (String)"Erro ao fazer convers\u00e3o de dados: Tipo Juros Financiamento est\u00e1 nulo.");
        ParcelamentoPassivelQuitacaoDTO dto = new ParcelamentoPassivelQuitacaoDTO();
        dto.setTipoCadastro(isPorContribuinte ? null : parcelamento.getCadastroGeral().getTipoCadastro().getValue());
        dto.setCadastroGeral(isPorContribuinte ? null : parcelamento.getCadastroGeral().getCadastroGeral());
        dto.setContribuinte(isPorContribuinte ? parcelamento.getPessoa().getId() : null);
        dto.setPorContribuinte(Boolean.valueOf(isPorContribuinte));
        dto.setNumeroContrato(parcelamento.getNumeroContrato());
        dto.setAnoContrato(Integer.valueOf(parcelamento.getAnoContrato().intValue()));
        dto.setDataContrato(parcelamento.getDataParcelamento());
        dto.setIdParcelamento(parcelamento.getId());
        dto.setIdParametroParcelamento(parcelamento.getIdParametroParcelamento());
        dto.setParcelasPagas(parcelasPagas);
        dto.setParcelasAbertas(parcelasEmAberto);
        dto.setTipoJurosFinanciamento(paramParcelamento.getTipoJurosFinanciamento().getValue());
        dto.setDescricao(paramParcelamento.getDescricao());
        return dto;
    }

    public static ParcelamentoPassivelQuitacaoDTO of(Long idParcelamento) {
        ParcelamentoPassivelQuitacaoDTO dto = new ParcelamentoPassivelQuitacaoDTO();
        dto.setIdParcelamento(idParcelamento);
        return dto;
    }

    @Generated
    public ParcelamentoPassivelQuitacaoDTO() {
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public LocalDate getDataContrato() {
        return this.dataContrato;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    @Generated
    public Integer getParcelasPagas() {
        return this.parcelasPagas;
    }

    @Generated
    public Integer getParcelasAbertas() {
        return this.parcelasAbertas;
    }

    @Generated
    public Long getTipoJurosFinanciamento() {
        return this.tipoJurosFinanciamento;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public Boolean getPorContribuinte() {
        return this.porContribuinte;
    }

    @JsonProperty(value="tipocadastro")
    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @JsonProperty(value="cadastrogeral")
    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonProperty(value="numerocontrato")
    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @JsonProperty(value="anocontrato")
    @Generated
    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = anoContrato;
    }

    @JsonProperty(value="datacontrato")
    @Generated
    public void setDataContrato(LocalDate dataContrato) {
        this.dataContrato = dataContrato;
    }

    @JsonProperty(value="idparcelamento")
    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @JsonProperty(value="idparametroparcelamento")
    @Generated
    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    @JsonProperty(value="parcelaspagas")
    @Generated
    public void setParcelasPagas(Integer parcelasPagas) {
        this.parcelasPagas = parcelasPagas;
    }

    @JsonProperty(value="parcelasabertas")
    @Generated
    public void setParcelasAbertas(Integer parcelasAbertas) {
        this.parcelasAbertas = parcelasAbertas;
    }

    @JsonProperty(value="tipojurosfinanciamento")
    @Generated
    public void setTipoJurosFinanciamento(Long tipoJurosFinanciamento) {
        this.tipoJurosFinanciamento = tipoJurosFinanciamento;
    }

    @JsonProperty(value="descricao")
    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JsonProperty(value="contribuinte")
    @Generated
    public void setContribuinte(Long contribuinte) {
        this.contribuinte = contribuinte;
    }

    @JsonProperty(value="porcontribuinte")
    @Generated
    public void setPorContribuinte(Boolean porContribuinte) {
        this.porContribuinte = porContribuinte;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParcelamentoPassivelQuitacaoDTO)) {
            return false;
        }
        ParcelamentoPassivelQuitacaoDTO other = (ParcelamentoPassivelQuitacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Long this$idParametroParcelamento = this.getIdParametroParcelamento();
        Long other$idParametroParcelamento = other.getIdParametroParcelamento();
        if (this$idParametroParcelamento == null ? other$idParametroParcelamento != null : !((Object)this$idParametroParcelamento).equals(other$idParametroParcelamento)) {
            return false;
        }
        Integer this$parcelasPagas = this.getParcelasPagas();
        Integer other$parcelasPagas = other.getParcelasPagas();
        if (this$parcelasPagas == null ? other$parcelasPagas != null : !((Object)this$parcelasPagas).equals(other$parcelasPagas)) {
            return false;
        }
        Integer this$parcelasAbertas = this.getParcelasAbertas();
        Integer other$parcelasAbertas = other.getParcelasAbertas();
        if (this$parcelasAbertas == null ? other$parcelasAbertas != null : !((Object)this$parcelasAbertas).equals(other$parcelasAbertas)) {
            return false;
        }
        Long this$tipoJurosFinanciamento = this.getTipoJurosFinanciamento();
        Long other$tipoJurosFinanciamento = other.getTipoJurosFinanciamento();
        if (this$tipoJurosFinanciamento == null ? other$tipoJurosFinanciamento != null : !((Object)this$tipoJurosFinanciamento).equals(other$tipoJurosFinanciamento)) {
            return false;
        }
        Long this$contribuinte = this.getContribuinte();
        Long other$contribuinte = other.getContribuinte();
        if (this$contribuinte == null ? other$contribuinte != null : !((Object)this$contribuinte).equals(other$contribuinte)) {
            return false;
        }
        Boolean this$porContribuinte = this.getPorContribuinte();
        Boolean other$porContribuinte = other.getPorContribuinte();
        if (this$porContribuinte == null ? other$porContribuinte != null : !((Object)this$porContribuinte).equals(other$porContribuinte)) {
            return false;
        }
        LocalDate this$dataContrato = this.getDataContrato();
        LocalDate other$dataContrato = other.getDataContrato();
        if (this$dataContrato == null ? other$dataContrato != null : !((Object)this$dataContrato).equals(other$dataContrato)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        return !(this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParcelamentoPassivelQuitacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Long $idParametroParcelamento = this.getIdParametroParcelamento();
        result = result * 59 + ($idParametroParcelamento == null ? 43 : ((Object)$idParametroParcelamento).hashCode());
        Integer $parcelasPagas = this.getParcelasPagas();
        result = result * 59 + ($parcelasPagas == null ? 43 : ((Object)$parcelasPagas).hashCode());
        Integer $parcelasAbertas = this.getParcelasAbertas();
        result = result * 59 + ($parcelasAbertas == null ? 43 : ((Object)$parcelasAbertas).hashCode());
        Long $tipoJurosFinanciamento = this.getTipoJurosFinanciamento();
        result = result * 59 + ($tipoJurosFinanciamento == null ? 43 : ((Object)$tipoJurosFinanciamento).hashCode());
        Long $contribuinte = this.getContribuinte();
        result = result * 59 + ($contribuinte == null ? 43 : ((Object)$contribuinte).hashCode());
        Boolean $porContribuinte = this.getPorContribuinte();
        result = result * 59 + ($porContribuinte == null ? 43 : ((Object)$porContribuinte).hashCode());
        LocalDate $dataContrato = this.getDataContrato();
        result = result * 59 + ($dataContrato == null ? 43 : ((Object)$dataContrato).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParcelamentoPassivelQuitacaoDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ", dataContrato=" + String.valueOf(this.getDataContrato()) + ", idParcelamento=" + this.getIdParcelamento() + ", idParametroParcelamento=" + this.getIdParametroParcelamento() + ", parcelasPagas=" + this.getParcelasPagas() + ", parcelasAbertas=" + this.getParcelasAbertas() + ", tipoJurosFinanciamento=" + this.getTipoJurosFinanciamento() + ", descricao=" + this.getDescricao() + ", contribuinte=" + this.getContribuinte() + ", porContribuinte=" + this.getPorContribuinte() + ")";
    }
}

