/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamentocredito;

import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoMovimentacaoDTO;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoOrigemDTO;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class PagamentoCreditoDTO {
    private Long id;
    private OrigemCredito origem;
    private Long cadastroGeral;
    private Long tipoCadastro;
    private LocalDate dataOrigem;
    private BigDecimal saldoOriginal;
    private BigDecimal saldoDisponivel;
    private PagamentoCreditoOrigemDTO pagamentoOrigem;
    private List<PagamentoCreditoMovimentacaoDTO> movimentacoes;

    public static PagamentoCreditoDTO from(PagamentoCredito pagamentoCredito) {
        if (pagamentoCredito == null) {
            return null;
        }
        PagamentoCreditoDTO dto = new PagamentoCreditoDTO();
        dto.setId(pagamentoCredito.getId());
        dto.setOrigem(pagamentoCredito.getOrigem());
        dto.setCadastroGeral(pagamentoCredito.getCadastroGeral());
        dto.setTipoCadastro(pagamentoCredito.getTipoCadastro());
        dto.setDataOrigem(pagamentoCredito.getDataOrigem());
        dto.setSaldoOriginal(pagamentoCredito.getSaldoOriginal());
        dto.setSaldoDisponivel(pagamentoCredito.getSaldoDisponivel());
        dto.setPagamentoOrigem(PagamentoCreditoOrigemDTO.from((Pagamento)pagamentoCredito.getPagamentoOrigem()));
        dto.setMovimentacoes(pagamentoCredito.getMovimentacoes().stream().map(PagamentoCreditoMovimentacaoDTO::from).collect(Collectors.toList()));
        return dto;
    }

    @Generated
    public PagamentoCreditoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public OrigemCredito getOrigem() {
        return this.origem;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public LocalDate getDataOrigem() {
        return this.dataOrigem;
    }

    @Generated
    public BigDecimal getSaldoOriginal() {
        return this.saldoOriginal;
    }

    @Generated
    public BigDecimal getSaldoDisponivel() {
        return this.saldoDisponivel;
    }

    @Generated
    public PagamentoCreditoOrigemDTO getPagamentoOrigem() {
        return this.pagamentoOrigem;
    }

    @Generated
    public List<PagamentoCreditoMovimentacaoDTO> getMovimentacoes() {
        return this.movimentacoes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrigem(OrigemCredito origem) {
        this.origem = origem;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setDataOrigem(LocalDate dataOrigem) {
        this.dataOrigem = dataOrigem;
    }

    @Generated
    public void setSaldoOriginal(BigDecimal saldoOriginal) {
        this.saldoOriginal = saldoOriginal;
    }

    @Generated
    public void setSaldoDisponivel(BigDecimal saldoDisponivel) {
        this.saldoDisponivel = saldoDisponivel;
    }

    @Generated
    public void setPagamentoOrigem(PagamentoCreditoOrigemDTO pagamentoOrigem) {
        this.pagamentoOrigem = pagamentoOrigem;
    }

    @Generated
    public void setMovimentacoes(List<PagamentoCreditoMovimentacaoDTO> movimentacoes) {
        this.movimentacoes = movimentacoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoCreditoDTO)) {
            return false;
        }
        PagamentoCreditoDTO other = (PagamentoCreditoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        OrigemCredito this$origem = this.getOrigem();
        OrigemCredito other$origem = other.getOrigem();
        if (this$origem == null ? other$origem != null : !this$origem.equals(other$origem)) {
            return false;
        }
        LocalDate this$dataOrigem = this.getDataOrigem();
        LocalDate other$dataOrigem = other.getDataOrigem();
        if (this$dataOrigem == null ? other$dataOrigem != null : !((Object)this$dataOrigem).equals(other$dataOrigem)) {
            return false;
        }
        BigDecimal this$saldoOriginal = this.getSaldoOriginal();
        BigDecimal other$saldoOriginal = other.getSaldoOriginal();
        if (this$saldoOriginal == null ? other$saldoOriginal != null : !((Object)this$saldoOriginal).equals(other$saldoOriginal)) {
            return false;
        }
        BigDecimal this$saldoDisponivel = this.getSaldoDisponivel();
        BigDecimal other$saldoDisponivel = other.getSaldoDisponivel();
        if (this$saldoDisponivel == null ? other$saldoDisponivel != null : !((Object)this$saldoDisponivel).equals(other$saldoDisponivel)) {
            return false;
        }
        PagamentoCreditoOrigemDTO this$pagamentoOrigem = this.getPagamentoOrigem();
        PagamentoCreditoOrigemDTO other$pagamentoOrigem = other.getPagamentoOrigem();
        if (this$pagamentoOrigem == null ? other$pagamentoOrigem != null : !this$pagamentoOrigem.equals(other$pagamentoOrigem)) {
            return false;
        }
        List this$movimentacoes = this.getMovimentacoes();
        List other$movimentacoes = other.getMovimentacoes();
        return !(this$movimentacoes == null ? other$movimentacoes != null : !((Object)this$movimentacoes).equals(other$movimentacoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoCreditoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        OrigemCredito $origem = this.getOrigem();
        result = result * 59 + ($origem == null ? 43 : $origem.hashCode());
        LocalDate $dataOrigem = this.getDataOrigem();
        result = result * 59 + ($dataOrigem == null ? 43 : ((Object)$dataOrigem).hashCode());
        BigDecimal $saldoOriginal = this.getSaldoOriginal();
        result = result * 59 + ($saldoOriginal == null ? 43 : ((Object)$saldoOriginal).hashCode());
        BigDecimal $saldoDisponivel = this.getSaldoDisponivel();
        result = result * 59 + ($saldoDisponivel == null ? 43 : ((Object)$saldoDisponivel).hashCode());
        PagamentoCreditoOrigemDTO $pagamentoOrigem = this.getPagamentoOrigem();
        result = result * 59 + ($pagamentoOrigem == null ? 43 : $pagamentoOrigem.hashCode());
        List $movimentacoes = this.getMovimentacoes();
        result = result * 59 + ($movimentacoes == null ? 43 : ((Object)$movimentacoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoCreditoDTO(id=" + this.getId() + ", origem=" + String.valueOf(this.getOrigem()) + ", cadastroGeral=" + this.getCadastroGeral() + ", tipoCadastro=" + this.getTipoCadastro() + ", dataOrigem=" + String.valueOf(this.getDataOrigem()) + ", saldoOriginal=" + String.valueOf(this.getSaldoOriginal()) + ", saldoDisponivel=" + String.valueOf(this.getSaldoDisponivel()) + ", pagamentoOrigem=" + String.valueOf(this.getPagamentoOrigem()) + ", movimentacoes=" + String.valueOf(this.getMovimentacoes()) + ")";
    }
}

