/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoInfoDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class PagamentoLoteIntegracaoDTO {
    private Long entidade;
    private Long exercicio;
    private Long lote;
    private LocalDate dataLote;
    private LocalDate dataMovimento;
    private LocalDate dataCredito;
    private String conta;
    private String tipo;
    private String situacao;
    private Long contaBancaria;
    private String descricaoContaBancaria;
    private String nomeArquivoRetorno;
    private String observacao;
    private List<PagamentoLoteIntegracaoInfoDTO> integracoesInfo;
    private Boolean podeIntegrarContabilidade;
    private Boolean integradoContabilidade;
    private Boolean contaBancariaIntegracao;

    public PagamentoLoteIntegracaoDTO() {
    }

    public PagamentoLoteIntegracaoDTO(PagamentoLote pagamentoLote) {
        List lotes;
        this.entidade = pagamentoLote.getId().getEntidade();
        this.exercicio = pagamentoLote.getId().getExercicio();
        this.lote = pagamentoLote.getId().getLote();
        this.dataLote = pagamentoLote.getDataLote();
        this.dataMovimento = pagamentoLote.getDataMovimento();
        this.dataCredito = pagamentoLote.getDataCredito();
        this.observacao = pagamentoLote.getObservacao();
        if (Objects.nonNull(pagamentoLote.getSituacao())) {
            this.situacao = pagamentoLote.getSituacao().getDescricao();
        }
        if (Objects.nonNull(lotes = pagamentoLote.getLotesIntegracaoContabil()) && !lotes.isEmpty()) {
            this.podeIntegrarContabilidade = lotes.stream().allMatch(l -> SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)l.getSituacaoIntegracaoContabil())) && pagamentoLote.getPodeIntegrarLotePagamento();
            this.integradoContabilidade = lotes.stream().allMatch(LoteIntegracaoContabil::getPagamentoIntegradoContabilidade);
            this.integracoesInfo = lotes.stream().map(PagamentoLoteIntegracaoInfoDTO::from).collect(Collectors.toList());
        } else {
            this.podeIntegrarContabilidade = pagamentoLote.getPodeIntegrarLotePagamento();
            this.integradoContabilidade = Boolean.FALSE;
        }
        TipoPagamentoLote tipoPagamento = Optional.ofNullable(pagamentoLote.getTipo()).orElse(TipoPagamentoLote.ARQUIVO);
        this.tipo = tipoPagamento.getDescricao();
        if (Objects.nonNull(pagamentoLote.getContaBancaria())) {
            this.conta = pagamentoLote.getContaBancaria().getConta();
            this.contaBancaria = pagamentoLote.getContaBancaria().getContaBancaria();
            this.descricaoContaBancaria = pagamentoLote.getContaBancaria().getDescricao();
            this.conta = pagamentoLote.getContaBancaria().getConta();
            this.contaBancariaIntegracao = Optional.ofNullable(pagamentoLote.getContaBancaria().getIntegraArrecadacao()).orElse(Boolean.FALSE);
        }
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public String getConta() {
        return this.conta;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public String getDescricaoContaBancaria() {
        return this.descricaoContaBancaria;
    }

    @Generated
    public String getNomeArquivoRetorno() {
        return this.nomeArquivoRetorno;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<PagamentoLoteIntegracaoInfoDTO> getIntegracoesInfo() {
        return this.integracoesInfo;
    }

    @Generated
    public Boolean getPodeIntegrarContabilidade() {
        return this.podeIntegrarContabilidade;
    }

    @Generated
    public Boolean getIntegradoContabilidade() {
        return this.integradoContabilidade;
    }

    @Generated
    public Boolean getContaBancariaIntegracao() {
        return this.contaBancariaIntegracao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setConta(String conta) {
        this.conta = conta;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDescricaoContaBancaria(String descricaoContaBancaria) {
        this.descricaoContaBancaria = descricaoContaBancaria;
    }

    @Generated
    public void setNomeArquivoRetorno(String nomeArquivoRetorno) {
        this.nomeArquivoRetorno = nomeArquivoRetorno;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setIntegracoesInfo(List<PagamentoLoteIntegracaoInfoDTO> integracoesInfo) {
        this.integracoesInfo = integracoesInfo;
    }

    @Generated
    public void setPodeIntegrarContabilidade(Boolean podeIntegrarContabilidade) {
        this.podeIntegrarContabilidade = podeIntegrarContabilidade;
    }

    @Generated
    public void setIntegradoContabilidade(Boolean integradoContabilidade) {
        this.integradoContabilidade = integradoContabilidade;
    }

    @Generated
    public void setContaBancariaIntegracao(Boolean contaBancariaIntegracao) {
        this.contaBancariaIntegracao = contaBancariaIntegracao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoLoteIntegracaoDTO)) {
            return false;
        }
        PagamentoLoteIntegracaoDTO other = (PagamentoLoteIntegracaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$contaBancaria = this.getContaBancaria();
        Long other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !((Object)this$contaBancaria).equals(other$contaBancaria)) {
            return false;
        }
        Boolean this$podeIntegrarContabilidade = this.getPodeIntegrarContabilidade();
        Boolean other$podeIntegrarContabilidade = other.getPodeIntegrarContabilidade();
        if (this$podeIntegrarContabilidade == null ? other$podeIntegrarContabilidade != null : !((Object)this$podeIntegrarContabilidade).equals(other$podeIntegrarContabilidade)) {
            return false;
        }
        Boolean this$integradoContabilidade = this.getIntegradoContabilidade();
        Boolean other$integradoContabilidade = other.getIntegradoContabilidade();
        if (this$integradoContabilidade == null ? other$integradoContabilidade != null : !((Object)this$integradoContabilidade).equals(other$integradoContabilidade)) {
            return false;
        }
        Boolean this$contaBancariaIntegracao = this.getContaBancariaIntegracao();
        Boolean other$contaBancariaIntegracao = other.getContaBancariaIntegracao();
        if (this$contaBancariaIntegracao == null ? other$contaBancariaIntegracao != null : !((Object)this$contaBancariaIntegracao).equals(other$contaBancariaIntegracao)) {
            return false;
        }
        LocalDate this$dataLote = this.getDataLote();
        LocalDate other$dataLote = other.getDataLote();
        if (this$dataLote == null ? other$dataLote != null : !((Object)this$dataLote).equals(other$dataLote)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        String this$conta = this.getConta();
        String other$conta = other.getConta();
        if (this$conta == null ? other$conta != null : !this$conta.equals(other$conta)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$descricaoContaBancaria = this.getDescricaoContaBancaria();
        String other$descricaoContaBancaria = other.getDescricaoContaBancaria();
        if (this$descricaoContaBancaria == null ? other$descricaoContaBancaria != null : !this$descricaoContaBancaria.equals(other$descricaoContaBancaria)) {
            return false;
        }
        String this$nomeArquivoRetorno = this.getNomeArquivoRetorno();
        String other$nomeArquivoRetorno = other.getNomeArquivoRetorno();
        if (this$nomeArquivoRetorno == null ? other$nomeArquivoRetorno != null : !this$nomeArquivoRetorno.equals(other$nomeArquivoRetorno)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        List this$integracoesInfo = this.getIntegracoesInfo();
        List other$integracoesInfo = other.getIntegracoesInfo();
        return !(this$integracoesInfo == null ? other$integracoesInfo != null : !((Object)this$integracoesInfo).equals(other$integracoesInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoLoteIntegracaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : ((Object)$contaBancaria).hashCode());
        Boolean $podeIntegrarContabilidade = this.getPodeIntegrarContabilidade();
        result = result * 59 + ($podeIntegrarContabilidade == null ? 43 : ((Object)$podeIntegrarContabilidade).hashCode());
        Boolean $integradoContabilidade = this.getIntegradoContabilidade();
        result = result * 59 + ($integradoContabilidade == null ? 43 : ((Object)$integradoContabilidade).hashCode());
        Boolean $contaBancariaIntegracao = this.getContaBancariaIntegracao();
        result = result * 59 + ($contaBancariaIntegracao == null ? 43 : ((Object)$contaBancariaIntegracao).hashCode());
        LocalDate $dataLote = this.getDataLote();
        result = result * 59 + ($dataLote == null ? 43 : ((Object)$dataLote).hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        String $conta = this.getConta();
        result = result * 59 + ($conta == null ? 43 : $conta.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $descricaoContaBancaria = this.getDescricaoContaBancaria();
        result = result * 59 + ($descricaoContaBancaria == null ? 43 : $descricaoContaBancaria.hashCode());
        String $nomeArquivoRetorno = this.getNomeArquivoRetorno();
        result = result * 59 + ($nomeArquivoRetorno == null ? 43 : $nomeArquivoRetorno.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        List $integracoesInfo = this.getIntegracoesInfo();
        result = result * 59 + ($integracoesInfo == null ? 43 : ((Object)$integracoesInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoLoteIntegracaoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", lote=" + this.getLote() + ", dataLote=" + String.valueOf(this.getDataLote()) + ", dataMovimento=" + String.valueOf(this.getDataMovimento()) + ", dataCredito=" + String.valueOf(this.getDataCredito()) + ", conta=" + this.getConta() + ", tipo=" + this.getTipo() + ", situacao=" + this.getSituacao() + ", contaBancaria=" + this.getContaBancaria() + ", descricaoContaBancaria=" + this.getDescricaoContaBancaria() + ", nomeArquivoRetorno=" + this.getNomeArquivoRetorno() + ", observacao=" + this.getObservacao() + ", integracoesInfo=" + String.valueOf(this.getIntegracoesInfo()) + ", podeIntegrarContabilidade=" + this.getPodeIntegrarContabilidade() + ", integradoContabilidade=" + this.getIntegradoContabilidade() + ", contaBancariaIntegracao=" + this.getContaBancariaIntegracao() + ")";
    }
}

