/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.memoria;

import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.memoria.ImobiliarioSegmentoMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioSegmentoMemoriaId;
import br.com.elotech.tributos.domain.memoria.RespostaSegmentoMemoria;
import br.com.elotech.tributos.dto.cadastroimobiliario.SituacaoSegmentoDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class SegmentoMemoriaDTO {
    private Long id;
    private Long idKey;
    private Long idSegmentoImobiliario;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long sequencia;
    private TipoSegmento tipoSegmento;
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    private BigDecimal areaCoberta = BigDecimal.ZERO;
    private BigDecimal areaDescoberta = BigDecimal.ZERO;
    private SituacaoSegmentoDTO situacao;
    private List<GrupoRespostasDTO> respostasSegmento = new ArrayList();
    private Boolean delete = false;

    public static SegmentoMemoriaDTO from(ImobiliarioSegmentoMemoria entity) {
        SegmentoMemoriaDTO dto = new SegmentoMemoriaDTO();
        dto.setIdKey(entity.getId().getIdKey());
        dto.setIdSegmentoImobiliario(entity.getIdSegmentoImobiliario());
        dto.setId(entity.getId().getIdMemoriaCadastro());
        dto.setTipoCadastro(entity.getTipoCadastro());
        dto.setCadastroGeral(entity.getCadastroGeral());
        dto.setSequencia(entity.getSequencia());
        dto.setTipoSegmento(entity.getTipoSegmento());
        dto.setAreaConstruida(entity.getAreaConstruida());
        dto.setAreaCoberta(entity.getAreaCoberta());
        dto.setAreaDescoberta(entity.getAreaDescoberta());
        Optional.ofNullable(entity.getSituacaoSegmento()).map(SituacaoSegmentoDTO::from).ifPresent(arg_0 -> dto.setSituacao(arg_0));
        return dto;
    }

    public ImobiliarioSegmentoMemoria toEntity() {
        ImobiliarioSegmentoMemoriaId imobiliarioSegmentoMemoriaId = new ImobiliarioSegmentoMemoriaId();
        imobiliarioSegmentoMemoriaId.setIdMemoriaCadastro(this.getId());
        imobiliarioSegmentoMemoriaId.setIdKey(this.getIdKey());
        ImobiliarioSegmentoMemoria entity = new ImobiliarioSegmentoMemoria();
        entity.setTipoCadastro(this.getTipoCadastro());
        entity.setCadastroGeral(this.getCadastroGeral());
        entity.setSequencia(this.getSequencia());
        entity.setId(imobiliarioSegmentoMemoriaId);
        entity.setIdSegmentoImobiliario(this.getIdSegmentoImobiliario());
        entity.setAreaConstruida(this.getAreaConstruida());
        entity.setAreaCoberta(this.getAreaCoberta());
        entity.setAreaDescoberta(this.getAreaDescoberta());
        Optional.ofNullable(this.getSituacao()).map(SituacaoSegmentoDTO::toEntity).ifPresent(arg_0 -> ((ImobiliarioSegmentoMemoria)entity).setSituacaoSegmento(arg_0));
        entity.setTipoSegmento(this.getTipoSegmento());
        this.getRespostasSegmento().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> {
            RespostaSegmentoMemoria novaResposta = new RespostaSegmentoMemoria();
            novaResposta.setSegmento(entity);
            entity.getRespostasSegmento().add((RespostaSegmentoMemoria)resposta.copyTo((Resposta)novaResposta));
        }));
        return entity;
    }

    @Generated
    public SegmentoMemoriaDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdKey() {
        return this.idKey;
    }

    @Generated
    public Long getIdSegmentoImobiliario() {
        return this.idSegmentoImobiliario;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public TipoSegmento getTipoSegmento() {
        return this.tipoSegmento;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public BigDecimal getAreaCoberta() {
        return this.areaCoberta;
    }

    @Generated
    public BigDecimal getAreaDescoberta() {
        return this.areaDescoberta;
    }

    @Generated
    public SituacaoSegmentoDTO getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasSegmento() {
        return this.respostasSegmento;
    }

    @Generated
    public Boolean getDelete() {
        return this.delete;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdKey(Long idKey) {
        this.idKey = idKey;
    }

    @Generated
    public void setIdSegmentoImobiliario(Long idSegmentoImobiliario) {
        this.idSegmentoImobiliario = idSegmentoImobiliario;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoSegmento(TipoSegmento tipoSegmento) {
        this.tipoSegmento = tipoSegmento;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setAreaCoberta(BigDecimal areaCoberta) {
        this.areaCoberta = areaCoberta;
    }

    @Generated
    public void setAreaDescoberta(BigDecimal areaDescoberta) {
        this.areaDescoberta = areaDescoberta;
    }

    @Generated
    public void setSituacao(SituacaoSegmentoDTO situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setRespostasSegmento(List<GrupoRespostasDTO> respostasSegmento) {
        this.respostasSegmento = respostasSegmento;
    }

    @Generated
    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentoMemoriaDTO)) {
            return false;
        }
        SegmentoMemoriaDTO other = (SegmentoMemoriaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idKey = this.getIdKey();
        Long other$idKey = other.getIdKey();
        if (this$idKey == null ? other$idKey != null : !((Object)this$idKey).equals(other$idKey)) {
            return false;
        }
        Long this$idSegmentoImobiliario = this.getIdSegmentoImobiliario();
        Long other$idSegmentoImobiliario = other.getIdSegmentoImobiliario();
        if (this$idSegmentoImobiliario == null ? other$idSegmentoImobiliario != null : !((Object)this$idSegmentoImobiliario).equals(other$idSegmentoImobiliario)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        TipoSegmento this$tipoSegmento = this.getTipoSegmento();
        TipoSegmento other$tipoSegmento = other.getTipoSegmento();
        if (this$tipoSegmento == null ? other$tipoSegmento != null : !this$tipoSegmento.equals(other$tipoSegmento)) {
            return false;
        }
        BigDecimal this$areaConstruida = this.getAreaConstruida();
        BigDecimal other$areaConstruida = other.getAreaConstruida();
        if (this$areaConstruida == null ? other$areaConstruida != null : !((Object)this$areaConstruida).equals(other$areaConstruida)) {
            return false;
        }
        BigDecimal this$areaCoberta = this.getAreaCoberta();
        BigDecimal other$areaCoberta = other.getAreaCoberta();
        if (this$areaCoberta == null ? other$areaCoberta != null : !((Object)this$areaCoberta).equals(other$areaCoberta)) {
            return false;
        }
        BigDecimal this$areaDescoberta = this.getAreaDescoberta();
        BigDecimal other$areaDescoberta = other.getAreaDescoberta();
        if (this$areaDescoberta == null ? other$areaDescoberta != null : !((Object)this$areaDescoberta).equals(other$areaDescoberta)) {
            return false;
        }
        SituacaoSegmentoDTO this$situacao = this.getSituacao();
        SituacaoSegmentoDTO other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        List this$respostasSegmento = this.getRespostasSegmento();
        List other$respostasSegmento = other.getRespostasSegmento();
        return !(this$respostasSegmento == null ? other$respostasSegmento != null : !((Object)this$respostasSegmento).equals(other$respostasSegmento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentoMemoriaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idKey = this.getIdKey();
        result = result * 59 + ($idKey == null ? 43 : ((Object)$idKey).hashCode());
        Long $idSegmentoImobiliario = this.getIdSegmentoImobiliario();
        result = result * 59 + ($idSegmentoImobiliario == null ? 43 : ((Object)$idSegmentoImobiliario).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        TipoSegmento $tipoSegmento = this.getTipoSegmento();
        result = result * 59 + ($tipoSegmento == null ? 43 : $tipoSegmento.hashCode());
        BigDecimal $areaConstruida = this.getAreaConstruida();
        result = result * 59 + ($areaConstruida == null ? 43 : ((Object)$areaConstruida).hashCode());
        BigDecimal $areaCoberta = this.getAreaCoberta();
        result = result * 59 + ($areaCoberta == null ? 43 : ((Object)$areaCoberta).hashCode());
        BigDecimal $areaDescoberta = this.getAreaDescoberta();
        result = result * 59 + ($areaDescoberta == null ? 43 : ((Object)$areaDescoberta).hashCode());
        SituacaoSegmentoDTO $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        List $respostasSegmento = this.getRespostasSegmento();
        result = result * 59 + ($respostasSegmento == null ? 43 : ((Object)$respostasSegmento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SegmentoMemoriaDTO(id=" + this.getId() + ", idKey=" + this.getIdKey() + ", idSegmentoImobiliario=" + this.getIdSegmentoImobiliario() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", sequencia=" + this.getSequencia() + ", tipoSegmento=" + String.valueOf(this.getTipoSegmento()) + ", areaConstruida=" + String.valueOf(this.getAreaConstruida()) + ", areaCoberta=" + String.valueOf(this.getAreaCoberta()) + ", areaDescoberta=" + String.valueOf(this.getAreaDescoberta()) + ", situacao=" + String.valueOf(this.getSituacao()) + ", respostasSegmento=" + String.valueOf(this.getRespostasSegmento()) + ", delete=" + this.getDelete() + ")";
    }
}

