/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoprocuradoria;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;

public class FiltroExtratoDebitoProcuradoriaDTO {
    @Parameter(description="Filtro d\u00e9bito")
    private TipoExtratoDebitoEnum filtroDebito;
    @Parameter(description="Data de Lan\u00e7amento Inicial")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataLancamentoInicial;
    @Parameter(description="Data de Lan\u00e7amento Final")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataLancamentoFinal;
    @Parameter(description="Data de Vencimento Inicial")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataVencimentoInicial;
    @Parameter(description="Data de Vencimento Final")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataVencimentoFinal;
    @Parameter(description="Ano")
    private String ano;
    @Parameter(description="D\u00edvida")
    private String divida;
    @Parameter(description="SubD\u00edvida")
    private String subDivida;
    @Parameter(description="Parcela")
    private String parcela;
    @Parameter(description="N\u00famero da CDA")
    private String numeroCda;
    @Parameter(description="Exerc\u00edcio da CDA")
    private String exercicioCda;
    @Parameter(description="ID do D\u00e9bito")
    private Long idDebito;
    @Parameter(description="ID do Parcelamento")
    private Long idParcelamento;

    public FiltroExtratoDebitoDTO toFiltroExtratoDebitoDTO(Long tipoCadastro, Long cadastroGeral) {
        FiltroExtratoDebitoDTO dto = new FiltroExtratoDebitoDTO();
        dto.getCadastros().add(new CadastroGeralResumidoDTO(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
        dto.setFiltroCard(Optional.ofNullable(this.filtroDebito).orElse(TipoExtratoDebitoEnum.TODOS));
        dto.setDataLancamentoInicial(this.dataLancamentoInicial);
        dto.setDataLancamentoFinal(this.dataLancamentoFinal);
        dto.setDataVencimentoInicial(this.dataVencimentoInicial);
        dto.setDataVencimentoFinal(this.dataVencimentoFinal);
        dto.setAno(this.ano);
        dto.setDivida(this.divida);
        dto.setSubDivida(this.subDivida);
        dto.setParcela(this.parcela);
        dto.setNumeroCda(this.numeroCda);
        dto.setExercicioCda(this.exercicioCda);
        dto.setIdDebito(this.idDebito);
        dto.setIdParcelamento(this.idParcelamento);
        return dto;
    }

    @Generated
    public FiltroExtratoDebitoProcuradoriaDTO() {
    }

    @Generated
    public TipoExtratoDebitoEnum getFiltroDebito() {
        return this.filtroDebito;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public String getAno() {
        return this.ano;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public String getNumeroCda() {
        return this.numeroCda;
    }

    @Generated
    public String getExercicioCda() {
        return this.exercicioCda;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public void setFiltroDebito(TipoExtratoDebitoEnum filtroDebito) {
        this.filtroDebito = filtroDebito;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setAno(String ano) {
        this.ano = ano;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setNumeroCda(String numeroCda) {
        this.numeroCda = numeroCda;
    }

    @Generated
    public void setExercicioCda(String exercicioCda) {
        this.exercicioCda = exercicioCda;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroExtratoDebitoProcuradoriaDTO)) {
            return false;
        }
        FiltroExtratoDebitoProcuradoriaDTO other = (FiltroExtratoDebitoProcuradoriaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        TipoExtratoDebitoEnum this$filtroDebito = this.getFiltroDebito();
        TipoExtratoDebitoEnum other$filtroDebito = other.getFiltroDebito();
        if (this$filtroDebito == null ? other$filtroDebito != null : !this$filtroDebito.equals(other$filtroDebito)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        String this$ano = this.getAno();
        String other$ano = other.getAno();
        if (this$ano == null ? other$ano != null : !this$ano.equals(other$ano)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        String this$numeroCda = this.getNumeroCda();
        String other$numeroCda = other.getNumeroCda();
        if (this$numeroCda == null ? other$numeroCda != null : !this$numeroCda.equals(other$numeroCda)) {
            return false;
        }
        String this$exercicioCda = this.getExercicioCda();
        String other$exercicioCda = other.getExercicioCda();
        return !(this$exercicioCda == null ? other$exercicioCda != null : !this$exercicioCda.equals(other$exercicioCda));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroExtratoDebitoProcuradoriaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        TipoExtratoDebitoEnum $filtroDebito = this.getFiltroDebito();
        result = result * 59 + ($filtroDebito == null ? 43 : $filtroDebito.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        String $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : $ano.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        String $numeroCda = this.getNumeroCda();
        result = result * 59 + ($numeroCda == null ? 43 : $numeroCda.hashCode());
        String $exercicioCda = this.getExercicioCda();
        result = result * 59 + ($exercicioCda == null ? 43 : $exercicioCda.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroExtratoDebitoProcuradoriaDTO(filtroDebito=" + String.valueOf(this.getFiltroDebito()) + ", dataLancamentoInicial=" + String.valueOf(this.getDataLancamentoInicial()) + ", dataLancamentoFinal=" + String.valueOf(this.getDataLancamentoFinal()) + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", ano=" + this.getAno() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", numeroCda=" + this.getNumeroCda() + ", exercicioCda=" + this.getExercicioCda() + ", idDebito=" + this.getIdDebito() + ", idParcelamento=" + this.getIdParcelamento() + ")";
    }
}

