/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.BoletimLogradouro;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaRural;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.rural.BoletimRural;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloRespostaElogeoDTO;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class BoletimElogeoDTO {
    private String descricao;
    @NotNull
    @Valid
    protected ModeloRespostaElogeoDTO resposta;

    public static BoletimElogeoDTO from(BoletimImobiliarioTerreno boletimImobiliarioTerreno) {
        BoletimElogeoDTO boletimElogeoDTO = new BoletimElogeoDTO();
        boletimElogeoDTO.setDescricao(boletimImobiliarioTerreno.getDescricaoResposta());
        boletimElogeoDTO.setResposta(ModeloRespostaElogeoDTO.from((ModeloResposta)boletimImobiliarioTerreno.getModeloResposta()));
        return boletimElogeoDTO;
    }

    public static BoletimElogeoDTO from(BoletimImobiliarioSegmento boletimImobiliarioSegmento) {
        BoletimElogeoDTO boletimElogeoDTO = new BoletimElogeoDTO();
        boletimElogeoDTO.setDescricao(boletimImobiliarioSegmento.getDescricaoResposta());
        boletimElogeoDTO.setResposta(ModeloRespostaElogeoDTO.from((ModeloResposta)boletimImobiliarioSegmento.getModeloResposta()));
        return boletimElogeoDTO;
    }

    public static BoletimElogeoDTO from(BoletimLogradouro boletimLogradouro) {
        BoletimElogeoDTO boletimElogeoDTO = new BoletimElogeoDTO();
        boletimElogeoDTO.setDescricao(boletimLogradouro.getDescricaoResposta());
        boletimElogeoDTO.setResposta(ModeloRespostaElogeoDTO.from((ModeloResposta)boletimLogradouro.getModeloResposta()));
        return boletimElogeoDTO;
    }

    public static BoletimElogeoDTO from(Resposta resposta) {
        BoletimElogeoDTO boletimElogeoDTO = new BoletimElogeoDTO();
        boletimElogeoDTO.setDescricao(resposta.getValor());
        boletimElogeoDTO.setResposta(ModeloRespostaElogeoDTO.from((Resposta)resposta));
        return boletimElogeoDTO;
    }

    public BoletimImobiliarioTerreno toEntityTerreno(Long idCadastroImobiliario, ModeloResposta modeloResposta) {
        BoletimImobiliarioTerreno entity = new BoletimImobiliarioTerreno();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdCadastroImobiliario(idCadastroImobiliario);
        return entity;
    }

    public RespostaTerreno toEntityRespostaTerreno(CadastroImobiliario cadastroImobiliario, Alternativa alternativa, Campo campo, Long id) {
        RespostaTerreno entity = new RespostaTerreno();
        entity.setId(id);
        entity.setCadastroImobiliario(cadastroImobiliario);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        entity.setValor(Objects.nonNull(alternativa) ? alternativa.getDescricao() : this.getDescricao());
        return entity;
    }

    public BoletimImobiliarioSegmento toEntitySegmento(Long idImobiliarioSegmento, ModeloResposta modeloResposta) {
        BoletimImobiliarioSegmento entity = new BoletimImobiliarioSegmento();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdImobiliarioSegmento(idImobiliarioSegmento);
        return entity;
    }

    public RespostaSegmento toEntityRespotaSegmento(CadastroImobiliarioSegmento cadastroImobiliarioSegmento, Alternativa alternativa, Campo campo, Long id) {
        RespostaSegmento entity = new RespostaSegmento();
        entity.setId(id);
        entity.setSegmento(cadastroImobiliarioSegmento);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        if (Objects.nonNull(alternativa)) {
            entity.setValor(alternativa.getDescricao());
            return entity;
        }
        entity.setValor(this.getDescricao());
        return entity;
    }

    public RespostaRural toEntityRespostaRural(CadastroRural cadastroRural, Alternativa alternativa, Campo campo, Long id) {
        RespostaRural entity = new RespostaRural();
        entity.setCadastroRural(cadastroRural);
        entity.setId(id);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        if (Objects.nonNull(alternativa)) {
            entity.setValor(alternativa.getDescricao());
            return entity;
        }
        entity.setValor(this.getDescricao());
        return entity;
    }

    public BoletimLogradouro toEntityLogradouro(Long idLogradouroTestada, ModeloResposta modeloResposta) {
        BoletimLogradouro entity = new BoletimLogradouro();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdLogradouroTestada(idLogradouroTestada);
        return entity;
    }

    public BoletimRural toEntityRural(Long idCadastroRural, ModeloResposta modeloResposta) {
        BoletimRural entity = new BoletimRural();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdCadastroRural(idCadastroRural);
        return entity;
    }

    public static BoletimElogeoDTO from(BoletimRural boletimRural) {
        BoletimElogeoDTO boletimElogeoDTO = new BoletimElogeoDTO();
        boletimElogeoDTO.setDescricao(boletimRural.getDescricaoResposta());
        boletimElogeoDTO.setResposta(ModeloRespostaElogeoDTO.from((ModeloResposta)boletimRural.getModeloResposta()));
        return boletimElogeoDTO;
    }

    @Generated
    public BoletimElogeoDTO() {
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ModeloRespostaElogeoDTO getResposta() {
        return this.resposta;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setResposta(ModeloRespostaElogeoDTO resposta) {
        this.resposta = resposta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletimElogeoDTO)) {
            return false;
        }
        BoletimElogeoDTO other = (BoletimElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        ModeloRespostaElogeoDTO this$resposta = this.getResposta();
        ModeloRespostaElogeoDTO other$resposta = other.getResposta();
        return !(this$resposta == null ? other$resposta != null : !this$resposta.equals(other$resposta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletimElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        ModeloRespostaElogeoDTO $resposta = this.getResposta();
        result = result * 59 + ($resposta == null ? 43 : $resposta.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletimElogeoDTO(descricao=" + this.getDescricao() + ", resposta=" + String.valueOf(this.getResposta()) + ")";
    }
}

