/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicredi;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoDesconto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.EmissaoBoletoPixSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.EmissaoBoletoSicrediDTO;
import br.com.elotech.tributos.enums.cnab240.EspecieDocumento;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoBoletoPixSicrediDTO {
    public static final String HIBRIDO = "HIBRIDO";
    private String tipoCobranca;
    private String codigoBeneficiario;
    private Pagador pagador;
    private String especieDocumento;
    private String nossoNumero;
    private String seuNumero;
    private String dataVencimento;
    private BigDecimal valor;
    private BigDecimal valorDesconto1;
    private String dataDesconto1;
    private BigDecimal descontoAntecipado;
    private String tipoJuros;
    private String tipoDesconto;
    private BigDecimal juros;
    private BigDecimal multas;
    private List<String> informativo;
    private List<String> mensagem;

    public static EmissaoBoletoPixSicrediDTO from(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Sicredi) {
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa endereco = pessoa.getEnderecoPrincipal();
        EmissaoBoletoPixSicrediDTO dto = new EmissaoBoletoPixSicrediDTO();
        dto.setTipoCobranca("HIBRIDO");
        dto.setCodigoBeneficiario(convenio.getNumeroConvenio());
        Pagador pagador = new Pagador();
        pagador.setTipoPessoa(EmissaoBoletoPixSicrediDTO.getTipoPessoa((TipoPessoa)pessoa.getTipoPessoa()));
        pagador.setDocumento(pessoa.getCnpjCpf());
        pagador.setNome(StringUtils.substring((String)pessoa.getNome(), (int)0, (int)40));
        if (Objects.nonNull(endereco)) {
            pagador.setEndereco(EmissaoBoletoSicrediDTO.loadEndereco((EnderecoPessoa)endereco));
            pagador.setCep(EmissaoBoletoSicrediDTO.loadCep((EnderecoPessoa)endereco));
            pagador.setCidade(StringUtils.substring((String)endereco.getCidade().getDescricao(), (int)0, (int)25));
            pagador.setUf(endereco.getCidade().getUnidadeFederacao());
        }
        pagador.setTelefone(EmissaoBoletoSicrediDTO.loadTelefone((Pessoa)pessoa, null));
        dto.setPagador(pagador);
        dto.setNossoNumero(boleto.getNossoNumero());
        dto.setSeuNumero(boleto.getPessoa().getId().toString());
        dto.setDataVencimento(boleto.getDataVencimento());
        dto.setValor(boleto.getValorBloqueto());
        if (Objects.nonNull(parametrosCNAB240Sicredi)) {
            Optional.ofNullable(parametrosCNAB240Sicredi.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getIdEspecie).ifPresent(p -> dto.setEspecieDocumento(EspecieDocumento.fromValues((String)p).name()));
            dto.setTipoDesconto(parametrosCNAB240Sicredi.getCodigoDesconto());
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoDesconto()) && (EmissaoBoletoSicrediDTO.TIPO_DESCONTO_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoDesconto().getCodigo()) || EmissaoBoletoSicrediDTO.TIPO_DESCONTO_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoDesconto().getCodigo()))) {
                dto.setValorDesconto1(parametrosCNAB240Sicredi.getValorPercentualDesconto());
                dto.setDataDesconto1(boleto.getDataVencimento());
            }
            dto.setTipoJuros((Long)Optional.ofNullable(parametrosCNAB240Sicredi.getCodigoJuros()).map(CNAB240CodigoJuros::getId).orElse(null));
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoJuros()) && (EmissaoBoletoSicrediDTO.TIPO_JUROS_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoJuros().getId()) || EmissaoBoletoSicrediDTO.TIPO_JUROS_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoJuros().getId()))) {
                dto.setJuros(parametrosCNAB240Sicredi.getValorJurosDiaTaxa());
            }
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoMulta()) && (EmissaoBoletoSicrediDTO.TIPO_MULTA_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoMulta().getId()) || EmissaoBoletoSicrediDTO.TIPO_MULTA_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoMulta().getId()))) {
                dto.setMultas(parametrosCNAB240Sicredi.getValorPercentualMulta());
            } else {
                dto.setMultas(BigDecimal.ZERO);
            }
        }
        dto.setDescontoAntecipado(null);
        dto.setInformativo(null);
        dto.setMensagem(null);
        return dto;
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setDataDesconto1(LocalDate dataDesconto) {
        this.dataDesconto1 = dataDesconto.format(DateTimeFormatter.ofPattern("YYYY-MM-DD"));
    }

    private static String getTipoPessoa(TipoPessoa tipoPessoa) {
        String tipoDescricao = null;
        switch (1.$SwitchMap$br$com$elotech$core$enumerable$common$TipoPessoa[tipoPessoa.ordinal()]) {
            case 1: {
                tipoDescricao = "PESSOA_FISICA";
                break;
            }
            case 2: {
                tipoDescricao = "PESSOA_JURIDICA";
                break;
            }
            default: {
                tipoDescricao = null;
            }
        }
        return tipoDescricao;
    }

    public void setTipoDesconto(CNAB240CodigoDesconto codigoDesconto) {
        if (Objects.nonNull(codigoDesconto) && EmissaoBoletoSicrediDTO.TIPO_DESCONTO_PERCENTUAL.equals(codigoDesconto.getCodigo())) {
            this.tipoDesconto = "PERCENTUAL";
            return;
        }
        this.tipoDesconto = "VALOR";
    }

    public void setTipoJuros(Long tipo) {
        if (Objects.nonNull(tipo) && EmissaoBoletoSicrediDTO.TIPO_JUROS_PERCENTUAL.equals(tipo)) {
            this.tipoJuros = "PERCENTUAL";
            return;
        }
        this.tipoJuros = "VALOR";
    }

    @Generated
    public EmissaoBoletoPixSicrediDTO() {
    }

    @Generated
    public String getTipoCobranca() {
        return this.tipoCobranca;
    }

    @Generated
    public String getCodigoBeneficiario() {
        return this.codigoBeneficiario;
    }

    @Generated
    public Pagador getPagador() {
        return this.pagador;
    }

    @Generated
    public String getEspecieDocumento() {
        return this.especieDocumento;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getSeuNumero() {
        return this.seuNumero;
    }

    @Generated
    public String getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorDesconto1() {
        return this.valorDesconto1;
    }

    @Generated
    public String getDataDesconto1() {
        return this.dataDesconto1;
    }

    @Generated
    public BigDecimal getDescontoAntecipado() {
        return this.descontoAntecipado;
    }

    @Generated
    public String getTipoJuros() {
        return this.tipoJuros;
    }

    @Generated
    public String getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public BigDecimal getJuros() {
        return this.juros;
    }

    @Generated
    public BigDecimal getMultas() {
        return this.multas;
    }

    @Generated
    public List<String> getInformativo() {
        return this.informativo;
    }

    @Generated
    public List<String> getMensagem() {
        return this.mensagem;
    }

    @Generated
    public void setTipoCobranca(String tipoCobranca) {
        this.tipoCobranca = tipoCobranca;
    }

    @Generated
    public void setCodigoBeneficiario(String codigoBeneficiario) {
        this.codigoBeneficiario = codigoBeneficiario;
    }

    @Generated
    public void setPagador(Pagador pagador) {
        this.pagador = pagador;
    }

    @Generated
    public void setEspecieDocumento(String especieDocumento) {
        this.especieDocumento = especieDocumento;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setSeuNumero(String seuNumero) {
        this.seuNumero = seuNumero;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorDesconto1(BigDecimal valorDesconto1) {
        this.valorDesconto1 = valorDesconto1;
    }

    @Generated
    public void setDescontoAntecipado(BigDecimal descontoAntecipado) {
        this.descontoAntecipado = descontoAntecipado;
    }

    @Generated
    public void setJuros(BigDecimal juros) {
        this.juros = juros;
    }

    @Generated
    public void setMultas(BigDecimal multas) {
        this.multas = multas;
    }

    @Generated
    public void setInformativo(List<String> informativo) {
        this.informativo = informativo;
    }

    @Generated
    public void setMensagem(List<String> mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoPixSicrediDTO)) {
            return false;
        }
        EmissaoBoletoPixSicrediDTO other = (EmissaoBoletoPixSicrediDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tipoCobranca = this.getTipoCobranca();
        String other$tipoCobranca = other.getTipoCobranca();
        if (this$tipoCobranca == null ? other$tipoCobranca != null : !this$tipoCobranca.equals(other$tipoCobranca)) {
            return false;
        }
        String this$codigoBeneficiario = this.getCodigoBeneficiario();
        String other$codigoBeneficiario = other.getCodigoBeneficiario();
        if (this$codigoBeneficiario == null ? other$codigoBeneficiario != null : !this$codigoBeneficiario.equals(other$codigoBeneficiario)) {
            return false;
        }
        Pagador this$pagador = this.getPagador();
        Pagador other$pagador = other.getPagador();
        if (this$pagador == null ? other$pagador != null : !this$pagador.equals(other$pagador)) {
            return false;
        }
        String this$especieDocumento = this.getEspecieDocumento();
        String other$especieDocumento = other.getEspecieDocumento();
        if (this$especieDocumento == null ? other$especieDocumento != null : !this$especieDocumento.equals(other$especieDocumento)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$seuNumero = this.getSeuNumero();
        String other$seuNumero = other.getSeuNumero();
        if (this$seuNumero == null ? other$seuNumero != null : !this$seuNumero.equals(other$seuNumero)) {
            return false;
        }
        String this$dataVencimento = this.getDataVencimento();
        String other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !this$dataVencimento.equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorDesconto1 = this.getValorDesconto1();
        BigDecimal other$valorDesconto1 = other.getValorDesconto1();
        if (this$valorDesconto1 == null ? other$valorDesconto1 != null : !((Object)this$valorDesconto1).equals(other$valorDesconto1)) {
            return false;
        }
        String this$dataDesconto1 = this.getDataDesconto1();
        String other$dataDesconto1 = other.getDataDesconto1();
        if (this$dataDesconto1 == null ? other$dataDesconto1 != null : !this$dataDesconto1.equals(other$dataDesconto1)) {
            return false;
        }
        BigDecimal this$descontoAntecipado = this.getDescontoAntecipado();
        BigDecimal other$descontoAntecipado = other.getDescontoAntecipado();
        if (this$descontoAntecipado == null ? other$descontoAntecipado != null : !((Object)this$descontoAntecipado).equals(other$descontoAntecipado)) {
            return false;
        }
        String this$tipoJuros = this.getTipoJuros();
        String other$tipoJuros = other.getTipoJuros();
        if (this$tipoJuros == null ? other$tipoJuros != null : !this$tipoJuros.equals(other$tipoJuros)) {
            return false;
        }
        String this$tipoDesconto = this.getTipoDesconto();
        String other$tipoDesconto = other.getTipoDesconto();
        if (this$tipoDesconto == null ? other$tipoDesconto != null : !this$tipoDesconto.equals(other$tipoDesconto)) {
            return false;
        }
        BigDecimal this$juros = this.getJuros();
        BigDecimal other$juros = other.getJuros();
        if (this$juros == null ? other$juros != null : !((Object)this$juros).equals(other$juros)) {
            return false;
        }
        BigDecimal this$multas = this.getMultas();
        BigDecimal other$multas = other.getMultas();
        if (this$multas == null ? other$multas != null : !((Object)this$multas).equals(other$multas)) {
            return false;
        }
        List this$informativo = this.getInformativo();
        List other$informativo = other.getInformativo();
        if (this$informativo == null ? other$informativo != null : !((Object)this$informativo).equals(other$informativo)) {
            return false;
        }
        List this$mensagem = this.getMensagem();
        List other$mensagem = other.getMensagem();
        return !(this$mensagem == null ? other$mensagem != null : !((Object)this$mensagem).equals(other$mensagem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoPixSicrediDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tipoCobranca = this.getTipoCobranca();
        result = result * 59 + ($tipoCobranca == null ? 43 : $tipoCobranca.hashCode());
        String $codigoBeneficiario = this.getCodigoBeneficiario();
        result = result * 59 + ($codigoBeneficiario == null ? 43 : $codigoBeneficiario.hashCode());
        Pagador $pagador = this.getPagador();
        result = result * 59 + ($pagador == null ? 43 : $pagador.hashCode());
        String $especieDocumento = this.getEspecieDocumento();
        result = result * 59 + ($especieDocumento == null ? 43 : $especieDocumento.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $seuNumero = this.getSeuNumero();
        result = result * 59 + ($seuNumero == null ? 43 : $seuNumero.hashCode());
        String $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : $dataVencimento.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorDesconto1 = this.getValorDesconto1();
        result = result * 59 + ($valorDesconto1 == null ? 43 : ((Object)$valorDesconto1).hashCode());
        String $dataDesconto1 = this.getDataDesconto1();
        result = result * 59 + ($dataDesconto1 == null ? 43 : $dataDesconto1.hashCode());
        BigDecimal $descontoAntecipado = this.getDescontoAntecipado();
        result = result * 59 + ($descontoAntecipado == null ? 43 : ((Object)$descontoAntecipado).hashCode());
        String $tipoJuros = this.getTipoJuros();
        result = result * 59 + ($tipoJuros == null ? 43 : $tipoJuros.hashCode());
        String $tipoDesconto = this.getTipoDesconto();
        result = result * 59 + ($tipoDesconto == null ? 43 : $tipoDesconto.hashCode());
        BigDecimal $juros = this.getJuros();
        result = result * 59 + ($juros == null ? 43 : ((Object)$juros).hashCode());
        BigDecimal $multas = this.getMultas();
        result = result * 59 + ($multas == null ? 43 : ((Object)$multas).hashCode());
        List $informativo = this.getInformativo();
        result = result * 59 + ($informativo == null ? 43 : ((Object)$informativo).hashCode());
        List $mensagem = this.getMensagem();
        result = result * 59 + ($mensagem == null ? 43 : ((Object)$mensagem).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoPixSicrediDTO(tipoCobranca=" + this.getTipoCobranca() + ", codigoBeneficiario=" + this.getCodigoBeneficiario() + ", pagador=" + String.valueOf(this.getPagador()) + ", especieDocumento=" + this.getEspecieDocumento() + ", nossoNumero=" + this.getNossoNumero() + ", seuNumero=" + this.getSeuNumero() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + String.valueOf(this.getValor()) + ", valorDesconto1=" + String.valueOf(this.getValorDesconto1()) + ", dataDesconto1=" + this.getDataDesconto1() + ", descontoAntecipado=" + String.valueOf(this.getDescontoAntecipado()) + ", tipoJuros=" + this.getTipoJuros() + ", tipoDesconto=" + this.getTipoDesconto() + ", juros=" + String.valueOf(this.getJuros()) + ", multas=" + String.valueOf(this.getMultas()) + ", informativo=" + String.valueOf(this.getInformativo()) + ", mensagem=" + String.valueOf(this.getMensagem()) + ")";
    }
}

