/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicredi;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.enums.integracaoboleto.sicredi.TipoComplementoInstrucaoSicredi;
import br.com.elotech.tributos.enums.integracaoboleto.sicredi.TipoInstrucaoComandoSicredi;
import br.com.elotech.tributos.enums.integracaoboleto.sicredi.TipoVencimentoSicredi;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class AlteracaoVencimentoBoletoSicrediDTO {
    private String agencia;
    private String posto;
    private String cedente;
    private String nossoNumero;
    private TipoInstrucaoComandoSicredi instrucaoComando;
    private TipoComplementoInstrucaoSicredi complementoInstrucao;
    private TipoVencimentoSicredi tipoVencimento;
    private String data1;

    public static AlteracaoVencimentoBoletoSicrediDTO from(Bloqueto boleto, LocalDate vencimento) {
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        AlteracaoVencimentoBoletoSicrediDTO dto = new AlteracaoVencimentoBoletoSicrediDTO();
        dto.setAgencia(StringUtils.leftPad((String)convenio.getContaBancaria().getAgencia().getAgencia(), (int)4, (String)"0"));
        dto.setPosto(convenio.getCodigoPosto());
        dto.setCedente(convenio.getCodigoCedente());
        dto.setNossoNumero(boleto.getNossoNumero());
        dto.setInstrucaoComando(TipoInstrucaoComandoSicredi.ALTERACAO_VENCIMENTO);
        dto.setComplementoInstrucao(null);
        dto.setTipoVencimento(TipoVencimentoSicredi.DATA_ESPECIFICA);
        dto.setData1(vencimento);
        return dto;
    }

    public void setData1(LocalDate data) {
        this.data1 = data.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    @Generated
    public AlteracaoVencimentoBoletoSicrediDTO() {
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public String getPosto() {
        return this.posto;
    }

    @Generated
    public String getCedente() {
        return this.cedente;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public TipoInstrucaoComandoSicredi getInstrucaoComando() {
        return this.instrucaoComando;
    }

    @Generated
    public TipoComplementoInstrucaoSicredi getComplementoInstrucao() {
        return this.complementoInstrucao;
    }

    @Generated
    public TipoVencimentoSicredi getTipoVencimento() {
        return this.tipoVencimento;
    }

    @Generated
    public String getData1() {
        return this.data1;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setPosto(String posto) {
        this.posto = posto;
    }

    @Generated
    public void setCedente(String cedente) {
        this.cedente = cedente;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setInstrucaoComando(TipoInstrucaoComandoSicredi instrucaoComando) {
        this.instrucaoComando = instrucaoComando;
    }

    @Generated
    public void setComplementoInstrucao(TipoComplementoInstrucaoSicredi complementoInstrucao) {
        this.complementoInstrucao = complementoInstrucao;
    }

    @Generated
    public void setTipoVencimento(TipoVencimentoSicredi tipoVencimento) {
        this.tipoVencimento = tipoVencimento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlteracaoVencimentoBoletoSicrediDTO)) {
            return false;
        }
        AlteracaoVencimentoBoletoSicrediDTO other = (AlteracaoVencimentoBoletoSicrediDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$agencia = this.getAgencia();
        String other$agencia = other.getAgencia();
        if (this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia)) {
            return false;
        }
        String this$posto = this.getPosto();
        String other$posto = other.getPosto();
        if (this$posto == null ? other$posto != null : !this$posto.equals(other$posto)) {
            return false;
        }
        String this$cedente = this.getCedente();
        String other$cedente = other.getCedente();
        if (this$cedente == null ? other$cedente != null : !this$cedente.equals(other$cedente)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        TipoInstrucaoComandoSicredi this$instrucaoComando = this.getInstrucaoComando();
        TipoInstrucaoComandoSicredi other$instrucaoComando = other.getInstrucaoComando();
        if (this$instrucaoComando == null ? other$instrucaoComando != null : !this$instrucaoComando.equals(other$instrucaoComando)) {
            return false;
        }
        TipoComplementoInstrucaoSicredi this$complementoInstrucao = this.getComplementoInstrucao();
        TipoComplementoInstrucaoSicredi other$complementoInstrucao = other.getComplementoInstrucao();
        if (this$complementoInstrucao == null ? other$complementoInstrucao != null : !this$complementoInstrucao.equals(other$complementoInstrucao)) {
            return false;
        }
        TipoVencimentoSicredi this$tipoVencimento = this.getTipoVencimento();
        TipoVencimentoSicredi other$tipoVencimento = other.getTipoVencimento();
        if (this$tipoVencimento == null ? other$tipoVencimento != null : !this$tipoVencimento.equals(other$tipoVencimento)) {
            return false;
        }
        String this$data1 = this.getData1();
        String other$data1 = other.getData1();
        return !(this$data1 == null ? other$data1 != null : !this$data1.equals(other$data1));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlteracaoVencimentoBoletoSicrediDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        String $posto = this.getPosto();
        result = result * 59 + ($posto == null ? 43 : $posto.hashCode());
        String $cedente = this.getCedente();
        result = result * 59 + ($cedente == null ? 43 : $cedente.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        TipoInstrucaoComandoSicredi $instrucaoComando = this.getInstrucaoComando();
        result = result * 59 + ($instrucaoComando == null ? 43 : $instrucaoComando.hashCode());
        TipoComplementoInstrucaoSicredi $complementoInstrucao = this.getComplementoInstrucao();
        result = result * 59 + ($complementoInstrucao == null ? 43 : $complementoInstrucao.hashCode());
        TipoVencimentoSicredi $tipoVencimento = this.getTipoVencimento();
        result = result * 59 + ($tipoVencimento == null ? 43 : $tipoVencimento.hashCode());
        String $data1 = this.getData1();
        result = result * 59 + ($data1 == null ? 43 : $data1.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlteracaoVencimentoBoletoSicrediDTO(agencia=" + this.getAgencia() + ", posto=" + this.getPosto() + ", cedente=" + this.getCedente() + ", nossoNumero=" + this.getNossoNumero() + ", instrucaoComando=" + String.valueOf(this.getInstrucaoComando()) + ", complementoInstrucao=" + String.valueOf(this.getComplementoInstrucao()) + ", tipoVencimento=" + String.valueOf(this.getTipoVencimento()) + ", data1=" + this.getData1() + ")";
    }
}

