/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.santander;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.santander.CalendarioDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.DevedorDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.InformacaoAdicionalDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.QrCodePixSantanderRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.ValorDTO;
import br.com.elotech.tributos.util.CnpjCpfValidator;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class QrCodePixSantanderRequestDTO
implements Serializable {
    private CalendarioDTO calendario;
    private DevedorDTO devedor;
    private ValorDTO valor;
    private String chave;
    private List<InformacaoAdicionalDTO> infoAdicionais;

    public static QrCodePixSantanderRequestDTO from(Bloqueto boleto) {
        return Optional.ofNullable(boleto).map(blt -> {
            Pessoa pessoa = blt.getPessoa();
            DevedorDTO devedor = new DevedorDTO();
            if (Objects.nonNull(pessoa.getCnpjCpf()) && Boolean.TRUE.equals(CnpjCpfValidator.isValidCnpjCpf((String)pessoa.getCnpjCpf()))) {
                if (TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa())) {
                    devedor.setCpf(pessoa.getCnpjCpfSemMascara());
                } else if (TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa())) {
                    devedor.setCnpj(pessoa.getCnpjCpfSemMascara());
                }
                devedor.setNome(pessoa.getNome());
            }
            StringBuilder codigoBarrasComDigito = new StringBuilder(blt.getCampo1());
            codigoBarrasComDigito.append(blt.getCampo2());
            codigoBarrasComDigito.append(blt.getCampo3());
            codigoBarrasComDigito.append(blt.getCampo4());
            return QrCodePixSantanderRequestDTO.builder().calendario(new CalendarioDTO(Long.valueOf(LocalDateTime.now().until(boleto.getDataVencimento().atTime(LocalTime.MAX), ChronoUnit.SECONDS)))).devedor(devedor).valor(new ValorDTO(blt.getValorBloqueto().toString())).chave(boleto.getModeloBloqueto().getConvenio().getChavePix()).infoAdicionais(List.of(InformacaoAdicionalDTO.builder().nome("codigo_de_barras").valor(codigoBarrasComDigito.toString()).build())).build();
        }).orElse(null);
    }

    @Generated
    QrCodePixSantanderRequestDTO(CalendarioDTO calendario, DevedorDTO devedor, ValorDTO valor, String chave, List<InformacaoAdicionalDTO> infoAdicionais) {
        this.calendario = calendario;
        this.devedor = devedor;
        this.valor = valor;
        this.chave = chave;
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public static QrCodePixSantanderRequestDTOBuilder builder() {
        return new QrCodePixSantanderRequestDTOBuilder();
    }

    @Generated
    public CalendarioDTO getCalendario() {
        return this.calendario;
    }

    @Generated
    public DevedorDTO getDevedor() {
        return this.devedor;
    }

    @Generated
    public ValorDTO getValor() {
        return this.valor;
    }

    @Generated
    public String getChave() {
        return this.chave;
    }

    @Generated
    public List<InformacaoAdicionalDTO> getInfoAdicionais() {
        return this.infoAdicionais;
    }

    @Generated
    public void setCalendario(CalendarioDTO calendario) {
        this.calendario = calendario;
    }

    @Generated
    public void setDevedor(DevedorDTO devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setValor(ValorDTO valor) {
        this.valor = valor;
    }

    @Generated
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Generated
    public void setInfoAdicionais(List<InformacaoAdicionalDTO> infoAdicionais) {
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCodePixSantanderRequestDTO)) {
            return false;
        }
        QrCodePixSantanderRequestDTO other = (QrCodePixSantanderRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalendarioDTO this$calendario = this.getCalendario();
        CalendarioDTO other$calendario = other.getCalendario();
        if (this$calendario == null ? other$calendario != null : !this$calendario.equals(other$calendario)) {
            return false;
        }
        DevedorDTO this$devedor = this.getDevedor();
        DevedorDTO other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        ValorDTO this$valor = this.getValor();
        ValorDTO other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        String this$chave = this.getChave();
        String other$chave = other.getChave();
        if (this$chave == null ? other$chave != null : !this$chave.equals(other$chave)) {
            return false;
        }
        List this$infoAdicionais = this.getInfoAdicionais();
        List other$infoAdicionais = other.getInfoAdicionais();
        return !(this$infoAdicionais == null ? other$infoAdicionais != null : !((Object)this$infoAdicionais).equals(other$infoAdicionais));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QrCodePixSantanderRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalendarioDTO $calendario = this.getCalendario();
        result = result * 59 + ($calendario == null ? 43 : $calendario.hashCode());
        DevedorDTO $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        ValorDTO $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        String $chave = this.getChave();
        result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
        List $infoAdicionais = this.getInfoAdicionais();
        result = result * 59 + ($infoAdicionais == null ? 43 : ((Object)$infoAdicionais).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QrCodePixSantanderRequestDTO(calendario=" + String.valueOf(this.getCalendario()) + ", devedor=" + String.valueOf(this.getDevedor()) + ", valor=" + String.valueOf(this.getValor()) + ", chave=" + this.getChave() + ", infoAdicionais=" + String.valueOf(this.getInfoAdicionais()) + ")";
    }
}

