/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.itau;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CalendarioPixItau;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.DevedorPixItau;
import br.com.elotech.tributos.dto.integracaoboleto.itau.GerarQrCodePixItauRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.InfoAdicionaisPixItau;
import br.com.elotech.tributos.dto.integracaoboleto.itau.ValorPixItau;
import br.com.elotech.tributos.util.EmailValidator;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GerarQrCodePixItauRequestDTO {
    private CalendarioPixItau calendario;
    private DevedorPixItau devedor;
    private ValorPixItau valor;
    private String chave;
    private String solicitacaoPagador;
    private List<InfoAdicionaisPixItau> infoAdicionais;

    public static GerarQrCodePixItauRequestDTO from(Bloqueto bloqueto) {
        Pessoa pessoa = bloqueto.getPessoa();
        ContatoPessoa contatoPrincipal = pessoa.getContatoPrincipal();
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        CalendarioPixItau calendario = CalendarioPixItau.builder().dataDeVencimento(bloqueto.getDataVencimento().toString()).validadeAposVencimento(Integer.valueOf(0)).build();
        DevedorPixItau devedor = DevedorPixItau.builder().cpf(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).cnpj(TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).nome(pessoa.getNome()).email((String)Optional.ofNullable(contatoPrincipal).map(ContatoPessoa::getEmail).filter(EmailValidator::isEmailValido).orElse(null)).cep((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCep).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null)).cidade((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(null)).uf((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getUnidadeFederacao).orElse(null)).logradouro((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse(null)).build();
        List infoAdicionais = InfoAdicionaisPixItau.builder().nome("codbarra").valor(bloqueto.getCodigoBarras()).build().toList();
        return GerarQrCodePixItauRequestDTO.builder().calendario(calendario).devedor(devedor).valor(new ValorPixItau(bloqueto.getValorBloqueto())).chave(bloqueto.getModeloBloqueto().getConvenio().getChavePix()).infoAdicionais(infoAdicionais).build();
    }

    public static GerarQrCodePixItauRequestDTO alteracaoQrCodePixItau(CodigoBarrasQrCodePixItauDTO boleto) {
        List infoAdicionais = InfoAdicionaisPixItau.builder().nome("codbarra").valor(boleto.getCodigoBarras()).build().toList();
        return GerarQrCodePixItauRequestDTO.builder().infoAdicionais(infoAdicionais).build();
    }

    @Generated
    GerarQrCodePixItauRequestDTO(CalendarioPixItau calendario, DevedorPixItau devedor, ValorPixItau valor, String chave, String solicitacaoPagador, List<InfoAdicionaisPixItau> infoAdicionais) {
        this.calendario = calendario;
        this.devedor = devedor;
        this.valor = valor;
        this.chave = chave;
        this.solicitacaoPagador = solicitacaoPagador;
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public static GerarQrCodePixItauRequestDTOBuilder builder() {
        return new GerarQrCodePixItauRequestDTOBuilder();
    }

    @Generated
    public CalendarioPixItau getCalendario() {
        return this.calendario;
    }

    @Generated
    public DevedorPixItau getDevedor() {
        return this.devedor;
    }

    @Generated
    public ValorPixItau getValor() {
        return this.valor;
    }

    @Generated
    public String getChave() {
        return this.chave;
    }

    @Generated
    public String getSolicitacaoPagador() {
        return this.solicitacaoPagador;
    }

    @Generated
    public List<InfoAdicionaisPixItau> getInfoAdicionais() {
        return this.infoAdicionais;
    }

    @Generated
    public void setCalendario(CalendarioPixItau calendario) {
        this.calendario = calendario;
    }

    @Generated
    public void setDevedor(DevedorPixItau devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setValor(ValorPixItau valor) {
        this.valor = valor;
    }

    @Generated
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Generated
    public void setSolicitacaoPagador(String solicitacaoPagador) {
        this.solicitacaoPagador = solicitacaoPagador;
    }

    @Generated
    public void setInfoAdicionais(List<InfoAdicionaisPixItau> infoAdicionais) {
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GerarQrCodePixItauRequestDTO)) {
            return false;
        }
        GerarQrCodePixItauRequestDTO other = (GerarQrCodePixItauRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalendarioPixItau this$calendario = this.getCalendario();
        CalendarioPixItau other$calendario = other.getCalendario();
        if (this$calendario == null ? other$calendario != null : !this$calendario.equals(other$calendario)) {
            return false;
        }
        DevedorPixItau this$devedor = this.getDevedor();
        DevedorPixItau other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        ValorPixItau this$valor = this.getValor();
        ValorPixItau other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        String this$chave = this.getChave();
        String other$chave = other.getChave();
        if (this$chave == null ? other$chave != null : !this$chave.equals(other$chave)) {
            return false;
        }
        String this$solicitacaoPagador = this.getSolicitacaoPagador();
        String other$solicitacaoPagador = other.getSolicitacaoPagador();
        if (this$solicitacaoPagador == null ? other$solicitacaoPagador != null : !this$solicitacaoPagador.equals(other$solicitacaoPagador)) {
            return false;
        }
        List this$infoAdicionais = this.getInfoAdicionais();
        List other$infoAdicionais = other.getInfoAdicionais();
        return !(this$infoAdicionais == null ? other$infoAdicionais != null : !((Object)this$infoAdicionais).equals(other$infoAdicionais));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GerarQrCodePixItauRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalendarioPixItau $calendario = this.getCalendario();
        result = result * 59 + ($calendario == null ? 43 : $calendario.hashCode());
        DevedorPixItau $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        ValorPixItau $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        String $chave = this.getChave();
        result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
        String $solicitacaoPagador = this.getSolicitacaoPagador();
        result = result * 59 + ($solicitacaoPagador == null ? 43 : $solicitacaoPagador.hashCode());
        List $infoAdicionais = this.getInfoAdicionais();
        result = result * 59 + ($infoAdicionais == null ? 43 : ((Object)$infoAdicionais).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GerarQrCodePixItauRequestDTO(calendario=" + String.valueOf(this.getCalendario()) + ", devedor=" + String.valueOf(this.getDevedor()) + ", valor=" + String.valueOf(this.getValor()) + ", chave=" + this.getChave() + ", solicitacaoPagador=" + this.getSolicitacaoPagador() + ", infoAdicionais=" + String.valueOf(this.getInfoAdicionais()) + ")";
    }
}

