/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.delbank;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoDesconto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.AddressDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.DiscountDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.DiscountItemDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.EmissaoBoletoDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.FinalBeneficiaryDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.LateFineDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.LatePaymentDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.PayerDelBankDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EmissaoBoletoDelBankDTO {
    private String type;
    private String correlationId;
    private String yourNumber;
    private String dueDate;
    private String voidDate;
    private BigDecimal amount;
    private PayerDelBankDTO payer;
    private FinalBeneficiaryDelBankDTO finalBeneficiary;
    private DiscountDelBankDTO discount;
    private LateFineDelBankDTO lateFine;
    private LatePaymentDelBankDTO latePayment;
    private static final String BANKSLIP_PIX = "BANKSLIP_PIX";
    private static final String BANKSLIP = "BANKSLIP";
    private static final String ISENTO = "ISENTO";
    private static final Long TIPO_SEM_DESCONTO = 0L;
    private static final Long TIPO_DESCONTO_FIXO = 1L;
    private static final Long TIPO_DESCONTO_PERCENTUAL = 2L;
    private static final Long TIPO_SEM_MULTA = 0L;
    private static final Long TIPO_MULTA_FIXO = 1L;
    private static final Long TIPO_MULTA_PERCENTUAL = 2L;
    private static final Long TIPO_JUROS_ISENTO = 3L;
    private static final Long TIPO_JUROS_FIXO = 1L;
    private static final Long TIPO_JUROS_PERCENTUAL = 2L;
    private static final String PERCENTUAL = "Percentage";
    private static final String FIXO = "Fixed";
    private static final String DATETIMEFORMATTER_ANO_MES_DIA = "yyyy-MM-dd";

    public static EmissaoBoletoDelBankDTO from(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240) {
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa endereco = pessoa.getEnderecoPrincipal();
        return EmissaoBoletoDelBankDTO.builder().type(boleto.getModeloBloqueto().getConvenio().getUtilizaPix() != false ? "BANKSLIP_PIX" : "BANKSLIP").dueDate(EmissaoBoletoDelBankDTO.formataData((LocalDate)boleto.getDataVencimento(), (String)"yyyy-MM-dd")).voidDate(EmissaoBoletoDelBankDTO.builderVoidDate((LocalDate)boleto.getDataVencimento(), (ParametroCNAB240)parametrosCNAB240)).amount(boleto.getValorBloqueto()).correlationId(UUID.randomUUID().toString()).yourNumber(boleto.getNossoNumero()).payer(EmissaoBoletoDelBankDTO.builderPayer((Pessoa)pessoa, (EnderecoPessoa)endereco)).finalBeneficiary(EmissaoBoletoDelBankDTO.builderFinalBeneficiary((Bloqueto)boleto)).discount(EmissaoBoletoDelBankDTO.builderDiscount((ParametroCNAB240)parametrosCNAB240, (Bloqueto)boleto)).lateFine(EmissaoBoletoDelBankDTO.builderLateFine((ParametroCNAB240)parametrosCNAB240, (Bloqueto)boleto)).latePayment(EmissaoBoletoDelBankDTO.builderLatePayment((ParametroCNAB240)parametrosCNAB240, (Bloqueto)boleto)).build();
    }

    private static String builderVoidDate(LocalDate dataVencimento, ParametroCNAB240 parametrosCNAB240) {
        Long diasBaixa = parametrosCNAB240 != null && parametrosCNAB240.getDiasBaixaDevolucao() != null && parametrosCNAB240.getDiasBaixaDevolucao() > 1L ? parametrosCNAB240.getDiasBaixaDevolucao() : 1L;
        return EmissaoBoletoDelBankDTO.formataData((LocalDate)dataVencimento.plusDays(diasBaixa), (String)"yyyy-MM-dd");
    }

    public static PayerDelBankDTO builderPayer(Pessoa pessoa, EnderecoPessoa enderecoPessoa) {
        return PayerDelBankDTO.builder().name(StringUtils.substring((String)pessoa.getNome(), (int)0, (int)40)).document(pessoa.getCnpjCpfSemMascara()).address(EmissaoBoletoDelBankDTO.builderAddress((EnderecoPessoa)enderecoPessoa)).build();
    }

    public static FinalBeneficiaryDelBankDTO builderFinalBeneficiary(Bloqueto bloqueto) {
        Hibernate.initialize((Object)bloqueto.getModeloBloqueto());
        return FinalBeneficiaryDelBankDTO.builder().name(StringUtils.substring((String)bloqueto.getModeloBloqueto().getConvenio().getEntidadeRegistro().getNome(), (int)0, (int)40)).document(bloqueto.getModeloBloqueto().getConvenio().getEntidadeRegistro().getCnpj()).address(null).build();
    }

    public static AddressDelBankDTO builderAddress(EnderecoPessoa enderecoPessoa) {
        if (Objects.nonNull(enderecoPessoa)) {
            return AddressDelBankDTO.builder().zipCode(Optional.ofNullable(enderecoPessoa.getCep()).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(StringUtils.leftPad((String)"0", (int)8, (String)"0"))).publicPlace(Optional.ofNullable(enderecoPessoa.getLogradouro()).map(logradouro -> EmissaoBoletoDelBankDTO.getPublicPlace((String)logradouro.getTipoLogradouroDescricao(), (String)logradouro.getDescricao(), (String)enderecoPessoa.getNumero(), (String)enderecoPessoa.getComplemento())).orElse("")).neighborhood(StringUtils.substring((String)Optional.ofNullable(enderecoPessoa.getBairro()).map(Bairro::getDescricao).orElse(""), (int)0, (int)15)).number(StringUtils.substring((String)Optional.ofNullable(enderecoPessoa.getNumero()).orElse("000"), (int)0, (int)15)).state(Optional.ofNullable(enderecoPessoa.getUnidadeFederacao()).map(UnidadeFederacao::getUnidadeFederacao).orElse(Optional.ofNullable(enderecoPessoa.getCidade()).map(Cidade::getUnidadeFederacao).orElse(""))).city(StringUtils.substring((String)Optional.ofNullable(enderecoPessoa.getCidade()).map(Cidade::getDescricao).orElse(""), (int)0, (int)50)).build();
        }
        return null;
    }

    private static DiscountDelBankDTO builderDiscount(ParametroCNAB240 parametrosCNAB240, Bloqueto boleto) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoDesconto() == null || TIPO_SEM_DESCONTO.equals(parametrosCNAB240.getCodigoDesconto().getId())) {
            return null;
        }
        String desconto = EmissaoBoletoDelBankDTO.tipoDesconto((CNAB240CodigoDesconto)parametrosCNAB240.getCodigoDesconto());
        if ("ISENTO".equalsIgnoreCase(desconto)) {
            return null;
        }
        return DiscountDelBankDTO.builder().type(desconto).items(EmissaoBoletoDelBankDTO.builderItensDiscount((ParametroCNAB240)parametrosCNAB240, (Bloqueto)boleto)).build();
    }

    public static String tipoDesconto(CNAB240CodigoDesconto desconto) {
        if (desconto == null || desconto.getId() == null) {
            return "ISENTO";
        }
        Long codigo = desconto.getCodigo();
        if (TIPO_DESCONTO_FIXO.equals(codigo)) {
            return "Fixed";
        }
        if (TIPO_DESCONTO_PERCENTUAL.equals(codigo)) {
            return "Percentage";
        }
        return "ISENTO";
    }

    private static List<DiscountItemDelBankDTO> builderItensDiscount(ParametroCNAB240 parametrosCNAB240, Bloqueto boleto) {
        return Stream.of(DiscountItemDelBankDTO.builder().date(boleto.getDataVencimento()).amount(parametrosCNAB240.getValorPercentualDesconto()).build()).filter(item -> item.getAmount() != null).collect(Collectors.toList());
    }

    private static LateFineDelBankDTO builderLateFine(ParametroCNAB240 parametrosCNAB240, Bloqueto boleto) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoMulta() == null || parametrosCNAB240.getCodigoMulta().getId().equals(TIPO_SEM_MULTA)) {
            return null;
        }
        String tipoMulta = EmissaoBoletoDelBankDTO.getTipoMulta((CNAB240CodigoMulta)parametrosCNAB240.getCodigoMulta());
        BigDecimal valorMulta = Optional.ofNullable(parametrosCNAB240.getValorPercentualMulta()).orElse(BigDecimal.ZERO);
        return LateFineDelBankDTO.builder().type(tipoMulta).date(boleto.getDataVencimento().plusDays(1L)).amount(valorMulta).build();
    }

    public static String getTipoMulta(CNAB240CodigoMulta multa) {
        if (multa == null || multa.getId() == null) {
            return "ISENTO";
        }
        Long id = multa.getId();
        if (TIPO_MULTA_FIXO.equals(id)) {
            return "Fixed";
        }
        if (TIPO_MULTA_PERCENTUAL.equals(id)) {
            return "Percentage";
        }
        return "ISENTO";
    }

    private static LatePaymentDelBankDTO builderLatePayment(ParametroCNAB240 parametrosCNAB240, Bloqueto boleto) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoJuros() == null || parametrosCNAB240.getCodigoJuros().getId().equals(TIPO_JUROS_ISENTO)) {
            return null;
        }
        String tipoJuros = EmissaoBoletoDelBankDTO.getTipoJuros((CNAB240CodigoJuros)parametrosCNAB240.getCodigoJuros());
        if ("ISENTO".equalsIgnoreCase(tipoJuros)) {
            return null;
        }
        BigDecimal valorJuros = Optional.ofNullable(parametrosCNAB240.getValorJurosDiaTaxa()).orElse(BigDecimal.ZERO);
        return LatePaymentDelBankDTO.builder().type(tipoJuros).date(boleto.getDataVencimento().plusDays(1L)).amount(valorJuros).build();
    }

    public static String getTipoJuros(CNAB240CodigoJuros juros) {
        if (juros == null || juros.getId() == null) {
            return "ISENTO";
        }
        Long codigoJuros = juros.getId();
        if (TIPO_JUROS_FIXO.equals(codigoJuros)) {
            return "Fixed";
        }
        if (TIPO_JUROS_PERCENTUAL.equals(codigoJuros)) {
            return "Percentage";
        }
        return "ISENTO";
    }

    public static String getPublicPlace(String tipoLogradouro, String descricaoLogradouro, String numero, String complemento) {
        String formatted = String.format("%s %s %s %s", Optional.ofNullable(tipoLogradouro).orElse(""), Optional.ofNullable(descricaoLogradouro).orElse(""), Optional.ofNullable(numero).orElse(""), Optional.ofNullable(complemento).orElse(""));
        return StringUtils.substring((String)StringUtils.normalizeSpace((String)formatted), (int)0, (int)150);
    }

    public static String formataData(LocalDate dataVencimento, String formato) {
        return dataVencimento.format(DateTimeFormatter.ofPattern(formato));
    }

    @Generated
    public static EmissaoBoletoDelBankDTOBuilder builder() {
        return new EmissaoBoletoDelBankDTOBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Generated
    public String getYourNumber() {
        return this.yourNumber;
    }

    @Generated
    public String getDueDate() {
        return this.dueDate;
    }

    @Generated
    public String getVoidDate() {
        return this.voidDate;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public PayerDelBankDTO getPayer() {
        return this.payer;
    }

    @Generated
    public FinalBeneficiaryDelBankDTO getFinalBeneficiary() {
        return this.finalBeneficiary;
    }

    @Generated
    public DiscountDelBankDTO getDiscount() {
        return this.discount;
    }

    @Generated
    public LateFineDelBankDTO getLateFine() {
        return this.lateFine;
    }

    @Generated
    public LatePaymentDelBankDTO getLatePayment() {
        return this.latePayment;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Generated
    public void setYourNumber(String yourNumber) {
        this.yourNumber = yourNumber;
    }

    @Generated
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setVoidDate(String voidDate) {
        this.voidDate = voidDate;
    }

    @Generated
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Generated
    public void setPayer(PayerDelBankDTO payer) {
        this.payer = payer;
    }

    @Generated
    public void setFinalBeneficiary(FinalBeneficiaryDelBankDTO finalBeneficiary) {
        this.finalBeneficiary = finalBeneficiary;
    }

    @Generated
    public void setDiscount(DiscountDelBankDTO discount) {
        this.discount = discount;
    }

    @Generated
    public void setLateFine(LateFineDelBankDTO lateFine) {
        this.lateFine = lateFine;
    }

    @Generated
    public void setLatePayment(LatePaymentDelBankDTO latePayment) {
        this.latePayment = latePayment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoDelBankDTO)) {
            return false;
        }
        EmissaoBoletoDelBankDTO other = (EmissaoBoletoDelBankDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$yourNumber = this.getYourNumber();
        String other$yourNumber = other.getYourNumber();
        if (this$yourNumber == null ? other$yourNumber != null : !this$yourNumber.equals(other$yourNumber)) {
            return false;
        }
        String this$dueDate = this.getDueDate();
        String other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !this$dueDate.equals(other$dueDate)) {
            return false;
        }
        String this$voidDate = this.getVoidDate();
        String other$voidDate = other.getVoidDate();
        if (this$voidDate == null ? other$voidDate != null : !this$voidDate.equals(other$voidDate)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        PayerDelBankDTO this$payer = this.getPayer();
        PayerDelBankDTO other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !this$payer.equals(other$payer)) {
            return false;
        }
        FinalBeneficiaryDelBankDTO this$finalBeneficiary = this.getFinalBeneficiary();
        FinalBeneficiaryDelBankDTO other$finalBeneficiary = other.getFinalBeneficiary();
        if (this$finalBeneficiary == null ? other$finalBeneficiary != null : !this$finalBeneficiary.equals(other$finalBeneficiary)) {
            return false;
        }
        DiscountDelBankDTO this$discount = this.getDiscount();
        DiscountDelBankDTO other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) {
            return false;
        }
        LateFineDelBankDTO this$lateFine = this.getLateFine();
        LateFineDelBankDTO other$lateFine = other.getLateFine();
        if (this$lateFine == null ? other$lateFine != null : !this$lateFine.equals(other$lateFine)) {
            return false;
        }
        LatePaymentDelBankDTO this$latePayment = this.getLatePayment();
        LatePaymentDelBankDTO other$latePayment = other.getLatePayment();
        return !(this$latePayment == null ? other$latePayment != null : !this$latePayment.equals(other$latePayment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoDelBankDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $yourNumber = this.getYourNumber();
        result = result * 59 + ($yourNumber == null ? 43 : $yourNumber.hashCode());
        String $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : $dueDate.hashCode());
        String $voidDate = this.getVoidDate();
        result = result * 59 + ($voidDate == null ? 43 : $voidDate.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        PayerDelBankDTO $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : $payer.hashCode());
        FinalBeneficiaryDelBankDTO $finalBeneficiary = this.getFinalBeneficiary();
        result = result * 59 + ($finalBeneficiary == null ? 43 : $finalBeneficiary.hashCode());
        DiscountDelBankDTO $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
        LateFineDelBankDTO $lateFine = this.getLateFine();
        result = result * 59 + ($lateFine == null ? 43 : $lateFine.hashCode());
        LatePaymentDelBankDTO $latePayment = this.getLatePayment();
        result = result * 59 + ($latePayment == null ? 43 : $latePayment.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoDelBankDTO(type=" + this.getType() + ", correlationId=" + this.getCorrelationId() + ", yourNumber=" + this.getYourNumber() + ", dueDate=" + this.getDueDate() + ", voidDate=" + this.getVoidDate() + ", amount=" + String.valueOf(this.getAmount()) + ", payer=" + String.valueOf(this.getPayer()) + ", finalBeneficiary=" + String.valueOf(this.getFinalBeneficiary()) + ", discount=" + String.valueOf(this.getDiscount()) + ", lateFine=" + String.valueOf(this.getLateFine()) + ", latePayment=" + String.valueOf(this.getLatePayment()) + ")";
    }

    @Generated
    public EmissaoBoletoDelBankDTO() {
    }

    @Generated
    public EmissaoBoletoDelBankDTO(String type, String correlationId, String yourNumber, String dueDate, String voidDate, BigDecimal amount, PayerDelBankDTO payer, FinalBeneficiaryDelBankDTO finalBeneficiary, DiscountDelBankDTO discount, LateFineDelBankDTO lateFine, LatePaymentDelBankDTO latePayment) {
        this.type = type;
        this.correlationId = correlationId;
        this.yourNumber = yourNumber;
        this.dueDate = dueDate;
        this.voidDate = voidDate;
        this.amount = amount;
        this.payer = payer;
        this.finalBeneficiary = finalBeneficiary;
        this.discount = discount;
        this.lateFine = lateFine;
        this.latePayment = latePayment;
    }
}

